/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.factories;

import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSSalesDoc;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSSalesReturn;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.factories.AbsPOSSalesInvoiceFactory;
import com.namasoft.pos.factories.POSReturnPaymentLineFactory;
import com.namasoft.pos.factories.POSSalesReturnLineFactory;

public class POSSalesReturnFactory {
    public static POSSalesReturn createPOSReturnFromDTO(DTONamaPOSSalesReturn dtoNamaPOSSalesReturn) {
        POSSalesReturn salesReturn = new POSSalesReturn();
        AbsPOSSalesInvoiceFactory.updatePOSDataFromDTO(salesReturn, (DTOAbsPOSSalesDoc)dtoNamaPOSSalesReturn);
        salesReturn.setReplacementCode(dtoNamaPOSSalesReturn.getPosReplacementCode());
        salesReturn.setReplacementId(ServerStringUtils.strToUUID((String)dtoNamaPOSSalesReturn.getPosReplacementId()));
        salesReturn.setFromInvCode(dtoNamaPOSSalesReturn.getFromInvoiceCode());
        dtoNamaPOSSalesReturn.getDetails().forEach(l -> salesReturn.getDetails().add(POSSalesReturnLineFactory.createPOSReturnLineFromDTO(salesReturn, l)));
        dtoNamaPOSSalesReturn.getPayments().forEach(l -> salesReturn.getPaymentLines().add(POSReturnPaymentLineFactory.createPOSPaymentLineFromDTO(l, salesReturn)));
        return salesReturn;
    }
}

