/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.orm;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericDimensions;
import com.namasoft.modules.namapos.contracts.common.DTOCheckFromInvQtiesReq;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSSalesDoc;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.modules.supplychain.contracts.details.DTOStockIssueLine;
import com.namasoft.modules.supplychain.contracts.dtos.DTOPOSOverDraftValidationRequest;
import com.namasoft.modules.supplychain.contracts.entities.DTOStockIssue;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOInvItemRef;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTORawQuantity;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOUserQuantity;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.displayPole.DisplayPoleConnectorUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceLine;
import com.namasoft.pos.domain.details.POSSavingSettingsLine;
import com.namasoft.pos.domain.entities.IPOSDocFromInvoice;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemQtyUpdateConfig;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSSavingSettings;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import com.namasoft.pos.orm.POSEntitySaveRequest;
import com.namasoft.pos.util.POSConfigurationUtil;
import com.namasoft.pos.util.POSEntityUtil;
import com.namasoft.pos.util.POSMoneyUtils;
import com.namasoft.pos.util.POSQuantitiesUtils;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSalesPriceUtil;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.POSWSClient;
import com.namasoft.pos.util.PosSalesUtil;
import jakarta.xml.ws.WebServiceException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class POSEntityMediator {
    public static <T extends DTOAbsPOSSalesDoc> POSResult saveOperation(POSEntitySaveRequest saveRequest) {
        boolean fromHeldOrDelayPayment;
        POSEntityMediator.updateSalesDocData(saveRequest.hold, saveRequest.paidCash, saveRequest.remainingChange, saveRequest.salesDoc, POSSettingsInfo.fetchConfiguration().getCurrentUser(), null, null);
        POSResult posResult = new POSResult();
        POSEntityMediator.checkOverDraftQuantitiesIfNeeded(saveRequest.register, saveRequest.salesDoc, saveRequest.hold, posResult);
        if (posResult.isFailed().booleanValue()) {
            return posResult;
        }
        if (ObjectChecker.isNotEmptyOrZero((BigDecimal)saveRequest.remainingChange)) {
            DisplayPoleConnectorUtil.writeRemainingMsg(saveRequest.salesDoc);
        }
        saveRequest.salesDoc.updateShiftData(saveRequest.register);
        if (saveRequest.salesDoc.getCode().contains("draft") && !saveRequest.salesDoc.getHold() && !saveRequest.salesDoc.getPaymentDelayed().booleanValue()) {
            saveRequest.salesDoc.setCode(POSCodeGenerator.generateInvoiceCode(saveRequest.salesDoc.docType(), saveRequest.register));
        }
        saveRequest.salesDoc.processCreditNotesAndCoupons(saveRequest.register, saveRequest.creditNoteInfos, saveRequest.couponsInfoInPayments).addToAccumulateResult(posResult);
        if (posResult.isFailed().booleanValue()) {
            return posResult;
        }
        AbsPOSSales absPOSSales = saveRequest.salesDoc;
        if (absPOSSales instanceof IPOSDocFromInvoice) {
            IPOSDocFromInvoice fromInvoice = (IPOSDocFromInvoice)((Object)absPOSSales);
            if (!saveRequest.hold) {
                if (POSConfigurationUtil.shouldCheckReturnAndReplacementOnServer(fromInvoice) && PosScene.connectionIsUp()) {
                    String invCode = fromInvoice.getFromInvCode();
                    DTOAbsPOSSalesDoc dto = (DTOAbsPOSSalesDoc)saveRequest.salesDoc.toDTO();
                    DTOCheckFromInvQtiesReq req = new DTOCheckFromInvQtiesReq();
                    req.setDocument((NaMaDTO)dto);
                    req.setInvoiceCode(invCode);
                    if (ObjectChecker.isNotEmptyOrNull((Object)invCode)) {
                        try {
                            ServiceResponse serviceResponse = POSWSClient.instance.checkInvRemainingQties((SendRequest<DTOCheckFromInvQtiesReq>)new SendRequest((Object)req));
                            if (!serviceResponse.succeded()) {
                                posResult.failure("Invalid Quantities", new Object[0]);
                                return posResult;
                            }
                        }
                        catch (NaMaServiceExcepption e) {
                            NaMaLogger.error((Throwable)e);
                            posResult.failure("Invalid Quantities", new Object[0]);
                            posResult.setLog(e.getFaultInfo().getLog());
                            return posResult;
                        }
                    }
                } else if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getReturnAndReplaceInvoicesLocallyIfConnectionDown()) && PosScene.connectionIsDown()) {
                    posResult.failure("Connection Failed", new Object[0]);
                    return posResult;
                }
            }
        }
        boolean fromDelayedPayment = ObjectChecker.isTrue((Boolean)saveRequest.salesDoc.getPaymentDelayed());
        AbsPOSSales invPersistedVersion = (AbsPOSSales)POSPersister.findByID(saveRequest.salesDoc.getClass(), saveRequest.salesDoc.getId());
        boolean bl = fromHeldOrDelayPayment = invPersistedVersion != null && (invPersistedVersion.getHold() || invPersistedVersion.getPaymentDelayed() != false);
        if (fromHeldOrDelayPayment || ObjectChecker.isEmptyOrNull((Object)invPersistedVersion) || saveRequest.hold || fromDelayedPayment) {
            saveRequest.salesDoc.setPaymentDelayed(saveRequest.delayPayment);
            if (POSEntityMediator.shouldSendToNamaFirst(saveRequest.register, saveRequest.salesDoc, saveRequest.hold)) {
                saveRequest.salesDoc.writeDocToServerFirstThenPOS(saveRequest.register, saveRequest.creditNoteInfos).addToAccumulateResult(posResult);
            } else {
                POSPersister.saveOrUpdateWithActionHistory(saveRequest.salesDoc).addToAccumulateResult(posResult);
                if (posResult.isFailed().booleanValue()) {
                    return posResult.failure("Save Failed", new Object[0]);
                }
                if (!saveRequest.delayPayment) {
                    saveRequest.salesDoc.writeDocToServer(saveRequest.register, saveRequest.couponsInfoInPayments, saveRequest.creditNoteInfos, null, true);
                }
            }
        } else {
            posResult.failure("Invoice already saved before - check invoice code", new Object[0]);
            return POSEntityMediator.errorMsgWhenEdit(posResult);
        }
        return posResult;
    }

    public static void updateSalesDocData(boolean hold, BigDecimal paidCash, BigDecimal remainingChange, AbsPOSSales salesDoc, POSUser user, AbsPosSalesScreen screen, Function<AbsPosSalesScreen, Void> function) {
        salesDoc.setPaidCash(paidCash);
        salesDoc.setRemainingChange(ObjectChecker.toZeroIfNull((BigDecimal)remainingChange));
        salesDoc.setHold(hold);
        salesDoc.setValueDate(new Date());
        salesDoc.setValueTime(new Date());
        POSResourcesUtil.updateDocDateAndTime(salesDoc);
        if (salesDoc.getCurrentUser() == null) {
            salesDoc.setCurrentUser(user);
        }
        POSConfigurationUtil.useUserAsSalesmanIfNeeded(salesDoc, user, Callback.NULL);
        salesDoc.getId();
        if (function != null) {
            function.apply(screen);
        }
    }

    private static void checkOverDraftQuantitiesIfNeeded(POSRegistery register, AbsPOSSales salesDoc, boolean hold, POSResult result) {
        try {
            POSItemQtyUpdateConfig config = POSQuantitiesUtils.qtyUpdateConfig();
            if (config == null) {
                return;
            }
            if (hold) {
                return;
            }
            if (!(salesDoc instanceof POSSalesInvoice)) {
                return;
            }
            POSEntityMediator.checkQuantitiesOnline(register, config, (POSSalesInvoice)salesDoc, result);
        }
        catch (WebServiceException e) {
            POSQuantitiesUtils.checkOverDraftQuantitiesOffline((POSSalesInvoice)salesDoc, result);
        }
    }

    private static void checkQuantitiesOnline(POSRegistery register, POSItemQtyUpdateConfig config, POSSalesInvoice salesDoc, POSResult result) {
        List<POSSalesInvoice> allInvoices = PosSalesUtil.collectHoldInvoices(config, salesDoc.getWarehouse(), salesDoc.getLocation(), salesDoc.getId(), salesDoc.getDetails().stream().map(AbsPOSSalesLine::getItem).distinct().collect(Collectors.toList()), result);
        DTOStockIssue issue = new DTOStockIssue();
        DTOGenericDimensions dims = POSGenericDims.toNamaGenericDims(register.getGenericDims());
        issue.setLegalEntity(dims.getLegalEntity());
        issue.setAnalysisSet(dims.getAnalysisSet());
        issue.setDepartment(dims.getDepartment());
        issue.setSector(dims.getSector());
        issue.setBranch(dims.getBranch());
        issue.setLocator(POSSavable.staticToReference(salesDoc.getLocation()));
        issue.setSubsidiary(EntityReferenceData.id((String)salesDoc.getSubsidiaryNamaType(), (String)ObjectChecker.toStringOrEmpty((Object)salesDoc.getSubsidiaryID())));
        issue.setWarehouse(POSSavable.staticToReference(salesDoc.getWarehouse()));
        issue.setCustomer(POSSavable.staticToReference(salesDoc.getCustomer()));
        issue.setValueDate(salesDoc.getValueDate());
        issue.setDetails(new ArrayList());
        allInvoices.add(salesDoc);
        List allLines = allInvoices.stream().map(POSSalesInvoice::getDetails).flatMap(Collection::stream).collect(Collectors.toList());
        HashMap<String, BigDecimal> itemQtyMap = new HashMap<String, BigDecimal>();
        for (POSSalesInvoiceLine docLine : salesDoc.getDetails()) {
            List matchedLines = allLines.stream().filter(l -> POSQuantitiesUtils.areLinesMatched(config, docLine, l)).collect(Collectors.toList());
            if (ObjectChecker.isEmptyOrNull(matchedLines)) continue;
            for (POSSalesInvoiceLine line : matchedLines) {
                DTOStockIssueLine issueLine = new DTOStockIssueLine();
                issue.getDetails().add(issueLine);
                issueLine.setItem(DTOInvItemRef.fromItem((EntityReferenceData)POSSavable.staticToReference(line.getItem())));
                issueLine.setQuantity(new DTOUserQuantity());
                issueLine.getQuantity().updateNulls();
                issueLine.getQuantity().getQuantity().setPrimeQty(POSQuantity.toDTORawQuantity(line.getQty()));
                POSItem item = POSPersister.findByID(POSItem.class, line.getItem().getId().toString());
                BigDecimal rateToBase = POSSalesPriceUtil.calcRateToBase(item.getUnits(), line.getQty().getUom());
                DTORawQuantity quantity = new DTORawQuantity();
                quantity.setUom(POSSavable.staticToReference(item.getBaseUnit()));
                quantity.setValue(rateToBase.multiply(issueLine.fetchPrimeQtyValue()));
                BigDecimal itemQty = itemQtyMap.computeIfAbsent(docLine.getItem().getId().toString(), k -> BigDecimal.ZERO);
                itemQtyMap.put(docLine.getItem().getId().toString(), itemQty.add(quantity.getValue()));
                issueLine.getQuantity().setBaseQty(quantity);
                issueLine.setSpecificDimensions(POSItemSpecificDimensions.toDTOItemSpecificDimensions(line.getItemDimensions()));
                issueLine.getSpecificDimensions().setWarehouse(POSSavable.staticToReference(line.getWarehouse()));
                issueLine.getSpecificDimensions().setLocator(POSSavable.staticToReference(line.getLocation()));
                issueLine.setGenericDimensions(dims);
            }
        }
        DTOPOSOverDraftValidationRequest request = new DTOPOSOverDraftValidationRequest();
        request.setIssue(issue);
        request.setRegisterCode(register.getCode());
        try {
            POSWSClient.instance.checkQuantitiesForPOS((SendRequest<DTOPOSOverDraftValidationRequest>)new SendRequest((Object)request));
        }
        catch (NaMaServiceExcepption e) {
            POSEntityMediator.adjustResultMessageIfNeeded(result, e, itemQtyMap);
        }
    }

    private static void adjustResultMessageIfNeeded(POSResult result, NaMaServiceExcepption e, Map<String, BigDecimal> itemQtyMap) {
        List leafFailureResults = ResultDTO.findLeafFailureResults((ResultDTO)e.getFaultInfo());
        for (ResultDTO leafFailureResult : leafFailureResults) {
            if (ObjectChecker.areEqual((Object)leafFailureResult.getRawMessage(), (Object)"Insufficient quantity for item {0} {1},Available Quantity is {2}, Reserved quantity is {3}")) {
                BigDecimal qty = NaMaMath.round((BigDecimal)itemQtyMap.get(leafFailureResult.fetchExtraInfo("itemId")), (Integer)POSMoneyUtils.displayDecimalPlaces);
                result.accumulate(leafFailureResult.getArabicMessage() + ", \u0627\u0644\u0643\u0645\u064a\u0629 \u0627\u0644\u0645\u0639\u0644\u0642\u0629: " + String.valueOf(qty), leafFailureResult.getEnglishMessage() + ", Hold quantity: " + String.valueOf(qty), true);
                continue;
            }
            result.accumulate(leafFailureResult.getArabicMessage(), leafFailureResult.getEnglishMessage(), leafFailureResult.isFailed());
        }
        result.setLog(e.getFaultInfo().getLog());
    }

    public static boolean shouldSendToNamaFirst(POSRegistery register, POSSavable doc, boolean hold) {
        if (doc instanceof IPOSDocFromInvoice && ((IPOSDocFromInvoice)((Object)doc)).isFromInvoiceOnServer().booleanValue() && !hold) {
            return true;
        }
        POSSavingSettings settings = (POSSavingSettings)ObjectChecker.getFirstNotEmptyObj((Object[])new POSSavingSettings[]{register.getSavingSettings(), (POSSavingSettings)POSSavable.staticFromReference(POSResourcesUtil.fetchPOSConfig().getInvSavingSettings())});
        if (settings == null) {
            return false;
        }
        settings = POSPersister.findByID(POSSavingSettings.class, settings.getId());
        for (POSSavingSettingsLine line : settings.getLines()) {
            if (!line.matchesDocument(doc)) continue;
            return true;
        }
        return false;
    }

    public static POSResult errorMsgWhenEdit(POSResult result) {
        try {
            throw new RuntimeException("Invalid Operation");
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            return result.failure(POSResourcesUtil.id("Invalid Operation", new Object[0]), new Object[0]);
        }
    }

    public static POSResult holdInvoice(POSRegistery register, AbsPOSSales salesDoc, String invoiceCode, String salesReturnCode) {
        POSResult result = new POSResult();
        POSDocumentType docType = salesDoc.docType();
        if (ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{salesDoc.fetchDetails(), salesDoc.fetchInvLines()}) && POSEntityUtil.isNotReservation(docType)) {
            return result.failure("Empty Lines", new Object[0]);
        }
        POSSecurityCapability capability = POSSecurityCapability.CanHoldInvoice;
        POSResult capResult = POSSecurityUtil.checkIfHasCapability(capability);
        if (!capResult.isFailed().booleanValue()) {
            if (POSEntityUtil.isInvoice(docType) && ObjectChecker.isNotEmptyOrNull(POSPersister.findByCode(POSSalesInvoice.class, invoiceCode)) && !invoiceCode.contains("draft") || POSEntityUtil.isReturn(docType) && ObjectChecker.isNotEmptyOrNull(POSPersister.findByCode(POSSalesReturn.class, salesReturnCode)) && !salesReturnCode.contains("draft") || POSEntityUtil.isReplacement(docType) && ObjectChecker.isNotEmptyOrNull(POSPersister.findByCode(POSSalesReplacement.class, salesReturnCode)) && !salesReturnCode.contains("draft")) {
                POSEntityMediator.errorMsgWhenEdit(result);
                if (result.isFailed().booleanValue()) {
                    result.failure("Code must have {0} word", "draft");
                    return result;
                }
            }
            if (ObjectChecker.isEmptyOrNull((Object)POSResourcesUtil.fetchLastOpenShift(register))) {
                return result.failure("Please open shift firstly", new Object[0]);
            }
            Class klass = POSSalesReturn.class;
            if (POSEntityUtil.isInvoice(docType)) {
                klass = POSSalesInvoice.class;
            }
            if (POSEntityUtil.isReplacement(docType)) {
                klass = POSSalesReplacement.class;
            }
            if (ObjectChecker.isNotEmptyOrNull(salesDoc.calcTables()) && (!POSEntityUtil.isInvoice(docType) || POSEntityUtil.isInvoice(docType) && !((POSSalesInvoice)salesDoc).getSplitInvoice().booleanValue())) {
                List tablesIds = salesDoc.calcTables().stream().map(POSMasterFile::getId).collect(Collectors.toList());
                List<?> holdWithSameTable = POSPersister.selectTop(klass, " where hold = true and id != :currentId and table.id in :tablesIds", 1, POSPersister.params("currentId", salesDoc.getId(), "tablesIds", tablesIds));
                if (ObjectChecker.isNotEmptyOrNull(holdWithSameTable)) {
                    return result.failure("Reserved table", new Object[0]);
                }
            }
            String draftCode = POSCodeGenerator.calcDraftCode(klass, salesDoc.getCode());
            salesDoc.setCode(draftCode);
            salesDoc.setHold(true);
            salesDoc.setHoldTime(new Date());
            POSEntitySaveRequest saveReq = new POSEntitySaveRequest();
            saveReq.hold = true;
            saveReq.paidCash = null;
            saveReq.remainingChange = null;
            saveReq.creditNoteInfos = new ArrayList<PaymentInfo>();
            saveReq.couponsInfoInPayments = new ArrayList<PaymentInfo>();
            saveReq.delayPayment = false;
            saveReq.salesDoc = salesDoc;
            saveReq.register = register;
            return POSEntityMediator.saveOperation(saveReq);
        }
        return capResult;
    }
}

