/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.win32.W32APIOptions;
import java.util.Map;

public final class KeyboardSwitcher {
    private static final int[] ARABIC_LANG_IDS = new int[]{1025, 2049, 3073, 4097, 5121, 6145, 7169, 8193, 9217, 10241, 11265, 12289, 13313, 14337, 15361, 16385};

    private KeyboardSwitcher() {
    }

    public static boolean currentLayoutIsArabic() {
        try {
            WinDef.HWND hwnd = User32.INSTANCE.GetForegroundWindow();
            if (hwnd == null) {
                return false;
            }
            int threadId = User32.INSTANCE.GetWindowThreadProcessId(hwnd, null);
            if (threadId == 0) {
                return false;
            }
            WinDef.HKL hkl = User32.INSTANCE.GetKeyboardLayout(threadId);
            if (hkl == null) {
                return false;
            }
            long hklValue = Pointer.nativeValue((Pointer)hkl.getPointer());
            int langId = (int)(hklValue & 0xFFFFL);
            return KeyboardSwitcher.isArabicLangId(langId);
        }
        catch (Throwable t) {
            NaMaLogger.error((Throwable)t);
            return false;
        }
    }

    public static boolean isArabicLangId(int langId) {
        for (int id : ARABIC_LANG_IDS) {
            if (id != langId) continue;
            return true;
        }
        return false;
    }

    public static boolean switchToEnglish() {
        return KeyboardSwitcher.switchToLayout(1033);
    }

    public static boolean switchToArabic() {
        return KeyboardSwitcher.switchToLayout(1025);
    }

    public static boolean switchToLayout(int langId) {
        try {
            WinDef.HWND hwnd = User32.INSTANCE.GetForegroundWindow();
            if (hwnd == null) {
                return false;
            }
            WinDef.HKL hkl = User32Extended.INSTANCE.LoadKeyboardLayout(String.format("%08X", langId), 1);
            if (hkl == null) {
                return false;
            }
            User32.INSTANCE.PostMessage(hwnd, 80, new WinDef.WPARAM(0L), new WinDef.LPARAM(Pointer.nativeValue((Pointer)hkl.getPointer())));
            return true;
        }
        catch (Throwable t) {
            NaMaLogger.error((Throwable)t);
            return false;
        }
    }

    public static boolean toggleEnglishArabic() {
        if (KeyboardSwitcher.currentLayoutIsArabic()) {
            return KeyboardSwitcher.switchToEnglish();
        }
        return KeyboardSwitcher.switchToArabic();
    }

    public static int currentLayoutLangId() {
        try {
            WinDef.HWND hwnd = User32.INSTANCE.GetForegroundWindow();
            if (hwnd == null) {
                return -1;
            }
            int threadId = User32.INSTANCE.GetWindowThreadProcessId(hwnd, null);
            if (threadId == 0) {
                return -1;
            }
            WinDef.HKL hkl = User32.INSTANCE.GetKeyboardLayout(threadId);
            if (hkl == null) {
                return -1;
            }
            long hklValue = Pointer.nativeValue((Pointer)hkl.getPointer());
            return (int)(hklValue & 0xFFFFL);
        }
        catch (Throwable t) {
            NaMaLogger.error((Throwable)t);
            return -1;
        }
    }

    public static String currentLayoutHex() {
        WinDef.HWND hwnd = User32.INSTANCE.GetForegroundWindow();
        int threadId = User32.INSTANCE.GetWindowThreadProcessId(hwnd, null);
        WinDef.HKL hkl = User32.INSTANCE.GetKeyboardLayout(threadId);
        return hkl == null ? "null" : Long.toHexString(Pointer.nativeValue((Pointer)hkl.getPointer()));
    }

    public static String convertArabicKeyToEnglish(String arabicChar) {
        if (arabicChar == null || arabicChar.isEmpty()) {
            return arabicChar;
        }
        if (ObjectChecker.areEqual((Object)arabicChar, (Object)"\u0644\u0627")) {
            return "b";
        }
        switch (arabicChar.charAt(0)) {
            case '\u0636': {
                return "q";
            }
            case '\u0635': {
                return "w";
            }
            case '\u062b': {
                return "e";
            }
            case '\u0642': {
                return "r";
            }
            case '\u0641': {
                return "t";
            }
            case '\u063a': {
                return "y";
            }
            case '\u0639': {
                return "u";
            }
            case '\u0647': {
                return "i";
            }
            case '\u062e': {
                return "o";
            }
            case '\u062d': {
                return "p";
            }
            case '\u062c': {
                return "[";
            }
            case '\u062f': {
                return "]";
            }
            case '\u0634': {
                return "a";
            }
            case '\u0633': {
                return "s";
            }
            case '\u064a': {
                return "d";
            }
            case '\u0628': {
                return "f";
            }
            case '\u0644': {
                return "g";
            }
            case '\u0627': {
                return "h";
            }
            case '\u062a': {
                return "j";
            }
            case '\u0646': {
                return "k";
            }
            case '\u0645': {
                return "l";
            }
            case '\u0643': {
                return ";";
            }
            case '\u0637': {
                return "'";
            }
            case '\u0626': {
                return "z";
            }
            case '\u0621': {
                return "x";
            }
            case '\u0624': {
                return "c";
            }
            case '\u0631': {
                return "v";
            }
            case '\u0649': {
                return "n";
            }
            case '\u0629': {
                return "m";
            }
            case '\u0648': {
                return ",";
            }
            case '\u0632': {
                return ".";
            }
            case '\u0638': {
                return "/";
            }
        }
        return arabicChar;
    }

    private static interface User32Extended
    extends User32 {
        public static final User32Extended INSTANCE = (User32Extended)Native.load((String)"user32", User32Extended.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public WinDef.HKL LoadKeyboardLayout(String var1, int var2);
    }
}

