/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.Converter;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.BaseEntityDTO;
import com.namasoft.contracts.common.dtos.DTOAddress;
import com.namasoft.contracts.common.dtos.DTOMoney;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOInvoiceLineMoney;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOInvoiceMoney;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOMoneyEffectDetails;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOPGWProperties;
import com.namasoft.modules.commonbasic.enums.DiscountLocation;
import com.namasoft.modules.namapos.contracts.common.IDTOPosWithAttachments;
import com.namasoft.modules.namapos.contracts.details.DTOAbsNamaPOSShiftTakenElementLine;
import com.namasoft.modules.namapos.contracts.details.DTOAbsPOSSalesLine;
import com.namasoft.modules.namapos.contracts.details.DTOAbsPOSShiftLine;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSSalesInvoiceLine;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSSalesInvoiceRemovedLine;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSSalesReplacementLine;
import com.namasoft.modules.namapos.contracts.details.DTONamaPOSSalesReturnLine;
import com.namasoft.modules.namapos.contracts.details.DTOPOSCashDrawerLine;
import com.namasoft.modules.namapos.contracts.details.DTOPOSSalesInvPaymentLine;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSPaymentRecipt;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSSalesDoc;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSShiftOpenClose;
import com.namasoft.modules.namapos.contracts.entities.DTOPOSCashDrawer;
import com.namasoft.modules.namapos.enums.InvoiceDiscountLocation;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOInvItemRef;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOItemSpecificDimensions;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOQuantity;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTORawQuantity;
import com.namasoft.modules.supplychain.contracts.valueobjects.DTOUserQuantity;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.AbsPOSPayReceipt;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.AbsPOSShiftInventory;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.details.AbsPOSSalesInvoiceLine;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.AbsPOSShiftTakenElementsPerShiftLine;
import com.namasoft.pos.domain.details.POSInventoryLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceRemovedLine;
import com.namasoft.pos.domain.details.POSSalesRepalcementLine;
import com.namasoft.pos.domain.entities.IPOSDocFromInvoiceLine;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSReturnReason;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.util.POSSalesPriceUtil;
import com.namasoft.pos.util.PosSalesUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class POSActualDTOConverter {
    private static Map<DiscountLocation, BiConsumer<DTOAbsPOSSalesLine, BigDecimal>> hDisc2Setters = null;

    public static NaMaDTO convertToDTO(AbsPOSSales actual, DTOAbsPOSSalesDoc dto) {
        dto.setId(ServerStringUtils.toUUIDStr((Object)actual.getId()));
        dto.setCustomer(POSMasterFile.toRef(actual.getCustomer()));
        dto.setDriver(POSMasterFile.toRef(actual.getDriver()));
        dto.setShiftId(ServerStringUtils.toUUIDStr((Object)actual.getShiftId()));
        dto.setShiftCode(actual.getShiftCode());
        dto.setWarehouse(POSMasterFile.toRef(actual.getWarehouse()));
        dto.setSalesMan(POSMasterFile.toRef(actual.getSalesMan()));
        dto.setLocator(POSMasterFile.toRef(actual.getLocation()));
        dto.setInvCode(actual.getCode());
        dto.setRegister(POSMasterFile.toRef(POSResourcesUtil.fetchRegisterIgnoringInActiveAndPreventUsage(actual.getRegisterId())));
        DTOInvoiceMoney money = new DTOInvoiceMoney();
        money.updateNulls();
        money.setCurrency(POSMasterFile.toRef(actual.getCurrency()));
        money.setCurrencyRate(actual.getCurrencyRate());
        money.setTotal(actual.getTotalPrice());
        money.setCashAmount(actual.getPaidCash());
        money.setRemainingCash(actual.getRemainingChange());
        money.setPaidCash(actual.getPaidCash());
        money.setTotalPaid(actual.getTotalPaid());
        money.setNetValue(actual.getNetPrice());
        money.getHeaderDiscount().setPercentage(actual.getDiscountPercent());
        dto.setMoney(money);
        dto.setRemarks(actual.getRemarks());
        dto.setValueDate(actual.getValueDate());
        dto.setPosCreationTime(actual.convertDateToDateTimeString(actual.getValueTime()));
        dto.setIssueDate(dto.getValueDate());
        List<? extends AbsPOSSalesLine> posSalesLines = actual.fetchDetails();
        List<? extends AbsPOSSalesLine> posSalesRemovedLines = actual.fetchRemovedLines();
        if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getDoNotMergeSalesLines())) {
            posSalesLines = POSActualDTOConverter.mergeLines(actual.fetchDetails());
            posSalesRemovedLines = POSActualDTOConverter.mergeLines(actual.fetchRemovedLines());
        }
        dto.updateDetails(CollectionsUtility.convert(posSalesLines, POSActualDTOConverter.salesLineConverter(actual)));
        dto.updateRemovedLines(CollectionsUtility.convert(posSalesRemovedLines, POSActualDTOConverter.salesLineConverter(actual)));
        dto.updatePayments(CollectionsUtility.convert(actual.fetchPayments(), POSActualDTOConverter.paymentLineConverter(actual)));
        dto.setFirstAuthor(POSMasterFile.toRef((POSMasterFile)ObjectChecker.getFirstNotNullObj((Object[])new POSUser[]{actual.getCurrentUser(), POSSettingsInfo.fetchConfiguration().getCurrentUser()})));
        dto.setDocCategory(POSMasterFile.toRef(actual.getDocCategory()));
        dto.setPriceClassifier1(POSMasterFile.toRef(actual.getPriceClassifier1()));
        dto.setPriceClassifier2(POSMasterFile.toRef(actual.getPriceClassifier2()));
        dto.setPriceClassifier3(POSMasterFile.toRef(actual.getPriceClassifier3()));
        dto.setPriceClassifier4(POSMasterFile.toRef(actual.getPriceClassifier4()));
        dto.setPriceClassifier5(POSMasterFile.toRef(actual.getPriceClassifier5()));
        actual.copyCommonToDTO((BaseEntityDTO)dto);
        dto.setShippingAddress(new DTOAddress());
        if (ObjectChecker.isNotEmptyOrNull((Object)actual.getAddress())) {
            dto.getShippingAddress().setAddress1(actual.getAddress());
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)actual.getAddressRegion())) {
            dto.getShippingAddress().setRegion(POSMasterFile.toRef(actual.getAddressRegion()));
        }
        POSActualDTOConverter.copyHeaderDisc2ToLine(actual, dto);
        dto.setSubsidiary(POSMasterFile.toRef(actual.getSubsidiaryType(), actual.getSubsidiaryID()));
        POSActualDTOConverter.updateDocAttachments(actual, (IDTOPosWithAttachments)dto);
        dto.setInvoiceClassification(POSMasterFile.toRef(actual.getPosInvoiceClassification()));
        return dto;
    }

    private static <T extends AbsPOSSalesLine> List<T> mergeLines(List<T> collectedLines) {
        ArrayList<AbsPOSSalesLine> lines = new ArrayList<AbsPOSSalesLine>();
        LinkedHashMap map = new LinkedHashMap();
        int i = 0;
        for (AbsPOSSalesLine absPOSSalesLine : collectedLines) {
            if (absPOSSalesLine.getFreeLine().booleanValue()) {
                lines.add(absPOSSalesLine);
                ++i;
                continue;
            }
            if (ObjectChecker.isNotEmptyOrNull((Object)absPOSSalesLine.getItem())) {
                String key = PosSalesUtil.generateKey(absPOSSalesLine);
                if (map.containsKey(key)) {
                    List list = (List)map.get(key);
                    list.add(i);
                } else {
                    ArrayList<Integer> indeces = new ArrayList<Integer>();
                    indeces.add(i);
                    map.put(key, indeces);
                }
            }
            ++i;
        }
        for (Map.Entry entry : map.entrySet()) {
            AbsPOSSalesLine srcLine = (AbsPOSSalesLine)collectedLines.get((Integer)((List)entry.getValue()).get(0));
            Object invoiceLine = POSSalesPriceUtil.copySalesLine(srcLine.getQty().getValue(), srcLine);
            lines.add((AbsPOSSalesLine)invoiceLine);
            BigDecimal value = BigDecimal.ZERO;
            for (Integer lineIndex : (List)entry.getValue()) {
                value = value.add(((AbsPOSSalesLine)collectedLines.get(lineIndex)).getQty().getValue());
            }
            ((AbsPOSSalesLine)invoiceLine).getQty().setValue(value);
        }
        for (int j = lines.size() - 1; j >= 0; --j) {
            if (((AbsPOSSalesLine)lines.get(j)).getQty().getValue().compareTo(BigDecimal.ZERO) != 0) continue;
            lines.remove(j);
        }
        return lines;
    }

    private static Converter<AbsPOSPaymentLine, DTOPOSSalesInvPaymentLine> paymentLineConverter(AbsPOSSales posSalesInvoice) {
        return object -> {
            DTOPOSSalesInvPaymentLine line = new DTOPOSSalesInvPaymentLine();
            line.setInvCode(posSalesInvoice.getCode());
            line.setPaymentValue(object.getValue());
            line.setAuthorizationNumber(object.getAuthorizationNumber());
            line.setPaymentMethodName(object.getMethodName());
            POSPaymentMethod method = POSPersister.findByID(POSPaymentMethod.class, object.getPaymentMethodId());
            if (ObjectChecker.isNotEmptyOrNull((Object)method)) {
                line.setPaymentMethod(POSMasterFile.toRef(method));
                if (ObjectChecker.areEqual((Object)ObjectChecker.toStringOrEmpty((Object)MultiplePaymentDialog.cashMethodID()), (Object)line.getPaymentMethod().getId())) {
                    line.setPaymentValue(line.getPaymentValue().subtract(posSalesInvoice.getRemainingChange()));
                }
            }
            if (ObjectChecker.isEmptyOrNull((Object)line.getPgwProperties())) {
                line.setPgwProperties(new DTOPGWProperties());
            }
            line.getPgwProperties().setPaidFromTerminal(object.getPaidFromTerminal());
            line.getPgwProperties().setPanNum(object.getPanNum());
            line.getPgwProperties().setStanNum(object.getStanNum());
            line.getPgwProperties().setSchemeId(object.getSchemeId());
            line.getPgwProperties().setMerchantId(object.getMerchantId());
            line.getPgwProperties().setEcrRefNum(object.getEcrRefNum());
            line.getPgwProperties().setTerminalId(object.getTerminalId());
            return line;
        };
    }

    private static Converter<AbsPOSSalesLine, DTOAbsPOSSalesLine> salesLineConverter(AbsPOSSales posSalesInvoice) {
        return frontEndSalesLine -> {
            if (ObjectChecker.isNotEmptyOrNull((Object)frontEndSalesLine.getItemCode())) {
                POSLocation location;
                POSWarehouse warehouse;
                Object namaSalesLine = null;
                namaSalesLine = posSalesInvoice.calcNamaEntityType().equalsIgnoreCase("NamaPOSSalesInvoice") ? (frontEndSalesLine instanceof POSSalesInvoiceRemovedLine ? new DTONamaPOSSalesInvoiceRemovedLine() : new DTONamaPOSSalesInvoiceLine()) : (posSalesInvoice.calcNamaEntityType().equalsIgnoreCase("NamaPOSSalesReturn") ? new DTONamaPOSSalesReturnLine() : new DTONamaPOSSalesReplacementLine());
                namaSalesLine.setPosCreationDate(posSalesInvoice.getValueDate());
                namaSalesLine.setPosCreationTime(posSalesInvoice.convertDateToDateTimeString(posSalesInvoice.getValueTime()));
                namaSalesLine.setInvCode(posSalesInvoice.getCode());
                if (ObjectChecker.areAllNotEmptyOrNull((Object[])new Object[]{frontEndSalesLine.getRef1NamaType(), frontEndSalesLine.getRef1Id()})) {
                    namaSalesLine.setRef1(new EntityReferenceData(frontEndSalesLine.getRef1NamaType(), ServerStringUtils.toUUIDStr((Object)frontEndSalesLine.getRef1Id())));
                }
                namaSalesLine.setInvId(ServerStringUtils.toUUIDStr((Object)posSalesInvoice.getId()));
                namaSalesLine.setRegisterCode(POSResourcesUtil.fetchRegisterIgnoringInActiveAndPreventUsage(posSalesInvoice.getRegisterId()).getCode());
                namaSalesLine.setShiftId(ServerStringUtils.toUUIDStr((Object)posSalesInvoice.getShiftId()));
                namaSalesLine.setShiftCode(posSalesInvoice.getShiftCode());
                namaSalesLine.setWarehouseIssueMethod(frontEndSalesLine.getWarehouseIssueMethod());
                namaSalesLine.setId(ServerStringUtils.toUUIDStr((Object)frontEndSalesLine.getId()));
                DTOInvItemRef item = new DTOInvItemRef();
                POSItem frontEndItem = null;
                frontEndItem = ObjectChecker.isNotEmptyOrNull((Object)frontEndSalesLine.getItem()) ? POSPersister.findByID(POSItem.class, frontEndSalesLine.getItem().getId().toString()) : (POSItem)POSPersister.findByCode(POSItem.class, (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{frontEndSalesLine.getItemActualCode(), frontEndSalesLine.getItemCode()}));
                item.setItem(POSMasterFile.toRef(frontEndItem));
                item.setItemCode((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{frontEndSalesLine.getItemCode(), frontEndSalesLine.getItemActualCode()}));
                item.setItemName1(frontEndItem.getName1());
                item.setItemName2(frontEndItem.getName2());
                namaSalesLine.setItem(item);
                namaSalesLine.putDepreciationReason(POSMasterFile.toRef(frontEndSalesLine.getDepreciationReason()));
                namaSalesLine.setSalesMan(POSMasterFile.toRef(frontEndSalesLine.getSalesman()));
                DTOUserQuantity userQuantity = new DTOUserQuantity();
                DTOQuantity quantity = new DTOQuantity();
                DTORawQuantity primeQty = new DTORawQuantity();
                primeQty.setUom(POSMasterFile.toRef(frontEndSalesLine.getQty().getUom()));
                primeQty.setValue(frontEndSalesLine.getQty().getValue().abs());
                quantity.setPrimeQty(primeQty);
                userQuantity.setQuantity(quantity);
                namaSalesLine.setQuantity(userQuantity);
                String sourceType = "";
                sourceType = posSalesInvoice instanceof POSSalesInvoice ? "NamaPOSSalesInvoice" : (posSalesInvoice instanceof POSSalesReturn ? "NamaPOSSalesReturn" : "NamaPOSSalesReplacement");
                namaSalesLine.setSourceType(sourceType);
                namaSalesLine.setSpecificDimensions(new DTOItemSpecificDimensions());
                namaSalesLine.getSpecificDimensions().setColor(frontEndSalesLine.getItemDimensions().getColor());
                namaSalesLine.getSpecificDimensions().setSize(frontEndSalesLine.getItemDimensions().getSize());
                namaSalesLine.getSpecificDimensions().setLotId(frontEndSalesLine.getItemDimensions().getLotId());
                namaSalesLine.getSpecificDimensions().setSerialNumber(frontEndSalesLine.getItemDimensions().getSerialNumber());
                namaSalesLine.getSpecificDimensions().setRevisionId(frontEndSalesLine.getItemDimensions().getRevisionId());
                POSWarehouse pOSWarehouse = warehouse = ObjectChecker.isNotEmptyOrNull((Object)frontEndSalesLine.getWarehouse()) ? frontEndSalesLine.getWarehouse() : posSalesInvoice.getWarehouse();
                if (ObjectChecker.isNotEmptyOrNull((Object)warehouse)) {
                    warehouse = POSPersister.materializeProxy(POSWarehouse.class, warehouse);
                    namaSalesLine.getSpecificDimensions().setWarehouse(POSMasterFile.toRef(warehouse));
                }
                if (ObjectChecker.isNotEmptyOrNull((Object)(location = (POSLocation)ObjectChecker.getFirstNotNullObj((Object[])new POSLocation[]{frontEndSalesLine.getLocation(), posSalesInvoice.getLocation()})))) {
                    location = POSPersister.materializeProxy(POSLocation.class, location);
                    namaSalesLine.getSpecificDimensions().setLocator(POSMasterFile.toRef(location));
                }
                DTOInvoiceLineMoney price = new DTOInvoiceLineMoney();
                price.updateNulls();
                price.setUnitPrice(frontEndSalesLine.getUnitPrice());
                price.setPrice(frontEndSalesLine.getTotalPrice());
                DTOMoneyEffectDetails discount1 = new DTOMoneyEffectDetails();
                discount1.setPercentage(frontEndSalesLine.getDiscount1().getPercentage());
                discount1.setValue(frontEndSalesLine.getDiscount1().getValue());
                price.setDiscount1(discount1);
                DTOMoneyEffectDetails discount2 = new DTOMoneyEffectDetails();
                discount2.setPercentage(frontEndSalesLine.getDiscount2().getPercentage());
                discount2.setValue(frontEndSalesLine.getDiscount2().getValue());
                price.setDiscount2(discount2);
                DTOMoneyEffectDetails tax1 = new DTOMoneyEffectDetails();
                tax1.setMaxNormalPercent(frontEndSalesLine.getTax1().getPercentage());
                tax1.setValue(frontEndSalesLine.getTax1().getValue());
                price.setTax1(tax1);
                DTOMoneyEffectDetails tax2 = new DTOMoneyEffectDetails();
                tax2.setMaxNormalPercent(frontEndSalesLine.getTax2().getPercentage());
                tax2.setValue(frontEndSalesLine.getTax2().getValue());
                price.setTax2(tax2);
                DTOMoneyEffectDetails discount3 = new DTOMoneyEffectDetails();
                discount3.setPercentage(frontEndSalesLine.getDiscount3().getPercentage());
                discount3.setValue(frontEndSalesLine.getDiscount3().getValue());
                price.setDiscount3(discount3);
                DTOMoneyEffectDetails discount4 = new DTOMoneyEffectDetails();
                discount4.setPercentage(frontEndSalesLine.getDiscount4().getPercentage());
                discount4.setValue(frontEndSalesLine.getDiscount4().getValue());
                price.setDiscount4(discount4);
                DTOMoneyEffectDetails discount5 = new DTOMoneyEffectDetails();
                discount5.setPercentage(frontEndSalesLine.getDiscount5().getPercentage());
                discount5.setValue(frontEndSalesLine.getDiscount5().getValue());
                price.setDiscount5(discount5);
                DTOMoneyEffectDetails discount6 = new DTOMoneyEffectDetails();
                discount6.setPercentage(frontEndSalesLine.getDiscount6().getPercentage());
                discount6.setValue(frontEndSalesLine.getDiscount6().getValue());
                price.setDiscount6(discount6);
                DTOMoneyEffectDetails discount7 = new DTOMoneyEffectDetails();
                discount7.setPercentage(frontEndSalesLine.getDiscount7().getPercentage());
                discount7.setValue(frontEndSalesLine.getDiscount7().getValue());
                price.setDiscount7(discount7);
                DTOMoneyEffectDetails discount8 = new DTOMoneyEffectDetails();
                discount8.setPercentage(frontEndSalesLine.getDiscount8().getPercentage());
                discount8.setValue(frontEndSalesLine.getDiscount8().getValue());
                price.setDiscount8(discount8);
                price.setNetValue(frontEndSalesLine.getNetPrice());
                namaSalesLine.setPrice(price);
                namaSalesLine.setFreeLine(frontEndSalesLine.getFreeLine());
                if (frontEndSalesLine instanceof IPOSDocFromInvoiceLine) {
                    namaSalesLine.setSourceLineId(ServerStringUtils.toUUIDStr((Object)((IPOSDocFromInvoiceLine)((Object)frontEndSalesLine)).getInvoiceLineId()));
                    POSReturnReason returnReason = ((IPOSDocFromInvoiceLine)((Object)frontEndSalesLine)).getReturnReason();
                    namaSalesLine.putReturnReason(returnReason != null ? returnReason.toEntityReferenceData() : null);
                }
                if (frontEndSalesLine instanceof POSSalesRepalcementLine && ((POSSalesRepalcementLine)frontEndSalesLine).getReturnedLine().booleanValue()) {
                    ((DTONamaPOSSalesReplacementLine)namaSalesLine).setReturnedLine(Boolean.valueOf(true));
                }
                if (posSalesInvoice instanceof POSSalesInvoice) {
                    namaSalesLine.setReturnedQty(((AbsPOSSalesInvoiceLine)frontEndSalesLine).getReturnedQty());
                }
                if (posSalesInvoice instanceof POSSalesReturn) {
                    POSSalesReturn posSalesReturn = (POSSalesReturn)posSalesInvoice;
                    ((DTONamaPOSSalesReturnLine)namaSalesLine).setSrcInvoiceFromAnotherRegistr(posSalesReturn.getSrcInvoiceFromRemoteRegister());
                    if (ObjectChecker.isNotEmptyOrNull((Object)posSalesReturn.getSrcInvoiceRegisterId())) {
                        ((DTONamaPOSSalesReturnLine)namaSalesLine).setSrcInvoiceRegister(POSMasterFile.toRef("NamaPOSRegister", posSalesReturn.getSrcInvoiceRegisterId()));
                    }
                }
                namaSalesLine.setProductionDate(frontEndSalesLine.getProductionDate());
                namaSalesLine.setExpiryDate(frontEndSalesLine.getExpiryDate());
                return namaSalesLine;
            }
            return null;
        };
    }

    private static void copyHeaderDisc2ToLine(AbsPOSSales posSalesInvoice, DTOAbsPOSSalesDoc dtoNamaPOSSalesInvoice) {
        BigDecimal discount2Value = posSalesInvoice.getDiscount2Value();
        if (ObjectChecker.isEmptyOrZero((BigDecimal)discount2Value)) {
            return;
        }
        String hDisc2Location = POSResourcesUtil.fetchPOSConfig().getHeaderDiscount2Location();
        if (ObjectChecker.isEmptyOrNull((Object)hDisc2Location)) {
            hDisc2Location = InvoiceDiscountLocation.Discount8.toString();
        }
        DTOAbsPOSSalesLine matchLine = dtoNamaPOSSalesInvoice.fetchDetails().stream().filter(o -> ObjectChecker.isFalse((Boolean)o.getFreeLine()) && o.getPrice().getNetValue().compareTo(discount2Value) > 0).findFirst().get();
        POSActualDTOConverter.hDisc2Setters().get(DiscountLocation.valueOf((String)hDisc2Location)).accept(matchLine, discount2Value);
    }

    public static void updateDocAttachments(AbsPOSSales actual, IDTOPosWithAttachments dto) {
        if (ObjectChecker.isNotEmptyOrNull((Object)actual.getAttach1FilePath())) {
            dto.setAttachment1(actual.createLargeData(actual.getAttach1FilePath()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)actual.getAttach2FilePath())) {
            dto.setAttachment2(actual.createLargeData(actual.getAttach2FilePath()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)actual.getAttach3FilePath())) {
            dto.setAttachment3(actual.createLargeData(actual.getAttach3FilePath()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)actual.getAttach4FilePath())) {
            dto.setAttachment4(actual.createLargeData(actual.getAttach4FilePath()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)actual.getAttach5FilePath())) {
            dto.setAttachment5(actual.createLargeData(actual.getAttach5FilePath()));
        }
    }

    private static Map<DiscountLocation, BiConsumer<DTOAbsPOSSalesLine, BigDecimal>> hDisc2Setters() {
        if (hDisc2Setters != null) {
            return hDisc2Setters;
        }
        hDisc2Setters.put(DiscountLocation.Discount1, (l, p) -> l.getPrice().getDiscount1().setValue(p));
        hDisc2Setters.put(DiscountLocation.Discount2, (l, p) -> l.getPrice().getDiscount2().setValue(p));
        hDisc2Setters.put(DiscountLocation.Discount3, (l, p) -> l.getPrice().getDiscount3().setValue(p));
        hDisc2Setters.put(DiscountLocation.Discount4, (l, p) -> l.getPrice().getDiscount4().setValue(p));
        hDisc2Setters.put(DiscountLocation.Discount5, (l, p) -> l.getPrice().getDiscount5().setValue(p));
        hDisc2Setters.put(DiscountLocation.Discount6, (l, p) -> l.getPrice().getDiscount6().setValue(p));
        hDisc2Setters.put(DiscountLocation.Discount7, (l, p) -> l.getPrice().getDiscount7().setValue(p));
        hDisc2Setters.put(DiscountLocation.Discount8, (l, p) -> l.getPrice().getDiscount8().setValue(p));
        return hDisc2Setters;
    }

    public static NaMaDTO convertToDTO(AbsPOSPayReceipt payment, DTOAbsPOSPaymentRecipt paymentToRegister) {
        paymentToRegister.setId(payment.getId().toString());
        paymentToRegister.setSubsidiary(new EntityReferenceData(payment.getSubsidiaryType(), ServerStringUtils.toUUIDStr((Object)payment.getSubsidiaryID()), payment.getSubsidiaryCode(), new Date()));
        if (ObjectChecker.isNotEmptyOrNull((Object)payment.getAttach1FilePath())) {
            paymentToRegister.setAttachment1(payment.createLargeData(payment.getAttach1FilePath()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)payment.getAttach2FilePath())) {
            paymentToRegister.setAttachment2(payment.createLargeData(payment.getAttach2FilePath()));
        }
        paymentToRegister.setDocCategory(POSMasterFile.toRef(payment.getDocCategory()));
        POSRegistery currentRegister = POSResourcesUtil.fetchRegisterIgnoringInActiveAndPreventUsage(payment.getRegisterId());
        paymentToRegister.setCurrentRegister(POSMasterFile.toRef(currentRegister));
        paymentToRegister.setShiftCode(payment.getShiftCode());
        DTOMoney money = new DTOMoney();
        POSCurrency currency = payment.getCurrency();
        money.setCurrency(POSMasterFile.toRef(currency));
        money.setAmount(payment.getValue());
        paymentToRegister.setMoney(money);
        paymentToRegister.setDocToPayCode(payment.getNamaDocToPayCode());
        paymentToRegister.setRemarks(payment.getRemarks());
        paymentToRegister.setValueDate(payment.getValueDate());
        paymentToRegister.setPosCreationTime(payment.convertDateToDateTimeString(payment.getValueTime()));
        paymentToRegister.setIssueDate(paymentToRegister.getValueDate());
        paymentToRegister.setFirstAuthor(POSMasterFile.toRef((POSMasterFile)ObjectChecker.getFirstNotNullObj((Object[])new POSUser[]{payment.getCurrentUser(), POSSettingsInfo.fetchConfiguration().getCurrentUser()})));
        paymentToRegister.setPosCode(payment.getCode());
        paymentToRegister.setPaymentMethod(POSMasterFile.toRef(payment.getPaymentMethod()));
        paymentToRegister.setShiftOpenId(ServerStringUtils.toUUIDStr((Object)payment.getShiftOpenId()));
        return paymentToRegister;
    }

    public static void copyBasicData(AbsPOSShiftInventory shift, DTOAbsPOSShiftOpenClose doc) {
        doc.setShiftDate(shift.getShiftDate());
        doc.setShiftTime(shift.getShiftTime());
        doc.setRegistery(POSMasterFile.toRef(shift.register()));
        doc.setValueDate(shift.getShiftDate());
        doc.setIssueDate(doc.getValueDate());
        doc.setShiftCode(shift.getCode());
        doc.setRemarks(shift.getRemarks());
        if (ObjectChecker.isNotEmptyOrNull((Object)shift.getAttach1FilePath())) {
            doc.setAttachment1(shift.createLargeData(shift.getAttach1FilePath()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)shift.getAttach2FilePath())) {
            doc.setAttachment2(shift.createLargeData(shift.getAttach2FilePath()));
        }
        EntityReferenceData shiftUser = POSMasterFile.toRef(shift.getPosUser());
        doc.setShiftUser(shiftUser);
        doc.setFirstAuthor(POSMasterFile.toRef((POSMasterFile)ObjectChecker.getFirstNotNullObj((Object[])new POSUser[]{shift.getPosUser(), POSSettingsInfo.fetchConfiguration().getCurrentUser()})));
        doc.setId(ServerStringUtils.toUUIDStr((Object)shift.getId()));
    }

    public static void copyShiftTakingElementLine(AbsPOSShiftTakenElementsPerShiftLine line, DTOAbsNamaPOSShiftTakenElementLine dtoLine) {
        dtoLine.setElement(line.getElement().toEntityRefData());
        dtoLine.setDescription(line.getDescription());
        dtoLine.setValue(line.getQtyValue());
        dtoLine.setRemarks(line.getRemarks());
    }

    public static void shiftLineCopier(AbsPOSInventoryLine line, DTOAbsPOSShiftLine dtoLine) {
        EntityReferenceData paymentMethod = null;
        if (ObjectChecker.isNotEmptyOrNull((Object)line.getPaymentMethodId())) {
            paymentMethod = EntityReferenceData.id((String)"PaymentMethod", (String)line.getPaymentMethodId().toString());
        }
        dtoLine.setPaymentMethod(paymentMethod);
        dtoLine.setPaymentWay(line.getPaymentWay());
        dtoLine.setCurrency(line.getCurrency());
        dtoLine.setAccountantRemaining(line.getAccountantRemaining());
        dtoLine.setDifference(line.getDifference());
        dtoLine.setActualRemaining(line.getActualRemaining());
        dtoLine.setNarration(line.getNarration());
        dtoLine.setNarration2(line.getNarration2());
    }

    public static void addLinesToCashDrawer(List<POSInventoryLine> details, DTOPOSCashDrawer dtoCashDrawer) {
        for (POSInventoryLine line : details) {
            DTOPOSCashDrawerLine cashLine = new DTOPOSCashDrawerLine();
            cashLine.setPaymentWay(line.getPaymentWay());
            cashLine.setCurrency(line.getCurrency());
            cashLine.setAccountantRemaining(line.getAccountantRemaining());
            cashLine.setActualRemaining(line.getActualRemaining());
            cashLine.setDifference(line.getDifference());
            dtoCashDrawer.getDetails().add(cashLine);
        }
    }
}

