/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.util.POSDataReaderUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class POSDataReaderRunner
implements Runnable {
    private ThreadFactory daemonThreadFactory = r -> {
        Thread thread = new Thread(r, "POSDataReaderRunner");
        thread.setUncaughtExceptionHandler(POSResourcesUtil.uncaughtExceptionsHandler);
        thread.setDaemon(true);
        return thread;
    };
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(this.daemonThreadFactory);
    private static POSDataReaderRunner instance = new POSDataReaderRunner();

    public static POSDataReaderRunner instance() {
        return instance;
    }

    private POSDataReaderRunner() {
    }

    @Override
    public void run() {
        POSDataReaderUtil.loadData(this.executor, this);
    }

    public static void stop() {
        if (POSDataReaderRunner.instance().executor != null) {
            NaMaLogger.info((Object)"***************///// Shutting down POSDataReaderRunner \\\\\\\\\\********");
            POSDataReaderRunner.instance().executor.shutdownNow();
        }
    }

    public static void start() {
        POSDataReaderRunner.instance().executor.schedule(POSDataReaderRunner.instance(), 0L, TimeUnit.MILLISECONDS);
    }
}

