/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.Pair;
import com.namasoft.common.ResultDTO;
import com.namasoft.common.constants.NaMaErrors;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.contracts.common.dtos.requests.ListApprovalsRequest;
import com.namasoft.contracts.common.dtos.requests.SendListRequest;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.modules.commonbasic.contracts.entities.DTOConfigEntry;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOUserNotification;
import com.namasoft.modules.namapos.contracts.common.DTOAggrPOSReadQueueResp;
import com.namasoft.modules.namapos.contracts.common.DTOPOSCompressedReadResp;
import com.namasoft.modules.namapos.contracts.common.DTOPOSReadMsg;
import com.namasoft.modules.namapos.contracts.common.DTOPOSReadQueueRequest;
import com.namasoft.modules.namapos.contracts.common.DTOPOSReadQueueResponse;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.pos.application.POSJDBCQueryRunner;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.POSPaymentToRegistery;
import com.namasoft.pos.domain.POSReceiptFromRegistery;
import com.namasoft.pos.domain.PosMobileUISettings;
import com.namasoft.pos.domain.PosUISettings;
import com.namasoft.pos.domain.details.POSFavouriteLine;
import com.namasoft.pos.domain.entities.POSAlias;
import com.namasoft.pos.domain.entities.POSAnalysisset;
import com.namasoft.pos.domain.entities.POSBranch;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSCustomerCategory;
import com.namasoft.pos.domain.entities.POSCustomerClass;
import com.namasoft.pos.domain.entities.POSDepartment;
import com.namasoft.pos.domain.entities.POSDepreciationReason;
import com.namasoft.pos.domain.entities.POSDiscountCoupon;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSExchangeRate;
import com.namasoft.pos.domain.entities.POSExtraFilter;
import com.namasoft.pos.domain.entities.POSFreeItemGroup;
import com.namasoft.pos.domain.entities.POSGenReference;
import com.namasoft.pos.domain.entities.POSGenericReferenceOverrider;
import com.namasoft.pos.domain.entities.POSHall;
import com.namasoft.pos.domain.entities.POSHasUpdateDataWithSession;
import com.namasoft.pos.domain.entities.POSInternalMessage;
import com.namasoft.pos.domain.entities.POSInventory;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemBarcodeParser;
import com.namasoft.pos.domain.entities.POSItemBrand;
import com.namasoft.pos.domain.entities.POSItemCategory;
import com.namasoft.pos.domain.entities.POSItemClass1;
import com.namasoft.pos.domain.entities.POSItemClass10;
import com.namasoft.pos.domain.entities.POSItemClass2;
import com.namasoft.pos.domain.entities.POSItemClass3;
import com.namasoft.pos.domain.entities.POSItemClass4;
import com.namasoft.pos.domain.entities.POSItemClass5;
import com.namasoft.pos.domain.entities.POSItemClass6;
import com.namasoft.pos.domain.entities.POSItemClass7;
import com.namasoft.pos.domain.entities.POSItemClass8;
import com.namasoft.pos.domain.entities.POSItemClass9;
import com.namasoft.pos.domain.entities.POSItemConfig;
import com.namasoft.pos.domain.entities.POSItemQtyUpdateConfig;
import com.namasoft.pos.domain.entities.POSItemSection;
import com.namasoft.pos.domain.entities.POSLegalEntity;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSNotification;
import com.namasoft.pos.domain.entities.POSPaymentMethodsSettings;
import com.namasoft.pos.domain.entities.POSPricingRange;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSReportDefinition;
import com.namasoft.pos.domain.entities.POSReturnReason;
import com.namasoft.pos.domain.entities.POSRewardPointConfig;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesOffers;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier1;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier2;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier3;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier4;
import com.namasoft.pos.domain.entities.POSSalesPriceClassifier5;
import com.namasoft.pos.domain.entities.POSSalesPriceList;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSSavingSettings;
import com.namasoft.pos.domain.entities.POSSector;
import com.namasoft.pos.domain.entities.POSSecurity;
import com.namasoft.pos.domain.entities.POSServiceChargeSettings;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSShiftClose;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSStockTransferReq;
import com.namasoft.pos.domain.entities.POSTable;
import com.namasoft.pos.domain.entities.POSTaxPlan;
import com.namasoft.pos.domain.entities.POSTranslationOverrider;
import com.namasoft.pos.domain.entities.POSUnit;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.POSVendor;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.entities.PosAddressRegion;
import com.namasoft.pos.domain.entities.PosDefaultsTemplate;
import com.namasoft.pos.domain.entities.PosDeliveryCost;
import com.namasoft.pos.domain.entities.PosDocCategory;
import com.namasoft.pos.domain.entities.PosItemAdditionalItems;
import com.namasoft.pos.domain.entities.PosMinCharge;
import com.namasoft.pos.domain.entities.PosPGWMethodGroup;
import com.namasoft.pos.domain.entities.PosPaymentTerminal;
import com.namasoft.pos.domain.entities.PosPoleDisplaySpecs;
import com.namasoft.pos.domain.entities.PosRequiredFields;
import com.namasoft.pos.domain.entities.Shortcuts;
import com.namasoft.pos.util.POSDataReaderRunner;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSPricesCachingUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSalesPriceUtil;
import com.namasoft.pos.util.POSWSClient;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import com.namasoft.specialserialization.SimpleXMLMarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javafx.application.Platform;
import org.hibernate.Session;

public class POSDataReaderUtil {
    private static final StringBuilder currentStatistics = new StringBuilder();
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static Pair<String, Date> lastReadSingleResponse;
    private static LocalDateTime lastTimeShowingDataTransferErrors;
    private static Map<String, Class> namaTypeWithPOSClass;

    public static <T extends POSMasterFile, M extends MasterFileDTO> void loadBasicDataFromQueue() {
        POSDataReaderUtil.loadDataFromQueue(null, null, true, false);
    }

    public static <T extends POSMasterFile, M extends MasterFileDTO> void loadPublicDimsDataFromQueue() {
        POSDataReaderUtil.loadDataFromQueue(null, null, false, true);
    }

    public static <T extends POSMasterFile, M extends MasterFileDTO> void loadDataFromQueue(ScheduledExecutorService executor, POSDataReaderRunner posDataReaderRunner) {
        POSDataReaderUtil.loadDataFromQueue(executor, posDataReaderRunner, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDataFromQueue(ScheduledExecutorService executor, POSDataReaderRunner posDataReaderRunner, boolean basicData, boolean readPublicDims) {
        int readRecords = 0;
        try {
            readRecords = POSDataReaderUtil.internalReadData(basicData, readPublicDims);
        }
        finally {
            if (!basicData && !readPublicDims) {
                int delay = POSGeneralSettings.getDataReadTimeInMS();
                if (readRecords > 0) {
                    delay = POSGeneralSettings.getFastDataReadTimeInMS();
                }
                executor.schedule(posDataReaderRunner, (long)delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    public static boolean isAuthenticationError(Throwable e) {
        ResultDTO faultInfo;
        if (e instanceof NaMaServiceExcepption && ObjectChecker.isNotEmptyOrNull((Object)(faultInfo = ((NaMaServiceExcepption)e).getFaultInfo()))) {
            return ObjectChecker.areEqual((Object)faultInfo.getErrorType(), (Object)NaMaErrors.AUTHENTICATION_ERROR);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int internalReadData(boolean basicData, boolean readPublicDims) {
        DTOPOSReadQueueRequest req = new DTOPOSReadQueueRequest();
        req.setLastReadDate(POSResourcesUtil.currentSetting.getLastReadDate());
        req.setReadCount(Integer.valueOf(POSGeneralSettings.getReadDataRecordsCount()));
        req.setRegisterCode(POSGeneralSettings.getRegisterCode());
        req.setCurrentRelease(POSResourcesUtil.calcAppVersion());
        req.setBasicData(Boolean.valueOf(basicData));
        req.setReadPublicDims(Boolean.valueOf(readPublicDims));
        SendRequest request = new SendRequest((Object)req);
        request.setLoginId(POSGeneralSettings.getLoginID());
        request.setPasswordHash(ServerStringUtils.hash((String)POSGeneralSettings.getLoginPassword()));
        List<Object> list = new ArrayList();
        try {
            list = ObjectChecker.isFalseOrNull((Boolean)POSGeneralSettings.getPropertyBoolean((String)"read-using-old-ws")) ? POSDataReaderUtil.readUsingCompressedWS((SendRequest<DTOPOSReadQueueRequest>)request) : POSWSClient.instance.readActionForPOS((SendRequest<DTOPOSReadQueueRequest>)request).getList();
        }
        catch (Exception e) {
            if (POSDataReaderUtil.isAuthenticationError(e)) {
                POSDataWriterUtil.showNotificationWithFailure(null, POSResourcesUtil.id("Authentication error - user password has changed, please change it in properties file", new Object[0]));
                return 0;
            }
            POSResourcesUtil.checkIfIncompatibleVersionWithNama(e);
            NaMaLogger.error((Throwable)e);
        }
        if (ObjectChecker.isEmptyOrNull(list)) {
            return 0;
        }
        ArrayList<DTOPOSReadMsg> readMsgs = new ArrayList<DTOPOSReadMsg>();
        for (DTOPOSReadQueueResponse dTOPOSReadQueueResponse : list) {
            try {
                if (POSDataReaderUtil.isRepeatedRead(dTOPOSReadQueueResponse, list)) continue;
                Class posKlass = POSDataReaderUtil.constructNamaWithPOSTypesMap().get(dTOPOSReadQueueResponse.getEntityType());
                if (ObjectChecker.areEqual((Object)posKlass, POSSettingsInfo.class) && ObjectChecker.isNotEmptyOrNull((Object)dTOPOSReadQueueResponse.getEntity())) {
                    POSResourcesUtil.currentSetting.updateConfigurations((DTOConfigEntry)dTOPOSReadQueueResponse.getEntity());
                    POSDataReaderUtil.updateCurrentStatistics(POSResourcesUtil.currentSetting, ((DTOConfigEntry)dTOPOSReadQueueResponse.getEntity()).getCode(), "UPDATED");
                    continue;
                }
                POSMasterFile posEntity = (POSMasterFile)POSPersister.findByID(posKlass, ServerStringUtils.toUUIDStr((Object)dTOPOSReadQueueResponse.getEntityId()));
                if (ObjectChecker.isEmptyOrNull((Object)posEntity)) {
                    posEntity = (POSMasterFile)ObjectCreatorUtil.creator((Class)posKlass).create();
                }
                String action = dTOPOSReadQueueResponse.getEventType();
                NaMaLogger.info((Object)("Start ---> " + posEntity.calcNamaEntityType() + " with id " + dTOPOSReadQueueResponse.getEntityId() + " " + action.substring(0, action.length() - 1)));
                String entityCode = posEntity.getCode();
                switch (action) {
                    case "DELETED": {
                        POSPersister.delete(posEntity);
                        if (!(posEntity instanceof POSSalesPriceList) && !(posEntity instanceof POSSalesOffers)) break;
                        POSPricesCachingUtil.clearCache();
                        break;
                    }
                    case "CREATED": 
                    case "UPDATED": {
                        MasterFileDTO namaEntity = (MasterFileDTO)dTOPOSReadQueueResponse.getEntity();
                        if (posEntity instanceof POSHasUpdateDataWithSession) {
                            Session session = POSPersister.openSession();
                            ((POSHasUpdateDataWithSession)((Object)posEntity)).updateData(namaEntity, session);
                            POSPersister.saveOrUpdate(posEntity, session);
                            session.close();
                        } else {
                            posEntity.updateData(namaEntity);
                            POSPersister.saveOrUpdate(posEntity);
                        }
                        POSDataReaderUtil.saveEntityAliases(namaEntity);
                    }
                }
                if (!ObjectChecker.isNotEmptyOrNull((Object)posEntity)) continue;
                POSDataReaderUtil.updateCurrentStatistics(posEntity, entityCode, action);
            }
            catch (Exception e) {
                DTOPOSReadMsg readMsg = new DTOPOSReadMsg();
                readMsgs.add(readMsg);
                readMsg.setQueueId(dTOPOSReadQueueResponse.getReadQueueId());
                readMsg.setRegisterCode(POSGeneralSettings.getRegisterCode());
                readMsg.setSucceeded(Boolean.valueOf(false));
                Platform.runLater(() -> {
                    if (lastTimeShowingDataTransferErrors.plusMinutes(ObjectChecker.getFirstNotEmptyOrZero((Integer[])new Integer[]{ObjectChecker.tryParseInt((String)POSGeneralSettings.getProperty((String)"error-message-frequency-minutes")), 1}).intValue()).isAfter(LocalDateTime.now())) {
                        return;
                    }
                    lastTimeShowingDataTransferErrors = LocalDateTime.now();
                    POSResult posResult = new POSResult();
                    posResult.setArMessage(e.getMessage() + " ,\u064a\u0631\u062c\u0649 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0623\u062e\u0637\u0627\u0621 \u0646\u0642\u0644 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a");
                    posResult.setEnMessage(e.getMessage() + " ,please check Errors Show");
                    posResult.failure(new ResultDTO());
                    POSErrorAndInfoMessagesUtil.showError(posResult, POSResourcesUtil.fetchCurrentScreenStage());
                });
                NaMaLogger.error((Throwable)e);
            }
            finally {
                if (basicData || readPublicDims) continue;
                Date lastReadDate = dTOPOSReadQueueResponse.getOnTime();
                if (POSDataReaderUtil.isRepeatedRead(dTOPOSReadQueueResponse, list)) {
                    lastReadDate = new Date(lastReadDate.getTime() + 1L);
                }
                POSResourcesUtil.currentSetting.setLastReadDate(lastReadDate);
                POSPersister.saveOrUpdate(POSResourcesUtil.currentSetting);
            }
        }
        if (ObjectChecker.isNotEmptyOrNull(readMsgs)) {
            POSWSClient.instance.updatePOSReadMsgs((SendListRequest<DTOPOSReadMsg>)new SendListRequest(readMsgs));
        }
        return list.size();
    }

    private static void saveEntityAliases(MasterFileDTO namaEntity) {
        if (namaEntity == null || ObjectChecker.isEmptyOrNull((Object)namaEntity.getPosAliases())) {
            return;
        }
        for (String alias : namaEntity.getPosAliases()) {
            POSPersister.saveOrUpdate(new POSAlias(namaEntity, alias));
        }
    }

    private static boolean isRepeatedRead(DTOPOSReadQueueResponse resp, List<DTOPOSReadQueueResponse> list) {
        if (list.size() > 1) {
            return false;
        }
        boolean repeatedRead = false;
        if (lastReadSingleResponse != null && ObjectChecker.areEqual((Object)resp.getEntityId(), (Object)lastReadSingleResponse.getX()) && ObjectChecker.areEqual((Object)resp.getOnTime(), (Object)lastReadSingleResponse.getY())) {
            repeatedRead = true;
        }
        lastReadSingleResponse = new Pair((Object)resp.getEntityId(), (Object)resp.getOnTime());
        return repeatedRead;
    }

    private static List<DTOPOSReadQueueResponse> readUsingCompressedWS(SendRequest<DTOPOSReadQueueRequest> request) throws IOException {
        GetResult<DTOPOSCompressedReadResp> compressed = POSWSClient.instance.readFromPOSServerCompressed(request);
        GZIPInputStream inputStream = new GZIPInputStream(((DTOPOSCompressedReadResp)compressed.getData()).getMessageBody().getInputStream());
        DTOAggrPOSReadQueueResp resp = (DTOAggrPOSReadQueueResp)SimpleXMLMarshaller.getInstance().unmarshal(DTOAggrPOSReadQueueResp.class, (InputStream)inputStream);
        ((InputStream)inputStream).close();
        return resp.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCurrentStatistics(POSMasterFile posEntity, String entityCode, String action) {
        StringBuilder stringBuilder = currentStatistics;
        synchronized (stringBuilder) {
            String code = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{entityCode, posEntity.getCode()});
            if (ObjectChecker.isEmptyOrNull((Object)code)) {
                return;
            }
            currentStatistics.append("\n " + DATE_FORMAT.format(LocalDateTime.now()) + " >>>  " + posEntity.calcNamaEntityType() + " with code " + code + " " + action);
            long newLines = currentStatistics.chars().filter(c -> c == 10).count();
            if (newLines > 100L) {
                int i = 0;
                while ((long)i < newLines - 100L) {
                    currentStatistics.delete(0, currentStatistics.length() / 2);
                    currentStatistics.delete(0, currentStatistics.indexOf("\n"));
                    ++i;
                }
            }
            PosScene.updateStatus(currentStatistics.toString());
        }
    }

    public static void loadData(ScheduledExecutorService executor, POSDataReaderRunner posDataReaderRunner) {
        try {
            ServiceLoginProvider.loginIfNotLoggedIn((String)POSGeneralSettings.getPOSServerURL(), (String)POSGeneralSettings.getLoginPassword(), (String)POSGeneralSettings.getLoginID(), (String)POSGeneralSettings.getAPIKey());
            POSDataReaderUtil.loadDataFromQueue(executor, posDataReaderRunner);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    public static Map<String, Class> constructNamaWithPOSTypesMap() {
        if (namaTypeWithPOSClass != null) {
            return namaTypeWithPOSClass;
        }
        namaTypeWithPOSClass = new ConcurrentHashMap<String, Class>();
        namaTypeWithPOSClass.put("CustomerClass", POSCustomerClass.class);
        namaTypeWithPOSClass.put("InvItem", POSItem.class);
        namaTypeWithPOSClass.put("Warehouse", POSWarehouse.class);
        namaTypeWithPOSClass.put("User", POSUser.class);
        namaTypeWithPOSClass.put("Locator", POSLocation.class);
        namaTypeWithPOSClass.put("UOM", POSUnit.class);
        namaTypeWithPOSClass.put("Currency", POSCurrency.class);
        namaTypeWithPOSClass.put("Customer", POSCustomer.class);
        namaTypeWithPOSClass.put("NamaPOSRegister", POSRegistery.class);
        namaTypeWithPOSClass.put("ItemBrand", POSItemBrand.class);
        namaTypeWithPOSClass.put("PaymentMethod", POSPaymentMethod.class);
        namaTypeWithPOSClass.put("ItemSection", POSItemSection.class);
        namaTypeWithPOSClass.put("ItemCategory", POSItemCategory.class);
        namaTypeWithPOSClass.put("InvoiceClassification", POSInvoiceClassification.class);
        namaTypeWithPOSClass.put("SalesOffers", POSSalesOffers.class);
        namaTypeWithPOSClass.put("SalesPriceList", POSSalesPriceList.class);
        namaTypeWithPOSClass.put("TranslationOverRider", POSTranslationOverrider.class);
        namaTypeWithPOSClass.put("NamaPOSGenericReference", POSGenReference.class);
        namaTypeWithPOSClass.put("Supplier", POSVendor.class);
        namaTypeWithPOSClass.put("Employee", POSEmployee.class);
        namaTypeWithPOSClass.put("POSSecurityProfile", POSSecurity.class);
        namaTypeWithPOSClass.put("NamaPOSTable", POSTable.class);
        namaTypeWithPOSClass.put("NamaPOSHall", POSHall.class);
        namaTypeWithPOSClass.put("ReportDefinition", POSReportDefinition.class);
        namaTypeWithPOSClass.put("LegalEntity", POSLegalEntity.class);
        namaTypeWithPOSClass.put("Sector", POSSector.class);
        namaTypeWithPOSClass.put("Branch", POSBranch.class);
        namaTypeWithPOSClass.put("Department", POSDepartment.class);
        namaTypeWithPOSClass.put("AnalysisSet", POSAnalysisset.class);
        namaTypeWithPOSClass.put("TaxPlan", POSTaxPlan.class);
        namaTypeWithPOSClass.put("FreeItemGroup", POSFreeItemGroup.class);
        namaTypeWithPOSClass.put("PricingRange", POSPricingRange.class);
        namaTypeWithPOSClass.put("DocCategory", PosDocCategory.class);
        namaTypeWithPOSClass.put("ItemConfigurations", POSItemConfig.class);
        namaTypeWithPOSClass.put("SalesPriceClassifier1", POSSalesPriceClassifier1.class);
        namaTypeWithPOSClass.put("SalesPriceClassifier2", POSSalesPriceClassifier2.class);
        namaTypeWithPOSClass.put("SalesPriceClassifier3", POSSalesPriceClassifier3.class);
        namaTypeWithPOSClass.put("SalesPriceClassifier4", POSSalesPriceClassifier4.class);
        namaTypeWithPOSClass.put("SalesPriceClassifier5", POSSalesPriceClassifier5.class);
        namaTypeWithPOSClass.put("NamaPOSCreditNote", POSCreditNote.class);
        namaTypeWithPOSClass.put("ItemClass1", POSItemClass1.class);
        namaTypeWithPOSClass.put("ItemClass2", POSItemClass2.class);
        namaTypeWithPOSClass.put("ItemClass3", POSItemClass3.class);
        namaTypeWithPOSClass.put("ItemClass4", POSItemClass4.class);
        namaTypeWithPOSClass.put("ItemClass5", POSItemClass5.class);
        namaTypeWithPOSClass.put("ItemClass6", POSItemClass6.class);
        namaTypeWithPOSClass.put("ItemClass7", POSItemClass7.class);
        namaTypeWithPOSClass.put("ItemClass8", POSItemClass8.class);
        namaTypeWithPOSClass.put("ItemClass9", POSItemClass9.class);
        namaTypeWithPOSClass.put("ItemClass10", POSItemClass10.class);
        namaTypeWithPOSClass.put("NamaPOSItemBarcodeParser", POSItemBarcodeParser.class);
        namaTypeWithPOSClass.put("DiscountCoupon", POSDiscountCoupon.class);
        namaTypeWithPOSClass.put("GenericReferenceOverrider", POSGenericReferenceOverrider.class);
        namaTypeWithPOSClass.put("CustomerCategory", POSCustomerCategory.class);
        namaTypeWithPOSClass.put("NamaPOSSalesInvoice", POSSalesInvoice.class);
        namaTypeWithPOSClass.put("NamaPOSSalesReturn", POSSalesReturn.class);
        namaTypeWithPOSClass.put("NamaPOSSalesReplacement", POSSalesReplacement.class);
        namaTypeWithPOSClass.put("NamaPOSStockTransferReq", POSStockTransferReq.class);
        namaTypeWithPOSClass.put("POSPaymentToRegister", POSPaymentToRegistery.class);
        namaTypeWithPOSClass.put("POSReceiptFromRegister", POSReceiptFromRegistery.class);
        namaTypeWithPOSClass.put("POSShiftClosing", POSShiftClose.class);
        namaTypeWithPOSClass.put("POSShiftOpening", POSShiftOpen.class);
        namaTypeWithPOSClass.put("POSCashDrawer", POSInventory.class);
        namaTypeWithPOSClass.put("NamaPOSInternalMessage", POSInternalMessage.class);
        namaTypeWithPOSClass.put("ConfigEntry", POSSettingsInfo.class);
        namaTypeWithPOSClass.put("ExchangeRate", POSExchangeRate.class);
        namaTypeWithPOSClass.put("NamaPosUISettings", PosUISettings.class);
        namaTypeWithPOSClass.put("NamaPosPoleDisplaySpecs", PosPoleDisplaySpecs.class);
        namaTypeWithPOSClass.put("AddressRegion", PosAddressRegion.class);
        namaTypeWithPOSClass.put("NamaPOSDeliveryCost", PosDeliveryCost.class);
        namaTypeWithPOSClass.put("PosMinChargeSettings", PosMinCharge.class);
        namaTypeWithPOSClass.put("POSServiceChargeSettings", POSServiceChargeSettings.class);
        namaTypeWithPOSClass.put("NamaPosRequiredFields", PosRequiredFields.class);
        namaTypeWithPOSClass.put("NamaPOSItemQtyUpdateConfig", POSItemQtyUpdateConfig.class);
        namaTypeWithPOSClass.put("NamaPosItemAdditionalItems", PosItemAdditionalItems.class);
        namaTypeWithPOSClass.put("NamaPosMobileUISettings", PosMobileUISettings.class);
        namaTypeWithPOSClass.put("NamaPOSDepreciationReason", POSDepreciationReason.class);
        namaTypeWithPOSClass.put("NamaPosDefaultsTemplate", PosDefaultsTemplate.class);
        namaTypeWithPOSClass.put("NamaPOSInvSavingSettings", POSSavingSettings.class);
        namaTypeWithPOSClass.put("NamaPOSReturnReason", POSReturnReason.class);
        namaTypeWithPOSClass.put("NamaPOSExtraFilter", POSExtraFilter.class);
        namaTypeWithPOSClass.put("NamaPOSShortcuts", Shortcuts.class);
        namaTypeWithPOSClass.put("NamaPOSPaymentMethodsSettings", POSPaymentMethodsSettings.class);
        namaTypeWithPOSClass.put("PGWMethodGroup", PosPGWMethodGroup.class);
        namaTypeWithPOSClass.put("PaymentTerminal", PosPaymentTerminal.class);
        namaTypeWithPOSClass.put("RewardPointsConfig", POSRewardPointConfig.class);
        return namaTypeWithPOSClass;
    }

    public static List<POSFavouriteLine> readFavouriteItems(POSRegistery register) {
        List<POSFavouriteLine> favouriteItems = CollectionsUtility.convert((Collection)POSResourcesUtil.fetchPOSConfig().getFavouriteItems(), object -> {
            if (ObjectChecker.isEmptyOrNull((Object)object.getFavouritesLevel1())) {
                return new POSFavouriteLine((POSItem)POSSavable.staticFromReference(object.getInvItem()));
            }
            return new POSFavouriteLine((POSItem)POSSavable.staticFromReference(object.getInvItem()), UUID.fromString(object.getFavouritesLevel1().getId()), object.getFavouritesLevel1().getEntityType(), object.getFavouritesLevel2(), object.getFavouritesLevel3(), object.getFavouritesLevel4(), object.getFavouritesLevel5());
        });
        if (ObjectChecker.isNotEmptyOrNull((Object)POSResourcesUtil.fetchPOSConfig().getFavouriteItemsQuery())) {
            POSDataReaderUtil.calcFavouriteItemsFromQuery(favouriteItems, POSResourcesUtil.fetchPOSConfig().getFavouriteItemsQuery());
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)register)) {
            favouriteItems = POSDataReaderUtil.calcFavouriteItemsFromRegister(favouriteItems, register);
        }
        return favouriteItems;
    }

    public static List<POSFavouriteLine> calcFavouriteItemsFromRegister(List<POSFavouriteLine> favouriteItems, POSRegistery posRegistery) {
        String favouriteItemsQuery = ObjectChecker.toStringOrEmpty((Object)posRegistery.getFavouriteItemsQuery()).trim();
        if (ObjectChecker.isNotEmptyOrNull((Object)favouriteItemsQuery)) {
            POSDataReaderUtil.calcFavouriteItemsFromQuery(favouriteItems, favouriteItemsQuery);
        } else if (ObjectChecker.isNotEmptyOrNull(posRegistery.getFavouriteLines())) {
            favouriteItems = CollectionsUtility.convert(posRegistery.getFavouriteLines(), object -> new POSFavouriteLine(object.getItem(), object.getFavouritesLevel1Id(), object.getFavouritesLevel1EntityType(), object.getFavouritesLevel2(), object.getFavouritesLevel3(), object.getFavouritesLevel4(), object.getFavouritesLevel5()));
        }
        return favouriteItems;
    }

    public static void calcFavouriteItemsFromQuery(List<POSFavouriteLine> favouriteItems, String query) {
        List<Object[]> objects = POSJDBCQueryRunner.prepareAndExecuteJDBCQuery(POSPersister.params(new Object[0]), query, new ArrayList<String>(), false);
        for (Object[] objValues : objects) {
            POSItem posItem = POSPersister.findByID(POSItem.class, ServerStringUtils.toUUIDStr((Object)objValues[0]));
            if (posItem == null) continue;
            favouriteItems.add(new POSFavouriteLine(posItem));
        }
    }

    public static List<POSNotification> readEmpNotifications() {
        ArrayList<POSNotification> notifications = new ArrayList<POSNotification>();
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        ListApprovalsRequest request = new ListApprovalsRequest(ServerStringUtils.toUUIDStr((Object)currentUser.getEmpId()));
        request.setUserId(ServerStringUtils.toUUIDStr((Object)currentUser.getId()));
        List dtoNotifications = POSWSClient.instance.fetchNotifications((SendRequest<ListApprovalsRequest>)new SendRequest((Object)request)).getList();
        for (DTOUserNotification dtoNotification : dtoNotifications) {
            POSNotification notification = new POSNotification();
            notification.setSubject(dtoNotification.getSubject());
            notification.setOwnerCode(dtoNotification.getOwner().getCode());
            notification.setOwnerType(dtoNotification.getOwner().getEntityType());
            notifications.add(notification);
        }
        return notifications;
    }

    public static void cacheReportDefinitions() {
        List<POSReportDefinition> reports = POSReportDefinition.fetchReportsForUSer(false, null, null);
        POSSalesPriceUtil.filterByDimensions(reports);
        POSResourcesUtil.reportDefintions = reports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCurrentStatistics() {
        StringBuilder stringBuilder = currentStatistics;
        synchronized (stringBuilder) {
            currentStatistics.delete(0, currentStatistics.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentStatistics() {
        StringBuilder stringBuilder = currentStatistics;
        synchronized (stringBuilder) {
            return currentStatistics.toString();
        }
    }

    static {
        lastTimeShowingDataTransferErrors = LocalDateTime.now().minusDays(1L);
    }
}

