/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;
import com.namasoft.common.constants.Language;
import com.namasoft.common.constants.NaMaErrors;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.BaseEntityDTO;
import com.namasoft.contracts.common.dtos.requests.ChangePasswordRequest;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.modules.basic.enums.ViewNotificationContent;
import com.namasoft.modules.commonbasic.contracts.entities.DTOCustomer;
import com.namasoft.modules.namapos.contracts.common.DTOCustomerWriterReq;
import com.namasoft.modules.namapos.contracts.common.POSWriteRequest;
import com.namasoft.modules.namapos.contracts.entities.DTOAbsPOSSalesDoc;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSHeldInvoice;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSInternalMessage;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSStockReceipt;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSStockTakingDetails;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSStockTransferReq;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSUUIDUtil;
import com.namasoft.pos.application.toolbar.POSNewToolBar;
import com.namasoft.pos.domain.AbsPOSPayReceipt;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentToRegistery;
import com.namasoft.pos.domain.POSReceiptFromRegistery;
import com.namasoft.pos.domain.WritalblePOSFile;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSDiscountCoupon;
import com.namasoft.pos.domain.entities.POSError;
import com.namasoft.pos.domain.entities.POSInternalMessage;
import com.namasoft.pos.domain.entities.POSInventory;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSScrapDoc;
import com.namasoft.pos.domain.entities.POSShiftClose;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSShortfallsDoc;
import com.namasoft.pos.domain.entities.POSStockReceipt;
import com.namasoft.pos.domain.entities.POSStockTakingDetailsDoc;
import com.namasoft.pos.domain.entities.POSStockTransferReq;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.domain.entities.PosCancelReservation;
import com.namasoft.pos.util.POSActualDTOConverter;
import com.namasoft.pos.util.POSGeneralSettings;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.POSWSClient;
import com.namasoft.utils.ServerSideExceptionDescriber;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.util.Duration;
import org.controlsfx.control.Notifications;
import org.hibernate.HibernateException;

public class POSDataWriterUtil {
    public static List<POSError> transferErrors = new ArrayList<POSError>();
    public static List<String> notifications = new ArrayList<String>();
    public static ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "Transer-thread"));
    private static final Object writerLock = new Object();

    public static <T extends POSMasterFile> void saveErrorAndShowNotification(POSRegistery register, POSMasterFile record, ResultDTO result, String className, boolean writeSpecificDoc) {
        String failure = ServerSideExceptionDescriber.describeResult((ResultDTO)result, (Language)Language.English);
        NaMaLogger.error((Object)failure);
        POSError error = POSDataWriterUtil.findRecordError(record);
        if (ObjectChecker.isEmptyOrNull((Object)error)) {
            error = new POSError();
        } else {
            error.setSent(false);
        }
        POSDataWriterUtil.updateError(register, record, className, failure, result == null ? "" : result.getLog(), error);
        POSPersister.saveOrUpdate(error);
        String notification = POSResourcesUtil.id(className, new Object[0]) + " " + record.getCode() + "\n " + POSResourcesUtil.id(" not saved ", new Object[0]) + "\n " + failure;
        POSDataWriterUtil.showNotificationWithFailure(error, notification, writeSpecificDoc);
    }

    private static POSError findRecordError(POSMasterFile record) {
        List<?> errors = POSPersister.searchFor(" from " + POSError.class.getSimpleName() + " where recordId = :id", POSPersister.params("id", record.getId()));
        if (ObjectChecker.isEmptyOrNull(errors)) {
            return null;
        }
        return (POSError)errors.get(0);
    }

    private static void updateError(POSRegistery register, POSMasterFile record, String className, String failure, String log, POSError error) {
        error.setRegisterUUID(register.getId());
        error.setCode(record.getCode());
        error.setRecordId(record.getId());
        error.setOnTime(new Date());
        error.setEntityType(className);
        error.setFailure(failure);
        error.setLog(log);
    }

    public static void showNotificationWithFailure(POSError error, String notification) {
        POSDataWriterUtil.showNotificationWithFailure(error, notification, false);
    }

    public static void showNotificationWithFailure(POSError error, String notification, boolean writeSpecificDoc) {
        if (error != null) {
            while (transferErrors.size() > 30) {
                transferErrors.remove(0);
            }
            POSError oldErrorForDoc = transferErrors.stream().filter(e -> ObjectChecker.areEqual((Object)e.getRecordId(), (Object)error.getRecordId())).findFirst().orElse(null);
            if (oldErrorForDoc != null) {
                transferErrors.remove(oldErrorForDoc);
            }
            transferErrors.add(error);
        }
        Platform.runLater(() -> POSDataWriterUtil.createNotification(notification));
        if (writeSpecificDoc) {
            POSDataWriterUtil.showErrorsAlertIfNeeded();
        }
    }

    public static void showErrorsAlertIfNeeded() {
        if (ObjectChecker.isEmptyOrNull(transferErrors) || POSSecurityUtil.userCan(POSSecurityCapability.CanShowDataTransferErrors).isFailed().booleanValue()) {
            return;
        }
        POSDataWriterUtil.showAlertWithError(transferErrors.size() + " " + POSResourcesUtil.id("documents not sent to server, please check 'show errors' button from menu", new Object[0]));
    }

    public static void writeReturns(List<POSSalesReturn> returns, Callback callback, boolean preventDraft) {
        POSDataWriterUtil.writeReturns(POSResourcesUtil.fetchMainRegister(), returns, callback, preventDraft);
    }

    public static void writeReturns(POSRegistery register, List<POSSalesReturn> returns, Callback callback, boolean preventDraft) {
        POSDataWriterUtil.write(register, POSSalesReturn.class, POSSalesReturn::toDTO, returns, callback, preventDraft);
    }

    public static void writeData(POSRegistery register) {
        Thread thread = new Thread(() -> POSDataWriterUtil.internalWriteData(register), "data-writer");
        thread.setUncaughtExceptionHandler(POSResourcesUtil.uncaughtExceptionsHandler);
        thread.setDaemon(true);
        thread.start();
    }

    static void internalWriteData(POSRegistery register) {
        block2: {
            try {
                ServiceLoginProvider.loginIfNotLoggedIn((String)POSGeneralSettings.getPOSServerURL(), (String)POSGeneralSettings.getLoginPassword(), (String)POSGeneralSettings.getLoginID(), (String)POSGeneralSettings.getAPIKey());
            }
            catch (Exception e) {
                if (!POSDataWriterUtil.isConnectionException(e)) break block2;
                POSDataWriterUtil.showConnectionFailureNotification();
                return;
            }
        }
        POSDataWriterUtil.handleExceptions((Callback<Void>)((Callback)v -> {
            POSDataWriterUtil.writeShiftsOpenDocs(register, null);
            POSDataWriterUtil.writeShiftsCloseDocs(register, null);
            POSDataWriterUtil.writeCustomers(register, null);
            POSDataWriterUtil.writeReplacements(register, null, null, false);
            POSDataWriterUtil.writeInvoices(register, null);
            POSDataWriterUtil.writeReservations(register, null);
            POSDataWriterUtil.writeReturns(register, null, null, false);
            POSDataWriterUtil.writeStockTransferReqs(register, null);
            POSDataWriterUtil.writePayments(register, null, null);
            POSDataWriterUtil.writeReceipts(register, null, null);
            POSDataWriterUtil.writeCashDrawers(register);
            POSDataWriterUtil.writeAllNotSentMsgs(register);
            POSDataWriterUtil.writeErrors(register);
            POSDataWriterUtil.writePOSCreditNote(register, null);
            POSDataWriterUtil.writePOSCoupons(register, null);
            POSDataWriterUtil.writeStockTakingDocs(register, null);
            POSDataWriterUtil.writeStockReceipts(register, null);
            POSDataWriterUtil.writeScrapDocs(register, null);
            POSDataWriterUtil.writeShortfallsDocs(register, null);
            ScheduledExecutorService errorExecutor = Executors.newSingleThreadScheduledExecutor();
            errorExecutor.schedule(() -> {
                POSDataWriterUtil.showErrorsAlertIfNeeded();
                errorExecutor.shutdown();
            }, 1L, TimeUnit.MINUTES);
        }));
    }

    public static void showAlertWithError(String error) {
        Platform.runLater(() -> POSErrorAndInfoMessagesUtil.showError(error, POSResourcesUtil.fetchCurrentScreenStage()));
    }

    private static void showConnectionFailureNotification() {
        Platform.runLater(() -> {
            Notifications create = Notifications.create();
            create.title("Notification").text(POSResourcesUtil.id("Connection Failed", new Object[0])).darkStyle().hideAfter(Duration.seconds((double)5.0)).showInformation();
        });
    }

    private static void writeErrors(POSRegistery register) {
        POSDataWriterUtil.write(register, POSError.class, POSError::toDTO, null);
    }

    private static void writeAllNotSentMsgs(POSRegistery register) {
        List<POSInternalMessage> msgs = POSPersister.selectTop(POSInternalMessage.class, " where sent = false", 250);
        POSDataWriterUtil.writePOSInternalMsg(register, msgs);
    }

    public static void writeReplacements(POSRegistery register, List<POSSalesReplacement> replacments, Callback callback, boolean preventDraft) {
        POSDataWriterUtil.write(register, POSSalesReplacement.class, POSSalesReplacement::toDTO, replacments, callback, preventDraft);
    }

    public static void writePayments(POSRegistery register, List<POSPaymentToRegistery> payments, Callback callback) {
        POSDataWriterUtil.write(register, POSPaymentToRegistery.class, POSPaymentToRegistery::toDTO, payments, callback);
    }

    public static void writeReceipts(POSRegistery register, List<POSReceiptFromRegistery> receipts, Callback callback) {
        POSDataWriterUtil.write(register, POSReceiptFromRegistery.class, POSReceiptFromRegistery::toDTO, receipts, callback);
    }

    public static void writeStockReceipts(POSRegistery register, List<POSStockReceipt> posStockReceipts) {
        WritePreparator<POSStockReceipt> preparator = doc -> {
            DTONamaPOSStockReceipt dto = (DTONamaPOSStockReceipt)doc.toDTO();
            dto.setRegister(POSMasterFile.toRef(register));
            return dto;
        };
        POSDataWriterUtil.write(register, POSStockReceipt.class, preparator, posStockReceipts);
    }

    public static void writeStockTakingDocs(POSRegistery register, List<POSStockTakingDetailsDoc> posStockTakingDetailsDocs) {
        WritePreparator<POSStockTakingDetailsDoc> preparator = doc -> {
            DTONamaPOSStockTakingDetails dto = (DTONamaPOSStockTakingDetails)doc.toDTO();
            dto.setRegister(POSMasterFile.toRef(register));
            return dto;
        };
        POSDataWriterUtil.write(register, POSStockTakingDetailsDoc.class, preparator, posStockTakingDetailsDocs);
    }

    public static <T extends POSMasterFile> void write(POSRegistery register, Class<T> klass, WritePreparator<T> preparator, List<T> documents) {
        POSDataWriterUtil.write(register, klass, preparator, documents, null, false);
    }

    public static <T extends POSMasterFile> void write(POSRegistery register, Class<T> klass, WritePreparator<T> preparator, List<T> documents, Callback callback) {
        POSDataWriterUtil.write(register, klass, preparator, documents, callback, false);
    }

    public static <T extends POSMasterFile> void write(POSRegistery register, Class<T> klass, WritePreparator<T> preparator, List<T> documents, Callback callback, boolean preventDraft) {
        RuntimeException calledFrom = new RuntimeException();
        executor.schedule(() -> {
            try {
                POSDataWriterUtil.internalWrite(register, klass, preparator, documents, callback, preventDraft);
            }
            catch (HibernateException e) {
                NaMaLogger.error((Throwable)calledFrom);
                throw e;
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public static <T extends POSMasterFile> List<ServiceResponse> internalWriteInSameThread(POSRegistery register, Class<T> klass, WritePreparator<T> preparator, List<T> documents, boolean preventDraft) {
        return POSDataWriterUtil.internalWrite(register, klass, preparator, documents, preventDraft);
    }

    private static <T extends POSMasterFile> List<ServiceResponse> internalWrite(POSRegistery register, Class<T> klass, WritePreparator<T> preparator, List<T> documents) {
        return POSDataWriterUtil.internalWrite(register, klass, preparator, documents, null, false);
    }

    private static <T extends POSMasterFile> List<ServiceResponse> internalWrite(POSRegistery register, Class<T> klass, WritePreparator<T> preparator, List<T> documents, boolean preventDraft) {
        return POSDataWriterUtil.internalWrite(register, klass, preparator, documents, null, preventDraft);
    }

    private static <T extends POSMasterFile> List<ServiceResponse> internalWrite(POSRegistery register, Class<T> klass, WritePreparator<T> preparator, List<T> documents, Callback callback, boolean preventDraft) {
        ArrayList<ServiceResponse> responses = new ArrayList<ServiceResponse>();
        if (!POSGeneralSettings.canWriteData()) {
            return responses;
        }
        boolean writeSpecificDoc = true;
        if (ObjectChecker.isEmptyOrNull(documents)) {
            documents = POSDataWriterUtil.fetchDocsToSend(klass);
            writeSpecificDoc = false;
        }
        if (ObjectChecker.isEmptyOrNull(documents)) {
            return responses;
        }
        for (POSMasterFile doc : documents) {
            POSDataWriterUtil.writeSingleDoc(register, preparator, responses, doc, false, writeSpecificDoc, preventDraft);
        }
        if (callback != null) {
            callback.done(null);
        }
        return responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends POSMasterFile> void writeSingleDoc(POSRegistery register, WritePreparator<T> preparator, List<ServiceResponse> responses, T doc, boolean saveAsDraft, boolean writeSpecificDoc, boolean preventDraft) {
        Object object = writerLock;
        synchronized (object) {
            POSDataWriterUtil.notSynchronizedWriteSingleDoc(register, preparator, responses, doc, saveAsDraft, writeSpecificDoc, preventDraft);
        }
    }

    public static <T extends POSMasterFile> ArrayList<ServiceResponse> notSynchronizedWriteSingleDoc(POSRegistery register, WritePreparator<T> preparator, T document) {
        ArrayList<ServiceResponse> responses = new ArrayList<ServiceResponse>();
        POSDataWriterUtil.notSynchronizedWriteSingleDoc(register, preparator, responses, document, false, true, true);
        return responses;
    }

    private static <T extends POSMasterFile> void notSynchronizedWriteSingleDoc(POSRegistery register, WritePreparator<T> preparator, List<ServiceResponse> responses, T doc, boolean saveAsDraft, boolean writeSpecificDoc, boolean preventDraft) {
        try {
            POSSalesInvoice inv;
            if (ObjectChecker.isTrue((Boolean)saveAsDraft) && ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getSaveDocWithErrorsAsDraft())) {
                return;
            }
            if (doc instanceof POSSalesInvoice && ObjectChecker.isEmptyOrNull(((POSSalesInvoice)doc).getDetails())) {
                ResultDTO resultDTO = ResultDTO.fail((String)POSResourcesUtil.id("Transfer failed. Document {0} is empty", doc));
                NaMaLogger.error((Object)resultDTO);
                POSDataWriterUtil.saveErrorAndShowNotification(register, doc, resultDTO, doc.calcNamaEntityType(), writeSpecificDoc);
                return;
            }
            NaMaDTO dto = preparator.prepare(doc);
            if (doc instanceof WritalblePOSFile && dto instanceof BaseEntityDTO) {
                ((WritalblePOSFile)doc).copyCommonToDTO((BaseEntityDTO)dto);
            }
            POSWriteRequest request = new POSWriteRequest((Object)dto, register.getCode(), POSResourcesUtil.calcAppVersion());
            request.setPosDocCode(doc.getCode());
            if (preventDraft || doc instanceof AbsPOSPayReceipt && ObjectChecker.isNotEmptyOrNull((Object)((AbsPOSPayReceipt)doc).getNamaDocToPayCode())) {
                saveAsDraft = false;
            }
            request.setSaveAsDraft(Boolean.valueOf(saveAsDraft));
            responses.add(POSWSClient.instance.writeData((SendRequest<POSWriteRequest>)new SendRequest((Object)request)));
            if (doc instanceof POSSalesInvoice && (inv = (POSSalesInvoice)doc).isWriteHeldInvoiceToServer()) {
                doc.setSent(false);
                inv.setSentHeldToServer(true);
            } else {
                doc.setSent(true);
            }
            POSPersister.saveOrUpdate(doc);
            Platform.runLater(() -> {
                String notification = POSResourcesUtil.id(doc.calcNamaEntityType(), new Object[0]) + " " + ObjectChecker.toStringOrEmpty((Object)doc.getCode()) + "\n " + POSResourcesUtil.id(" Transferred Successfully ", new Object[0]);
                POSDataWriterUtil.createNotification(notification);
            });
        }
        catch (Exception e) {
            POSDataWriterUtil.handleWriteOperationException(register, e, preparator, responses, doc, saveAsDraft, writeSpecificDoc, preventDraft);
        }
    }

    private static <T extends POSMasterFile<?>> void createNotification(String notification) {
        if (POSResourcesUtil.currentSetting.getCurrentUser() == null) {
            return;
        }
        if (POSSecurityUtil.userCan(POSSecurityCapability.CanShowDataTransferErrors).isFailed().booleanValue()) {
            return;
        }
        notifications.add(notification);
        Object toolBar = POSResourcesUtil.currentScreen.fetchPaneCreator().getToolBar();
        if (toolBar instanceof POSNewToolBar) {
            POSNewToolBar newToolBar = (POSNewToolBar)toolBar;
            newToolBar.updateNotificationCount();
        }
        if (ObjectChecker.areEqual((Object)POSResourcesUtil.fetchPOSConfig().getNotificationContent(), (Object)ViewNotificationContent.ViewContent)) {
            Notifications.create().title("Notification").text(notification).hideAfter(Duration.seconds((double)4.0)).showInformation();
        }
    }

    private static <T extends POSMasterFile> void handleWriteOperationException(POSRegistery register, Exception e, WritePreparator<T> preparator, List<ServiceResponse> responses, T doc, boolean saveAsDraft, boolean writeSpecificDoc, boolean preventDraft) {
        NaMaServiceExcepption serviceException;
        if (e instanceof NaMaServiceExcepption && !POSDataWriterUtil.stockTakingError(serviceException = (NaMaServiceExcepption)((Object)e)) && !POSDataWriterUtil.isCodeRepeatedError((Exception)((Object)serviceException))) {
            ResultDTO repeatedCodeError = POSDataWriterUtil.findRepeatedCodeResultForReplace(serviceException, writeSpecificDoc, doc);
            if (repeatedCodeError != null) {
                POSDataWriterUtil.resolveCustomerRepeatedCodeError(register, (POSCustomer)doc, repeatedCodeError);
                return;
            }
            if (!preventDraft) {
                boolean handleSentBeforeError;
                doc.incrementFailures();
                boolean bl = handleSentBeforeError = ObjectChecker.isTrue((String)POSGeneralSettings.getProperty((String)"handleSentBeforeError")) && ObjectChecker.areEqual((Object)e.getMessage(), (Object)"Document is already saved before");
                if (handleSentBeforeError) {
                    doc.setSent(true);
                }
                POSPersister.saveOrUpdate(doc);
            }
            if (saveAsDraft) {
                NaMaLogger.error((Throwable)e);
                return;
            }
            POSDataWriterUtil.saveErrorAndShowNotification(register, doc, serviceException.getFaultInfo(), doc.calcNamaEntityType(), writeSpecificDoc);
            if (!preventDraft) {
                POSDataWriterUtil.writeSingleDoc(register, preparator, responses, doc, true, writeSpecificDoc, false);
            } else {
                responses.add(new ServiceResponse(serviceException.getFaultInfo()));
            }
        } else if (POSDataWriterUtil.isConnectionException(e) || POSDataWriterUtil.isCodeRepeatedError(e)) {
            if (doc.getWriteFailures() == null || doc.getWriteFailures() < 3) {
                doc.incrementFailures();
                POSDataWriterUtil.writeSingleDoc(register, preparator, responses, doc, false, writeSpecificDoc, preventDraft);
            } else {
                POSDataWriterUtil.writeOperationExceptionCommonHandling(register, e, doc, writeSpecificDoc, preventDraft, responses);
                POSDataWriterUtil.showConnectionFailureNotification();
            }
        } else {
            POSDataWriterUtil.writeOperationExceptionCommonHandling(register, e, doc, writeSpecificDoc, preventDraft, responses);
        }
    }

    private static boolean isCodeRepeatedError(Exception exception) {
        if (exception instanceof NaMaServiceExcepption) {
            NaMaServiceExcepption serviceException = (NaMaServiceExcepption)((Object)exception);
            String failure = ServerSideExceptionDescriber.describeResult((ResultDTO)serviceException.getFaultInfo(), (Language)Language.English);
            return failure.contains("Could not perform database operation, reason: Violation of UNIQUE KEY constraint 'codeAndType'. Cannot insert duplicate key in object 'dbo.Alias'. The duplicate key value is");
        }
        return false;
    }

    private static boolean stockTakingError(NaMaServiceExcepption serviceException) {
        if (serviceException == null) {
            return false;
        }
        if (serviceException.getFaultInfo() == null) {
            return false;
        }
        List leafErrors = ResultDTO.findLeafFailureResults((ResultDTO)serviceException.getFaultInfo());
        if (ObjectChecker.isEmptyOrNull((Object)leafErrors)) {
            return false;
        }
        return leafErrors.stream().anyMatch(r -> ObjectChecker.areEqual((Object)r.getErrorType(), (Object)NaMaErrors.STOCK_TAKING_IN_PROGRESS));
    }

    public static boolean isConnectionException(Throwable e) {
        return e instanceof ConnectException || e != null && e.getCause() != e && POSDataWriterUtil.isConnectionException(e.getCause());
    }

    private static <T extends POSMasterFile> void writeOperationExceptionCommonHandling(POSRegistery register, Exception e, T doc, boolean writeSpecificDoc, boolean preventDraft, List<ServiceResponse> responses) {
        NaMaServiceExcepption serviceException;
        if (!preventDraft) {
            doc.incrementFailures();
            POSPersister.saveOrUpdate(doc);
        }
        responses.add(new ServiceResponse(ResultDTO.fail((String)"Transfer failed")));
        StringWriter stringWriter = new StringWriter();
        if (e instanceof NaMaServiceExcepption && POSDataWriterUtil.stockTakingError(serviceException = (NaMaServiceExcepption)((Object)e))) {
            stringWriter.append("Transfer failed. The register is under stock tacking");
        } else {
            e.printStackTrace(new PrintWriter(stringWriter));
        }
        POSDataWriterUtil.saveErrorAndShowNotification(register, doc, ResultDTO.fail((String)stringWriter.toString(), (String)stringWriter.toString()), doc.calcNamaEntityType(), writeSpecificDoc);
    }

    private static <T extends POSMasterFile<?>> ResultDTO findRepeatedCodeResultForReplace(NaMaServiceExcepption serviceException, boolean writeSpecificDoc, T doc) {
        if (writeSpecificDoc) {
            return null;
        }
        if (!(doc instanceof POSCustomer)) {
            return null;
        }
        if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getReplacePOSCustomerWithServerCustomerIfCodeRepeated())) {
            return null;
        }
        return ResultDTO.findLeafFailureResults((ResultDTO)serviceException.getFaultInfo()).stream().filter(r -> ObjectChecker.areEqual((Object)r.getErrorType(), (Object)NaMaErrors.REPEATED_CODE)).findFirst().orElse(null);
    }

    private static <T extends POSMasterFile> void resolveCustomerRepeatedCodeError(POSRegistery register, POSCustomer customer, ResultDTO repeatedCodeError) {
        String customerServerId = (String)repeatedCodeError.getExtraInfo().get("id");
        if (POSPersister.findByID(POSCustomer.class, customerServerId) == null) {
            POSCustomer serverCustomer = new POSCustomer();
            serverCustomer.setId(UUID.fromString(customerServerId));
            serverCustomer.setCode(customer.getCode());
            serverCustomer.setSent(true);
            POSPersister.saveOrUpdate(serverCustomer);
        }
        HashMap<String, Object> params = POSPersister.params("customerServerId", UUID.fromString(customerServerId), "customerId", customer.getId());
        POSPersister.execute("UPDATE POSSalesInvoice SET customer_id = :customerServerId WHERE customer_id = :customerId", params);
        POSPersister.execute("UPDATE POSSalesReturn SET customer_id = :customerServerId WHERE customer_id = :customerId", params);
        POSPersister.execute("UPDATE POSSalesReplacement SET customer_id = :customerServerId WHERE customer_id = :customerId", params);
        POSResult result = POSPersister.delete(customer);
        if (result.isFailed().booleanValue()) {
            POSDataWriterUtil.saveErrorAndShowNotification(register, customer, ResultDTO.fail((String)("Customer: " + customer.getCode() + " Deletion failed")), customer.calcNamaEntityType(), false);
        }
    }

    public static <T extends POSMasterFile> List<T> fetchDocsToSend(Class<T> klass) {
        String holdExpression = POSDataWriterUtil.calcExtraExpression(klass);
        List<?> documents = POSPersister.selectTop(klass, " where sent = false " + holdExpression + " and (writeFailures is null or writeFailures < :numOfResending) order by code, writeFailures", 1000, POSPersister.params("numOfResending", POSResourcesUtil.fetchNumberOfTimesForResending()));
        return documents;
    }

    public static <T extends POSMasterFile> String calcExtraExpression(Class<T> klass) {
        return AbsPOSSales.class.isAssignableFrom(klass) ? " and hold = false and (paymentDelayed is null or paymentDelayed = false) " : "";
    }

    public static <T extends POSMasterFile> BigDecimal countDocsToSend(Class<T> klass) {
        String holdExpression = POSDataWriterUtil.calcExtraExpression(klass);
        return new BigDecimal(POSPersister.count(klass, " where sent = false " + holdExpression + " and (writeFailures is null or writeFailures < :numOfResending)", POSPersister.params("numOfResending", POSResourcesUtil.fetchNumberOfTimesForResending())).intValue());
    }

    public static void writePOSCoupons(POSRegistery register, List<POSDiscountCoupon> coupons) {
        POSDataWriterUtil.write(register, POSDiscountCoupon.class, POSDiscountCoupon::toDTO, coupons);
    }

    public static List<ServiceResponse> syncWritePOSCoupons(POSRegistery register, List<POSDiscountCoupon> coupons) {
        return POSDataWriterUtil.internalWrite(register, POSDiscountCoupon.class, POSDiscountCoupon::toDTO, coupons);
    }

    public static void writePOSCreditNote(POSRegistery register, List<POSCreditNote> notes) {
        POSDataWriterUtil.write(register, POSCreditNote.class, POSCreditNote::toDTO, notes);
    }

    public static List<ServiceResponse> syncWritePOSCreditNote(POSRegistery register, List<POSCreditNote> notes) {
        return POSDataWriterUtil.internalWrite(register, POSCreditNote.class, POSCreditNote::toDTO, notes);
    }

    public static void writeInvoices(List<POSSalesInvoice> invoices) {
        POSDataWriterUtil.writeInvoices(POSResourcesUtil.fetchMainRegister(), invoices);
    }

    public static void writeInvoices(POSRegistery register, List<POSSalesInvoice> invoices) {
        POSDataWriterUtil.write(register, POSSalesInvoice.class, POSSalesInvoice::toDTO, invoices);
    }

    public static void writeShortfallsDocs(POSRegistery register, List<POSShortfallsDoc> shortfallsDocs) {
        POSDataWriterUtil.write(register, POSShortfallsDoc.class, POSShortfallsDoc::toDTO, shortfallsDocs);
    }

    public static void writeHeldInvoice(POSRegistery register, List<POSSalesInvoice> heldInvoice, Callback callback, boolean fromDeleted, String deleteReason) {
        POSDataWriterUtil.write(register, POSSalesInvoice.class, posHeldInvoice -> POSDataWriterUtil.createDTONamaFromPOSHeldInvoice(posHeldInvoice, fromDeleted, deleteReason), heldInvoice, callback);
    }

    public static void writeScrapDocs(POSRegistery register, List<POSScrapDoc> depreciationDocs) {
        POSDataWriterUtil.write(register, POSScrapDoc.class, POSScrapDoc::toDTO, depreciationDocs);
    }

    public static List<ServiceResponse> writeShiftOpenDocsToNamaFirst(POSRegistery register, List<POSShiftOpen> shifts) {
        return POSDataWriterUtil.internalWriteInSameThread(register, POSShiftOpen.class, POSShiftOpen::toDTO, shifts, true);
    }

    public static List<ServiceResponse> writeShiftCloseDocsToNamaFirst(POSRegistery register, List<POSShiftClose> shifts) {
        return POSDataWriterUtil.internalWriteInSameThread(register, POSShiftClose.class, POSShiftClose::toDTO, shifts, true);
    }

    public static List<ServiceResponse> writeInvoicesToNamaFirst(POSRegistery register, List<POSSalesInvoice> invoices) {
        return POSDataWriterUtil.internalWriteInSameThread(register, POSSalesInvoice.class, POSSalesInvoice::toDTO, invoices, true);
    }

    public static List<ServiceResponse> writeReturnsToNamaFirst(POSRegistery register, List<POSSalesReturn> returns) {
        return POSDataWriterUtil.internalWriteInSameThread(register, POSSalesReturn.class, POSSalesReturn::toDTO, returns, true);
    }

    public static List<ServiceResponse> writeReplacementsToNamaFirst(POSRegistery register, List<POSSalesReplacement> replacements) {
        return POSDataWriterUtil.internalWriteInSameThread(register, POSSalesReplacement.class, POSSalesReplacement::toDTO, replacements, true);
    }

    public static List<ServiceResponse> writeStockReceiptsToNamaFirst(POSRegistery register, List<POSStockReceipt> receipts) {
        return POSDataWriterUtil.internalWriteInSameThread(register, POSStockReceipt.class, POSStockReceipt::toDTO, receipts, true);
    }

    public static List<ServiceResponse> writeStockTransferReqToNamaFirst(POSRegistery register, List<POSStockTransferReq> reqs) {
        WritePreparator<POSStockTransferReq> preparator = doc -> {
            DTONamaPOSStockTransferReq dto = (DTONamaPOSStockTransferReq)doc.toDTO();
            dto.setRegister(POSMasterFile.toRef(register));
            return dto;
        };
        return POSDataWriterUtil.internalWriteInSameThread(register, POSStockTransferReq.class, preparator, reqs, true);
    }

    public static List<ServiceResponse> writeOrderReservationToNamaFirst(POSRegistery register, List<POSOrderReservation> reservations) {
        return POSDataWriterUtil.internalWriteInSameThread(register, POSOrderReservation.class, POSOrderReservation::toDTO, reservations, true);
    }

    public static List<ServiceResponse> writeCancelReservationToNamaFirst(POSRegistery register, List<PosCancelReservation> cancelReservations) {
        return POSDataWriterUtil.internalWriteInSameThread(register, PosCancelReservation.class, PosCancelReservation::toDTO, cancelReservations, true);
    }

    public static void writeCancelReservations(POSRegistery register, List<PosCancelReservation> reservations) {
        POSDataWriterUtil.write(register, PosCancelReservation.class, PosCancelReservation::toDTO, reservations);
    }

    public static void writeReservations(POSRegistery register, List<POSOrderReservation> reservations) {
        POSDataWriterUtil.write(register, POSOrderReservation.class, POSOrderReservation::toDTO, reservations);
    }

    public static NaMaDTO createDTONamaFromPOSHeldInvoice(POSSalesInvoice posHeldInvoice, boolean fromDeleted, String deleteReason) {
        DTONamaPOSHeldInvoice dtoNamaPOSHeldInvoice = new DTONamaPOSHeldInvoice();
        POSActualDTOConverter.convertToDTO(posHeldInvoice, (DTOAbsPOSSalesDoc)dtoNamaPOSHeldInvoice);
        if (ObjectChecker.isEmptyOrNull((Object)posHeldInvoice.getHeldInvoiceId())) {
            posHeldInvoice.setHeldInvoiceId(POSUUIDUtil.genUUID());
        }
        posHeldInvoice.setWriteHeldInvoiceToServer(true);
        dtoNamaPOSHeldInvoice.setId(ServerStringUtils.toUUIDStr((Object)posHeldInvoice.getHeldInvoiceId()));
        dtoNamaPOSHeldInvoice.setFromDeleted(Boolean.valueOf(fromDeleted));
        dtoNamaPOSHeldInvoice.setDeletionReason(deleteReason);
        return dtoNamaPOSHeldInvoice;
    }

    public static void writeCashDrawers(POSRegistery register) {
        POSDataWriterUtil.write(register, POSInventory.class, POSInventory::toDTO, null);
    }

    public static void writeStockTransferReqs(POSRegistery register, List<POSStockTransferReq> reqs) {
        POSDataWriterUtil.write(register, POSStockTransferReq.class, POSStockTransferReq::toDTO, reqs);
    }

    public static void writeShiftsOpenDocs(POSRegistery register, List<POSShiftOpen> shifts) {
        POSDataWriterUtil.write(register, POSShiftOpen.class, POSShiftOpen::toDTO, shifts);
    }

    public static void writeShiftsCloseDocs(POSRegistery register, List<POSShiftClose> shifts) {
        POSDataWriterUtil.write(register, POSShiftClose.class, POSShiftClose::toDTO, shifts);
    }

    public static WritePreparator<POSCustomer> customerPreparator(POSRegistery register) {
        return customer -> {
            DTOCustomerWriterReq dtoCustomerWriterReq = new DTOCustomerWriterReq();
            dtoCustomerWriterReq.setRegisterId(register.getId());
            DTOCustomer dto = customer.toDTO();
            dtoCustomerWriterReq.setDtoCustomer(dto);
            if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getAddRegisterToCustomerRef5())) {
                dto.setRef5(register.toEntityReferenceData());
            }
            return dtoCustomerWriterReq;
        };
    }

    public static void writeCustomers(POSRegistery register, List<POSCustomer> customers) {
        POSDataWriterUtil.write(register, POSCustomer.class, POSDataWriterUtil.customerPreparator(register), customers);
    }

    public static String writeUser(POSUser user) {
        ChangePasswordRequest changePasswordRequest = new ChangePasswordRequest(user.getId().toString(), user.getPassword(), user.getPassword(), Boolean.valueOf(false));
        GetResult<String> response = POSWSClient.instance.writeUser((SendRequest<ChangePasswordRequest>)new SendRequest((Object)changePasswordRequest));
        return (String)response.getData();
    }

    public static void writePOSInternalMsg(POSRegistery register, List<POSInternalMessage> msgs) {
        WritePreparator<POSInternalMessage> preparator = doc -> {
            DTONamaPOSInternalMessage dto = doc.toDTO();
            dto.setRegister(POSMasterFile.toRef(register));
            return dto;
        };
        POSDataWriterUtil.write(register, POSInternalMessage.class, preparator, msgs);
    }

    public static boolean handleExceptions(Callback<Void> callback) {
        return POSDataWriterUtil.handleExceptions(callback, false);
    }

    public static boolean handleExceptions(Callback<Void> callback, boolean showError) {
        try {
            callback.done(null);
            return true;
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            if (e instanceof NaMaServiceExcepption) {
                NaMaServiceExcepption serviceException = (NaMaServiceExcepption)((Object)e);
                if (showError) {
                    POSResult posResult = new POSResult().failure(ResultDTO.findLeafFailureResults((ResultDTO)serviceException.getFaultInfo()));
                    POSErrorAndInfoMessagesUtil.showError(posResult, POSResourcesUtil.fetchCurrentScreenStage());
                }
            }
            return false;
        }
    }

    private static interface WritePreparator<T> {
        public NaMaDTO prepare(T var1);
    }
}

