/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.IHasPOSFinancialEffect;
import com.namasoft.pos.application.IPOSFinancialEffect;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.valueobjects.POSFinancialSysLine;
import java.util.List;
import java.util.UUID;
import org.hibernate.Session;

public class POSFinancialUtil {
    public static POSFinancialSysLine addFinancialSysLine(IPOSFinancialEffect iHasFinancialEffect) {
        return POSFinancialUtil.updateFinancialSysLine(new POSFinancialSysLine(), iHasFinancialEffect, null);
    }

    public static POSFinancialSysLine addFinancialSysLine(IPOSFinancialEffect iHasFinancialEffect, Session session) {
        return POSFinancialUtil.updateFinancialSysLine(new POSFinancialSysLine(), iHasFinancialEffect, session);
    }

    public static POSFinancialSysLine updateFinancialSysLine(POSFinancialSysLine line, IPOSFinancialEffect iHasFinancialEffect, Session session) {
        line.update(iHasFinancialEffect);
        POSPersister.saveOrUpdate(line, session);
        return line;
    }

    public static void applyEffects(IHasPOSFinancialEffect origin, Session session) {
        block6: {
            List<POSFinancialSysLine> oldLines;
            List<? extends IPOSFinancialEffect> effects;
            block5: {
                effects = origin.effects();
                if (ObjectChecker.isEmptyOrNull(effects)) {
                    return;
                }
                oldLines = POSFinancialUtil.fetchOldFinancialSysLines(origin.getId(), session);
                if (!ObjectChecker.isEmptyOrNull(oldLines)) break block5;
                for (IPOSFinancialEffect iPOSFinancialEffect : effects) {
                    POSFinancialUtil.addFinancialSysLine(iPOSFinancialEffect, session);
                }
                break block6;
            }
            for (int i = 0; i < effects.size(); ++i) {
                if (i < oldLines.size()) {
                    oldLines.get(i).update(effects.get(i));
                    continue;
                }
                POSFinancialUtil.addFinancialSysLine(effects.get(i), session);
            }
            if (oldLines.size() <= effects.size()) break block6;
            for (POSFinancialSysLine pOSFinancialSysLine : oldLines.subList(effects.size(), oldLines.size())) {
                POSPersister.delete(pOSFinancialSysLine, session);
            }
        }
    }

    public static List<POSFinancialSysLine> fetchOldFinancialSysLines(UUID originId, Session session) {
        return POSPersister.searchFor("FROM " + POSFinancialSysLine.class.getSimpleName() + " where originId = :id", POSPersister.params("id", originId), session);
    }
}

