/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.constants.Language;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.GeneralSettings;
import com.namasoft.namacontrols.PosSettingsDialog;
import com.namasoft.pos.application.IHasToolBar;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class POSGeneralSettings
extends GeneralSettings {
    public static String getLoginPassword() {
        return POSGeneralSettings.findSecuredPassword((String)"loginpassword", (String)"login");
    }

    public static String getAPIKey() {
        return POSGeneralSettings.findSecuredPassword((String)"apiKey", (String)"APIKey");
    }

    public static String getLoginID() {
        return POSGeneralSettings.getProperty((String)"loginid");
    }

    public static String getCommPortName() {
        return POSGeneralSettings.getProperty((String)"commPortName");
    }

    public static Integer getConnectionTimeout() {
        String property = POSGeneralSettings.getProperty((String)"connectionTimeout");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return 0;
        }
        return Integer.valueOf(property);
    }

    public static Integer getReceiveTimeout() {
        String property = POSGeneralSettings.getProperty((String)"receiveTimeout");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return 0;
        }
        return Integer.valueOf(property);
    }

    public static boolean logPoleIsEnabled() {
        String property = POSGeneralSettings.getProperty((String)"logPole", (String)"");
        return ObjectChecker.areEqual((Object)property.trim(), (Object)"1") || ObjectChecker.isTrue((String)property);
    }

    public static String getDBPassword() {
        return POSGeneralSettings.findSecuredPassword((String)"dbpassword", (String)"DB");
    }

    public static String getApplicationName() {
        return "pos";
    }

    public static String getServerURL() {
        return POSGeneralSettings.getProperty((String)"guiserver", (String)"http://localhost:8080");
    }

    public static boolean emptyOrInvalidSettings() {
        POSGeneralSettings.setSettingsFilePath((String)"nama.properties");
        properties = GeneralSettings.load();
        return ObjectChecker.isEmptyOrNull((Object)properties) || ObjectChecker.isNotEmptyOrNull((Object)properties) && ObjectChecker.isTrue((String)properties.getProperty("invalidSettings"));
    }

    public static void createSettingsFileIfNotFound(IHasToolBar screen) {
        POSGeneralSettings.setSettingsFilePath((String)"nama.properties");
        properties = GeneralSettings.load();
        if (ObjectChecker.isNotEmptyOrNull((Object)properties) && ObjectChecker.isFalse_OrNull((String)properties.getProperty("invalidSettings"))) {
            return;
        }
        Properties oldProps = properties;
        if (ObjectChecker.isEmptyOrNull((Object)settingsFilePath)) {
            throw new NullPointerException("Settings File path is empty");
        }
        POSGeneralSettings.initProperites(screen, (Properties)ObjectChecker.getFirstNotNullObj((Object[])new Properties[]{oldProps, new Properties()}));
    }

    private static void initProperites(IHasToolBar screen, Properties oldProps) {
        properties.setProperty("posDbName", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("posDbName"), "pos"}));
        properties.setProperty("dbtype", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("dbtype"), "sqlserver"}));
        properties.setProperty("sever.url", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("sever.url"), "localhost"}));
        properties.setProperty("server.port", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("server.port"), "8080"}));
        properties.setProperty("db.sever.url", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("db.sever.url"), "localhost"}));
        properties.setProperty("dbserver.port", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("dbserver.port"), "1433"}));
        properties.setProperty("loginid", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("loginid"), "admin"}));
        properties.setProperty("loginpassword", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("loginpassword"), "0"}));
        properties.setProperty("dbuser", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("dbuser"), "sa"}));
        properties.setProperty("dbpassword", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("dbpassword"), "sa123"}));
        properties.setProperty("defaultlang", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("defaultlang"), "Arabic"}));
        properties.setProperty("registerycode", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("registerycode"), ""}));
        properties.setProperty("writeData", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("writeData"), "1"}));
        properties.setProperty("readData", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("readData"), "1"}));
        properties.setProperty("readDataTime", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("readDataTime"), "5000"}));
        properties.setProperty("guiserver", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("guiserver"), ""}));
        properties.setProperty("readDataRecordsCount", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("readDataRecordsCount"), "500"}));
        properties.setProperty("imagesFolderPath", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("imagesFolderPath"), ""}));
        properties.setProperty("promotionalImagesFolderPath", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("promotionalImagesFolderPath"), ""}));
        properties.setProperty("useImages", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("useImages"), ""}));
        properties.setProperty("stopPricesCaching", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("stopPricesCaching"), "0"}));
        properties.setProperty("messageDisplayTime", (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{oldProps.getProperty("messageDisplayTime"), "30"}));
        if (screen == null) {
            return;
        }
        new PosSettingsDialog(screen).showSettingsDialog();
    }

    public static String getStopPricesCaching() {
        return POSGeneralSettings.getProperty((String)"stopPricesCaching");
    }

    public static String getDBUser() {
        return POSGeneralSettings.getProperty((String)"dbuser");
    }

    public static String getDBURL() {
        return POSGeneralSettings.getProperty((String)"db.sever.url");
    }

    public static String getDBPortNum() {
        return POSGeneralSettings.getProperty((String)"dbserver.port");
    }

    public static String getPosDBName() {
        return POSGeneralSettings.getProperty((String)"posDbName");
    }

    public static String getPOSServerURL() {
        return POSGeneralSettings.getProperty((String)"namaServerURL");
    }

    public static String getRegisterCode() {
        return POSGeneralSettings.getProperty((String)"registerycode");
    }

    public static Language getDefaultLang() {
        String lang = POSGeneralSettings.getProperty((String)"defaultlang");
        if (ObjectChecker.isEmptyOrNull((Object)lang)) {
            return Language.Arabic;
        }
        return Language.valueOf((String)lang);
    }

    public static boolean canWriteData() {
        String property = POSGeneralSettings.getProperty((String)"writeData");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return POSGeneralSettings.isMaster();
        }
        return ObjectChecker.areEqual((Object)property.trim(), (Object)"1") || ObjectChecker.isTrue((String)property);
    }

    public static boolean isMaster() {
        String property = POSGeneralSettings.getProperty((String)"readData");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return false;
        }
        return ObjectChecker.areEqual((Object)property.trim(), (Object)"1") || ObjectChecker.isTrue((String)property);
    }

    public static boolean sqlLog() {
        String property = POSGeneralSettings.getProperty((String)"sqlLog");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return false;
        }
        return ObjectChecker.areEqual((Object)property.trim(), (Object)"1") || ObjectChecker.isTrue((String)property);
    }

    public static int getDataReadTimeInMS() {
        String property = POSGeneralSettings.getProperty((String)"readDataTime");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return 30000;
        }
        return Integer.parseInt(property.trim());
    }

    public static int getFastDataReadTimeInMS() {
        String property = POSGeneralSettings.getProperty((String)"fastReadDataTime");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return 100;
        }
        return Integer.parseInt(property.trim());
    }

    public static int getReadDataRecordsCount() {
        String property = POSGeneralSettings.getProperty((String)"readDataRecordsCount");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return 50;
        }
        return Integer.parseInt(property.trim());
    }

    public static boolean getUseImages() {
        String property = POSGeneralSettings.getProperty((String)"useImages", (String)"");
        return ObjectChecker.areEqual((Object)property.trim(), (Object)"1") || ObjectChecker.isTrue((String)property);
    }

    public static String getImagesFolderPath() {
        String property = POSGeneralSettings.getProperty((String)"imagesFolderPath");
        if (ObjectChecker.isNotEmptyOrNull((Object)property)) {
            return property;
        }
        return "C:\\posItems";
    }

    public static String getPromotionalImagesFolderPath() {
        String property = POSGeneralSettings.getProperty((String)"promotionalImagesFolderPath");
        if (ObjectChecker.isNotEmptyOrNull((Object)property)) {
            return property;
        }
        return "C:\\posPromotionalImages";
    }

    public static String getGuiServerURL() {
        Object property = POSGeneralSettings.getProperty((String)"guiserver", (String)(POSGeneralSettings.getServerAddress() + "erp/"));
        if (ObjectChecker.isNotEmptyOrNull((Object)property) && !((String)property).endsWith("/")) {
            property = (String)property + "/";
        }
        return property;
    }

    public static String getServerAddress() {
        Object serverAddress = POSGeneralSettings.getProperty((String)"namaServerURL", (String)"http://localhost:8080/");
        if (!((String)serverAddress).endsWith("/")) {
            serverAddress = (String)serverAddress + "/";
        }
        return serverAddress;
    }

    public static void updateProperties(String properties, String path) {
        if (ObjectChecker.isEmptyOrNull((Object)properties)) {
            return;
        }
        File file = new File(path);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(properties);
            writer.close();
            POSGeneralSettings.load();
        }
        catch (IOException e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    public static boolean randomFailure() {
        String randomFailure = POSGeneralSettings.getProperty((String)"randomFailure");
        if (ObjectChecker.isEmptyOrNull((Object)randomFailure)) {
            return false;
        }
        return ObjectChecker.areEqual((Object)randomFailure.trim(), (Object)"1") || ObjectChecker.isTrue((String)randomFailure);
    }

    public static boolean runMoreThanOnePOS() {
        String runMoreThanOnePOS = POSGeneralSettings.getProperty((String)"runMoreThanOnePOS");
        if (ObjectChecker.isEmptyOrNull((Object)runMoreThanOnePOS)) {
            return false;
        }
        return ObjectChecker.areEqual((Object)runMoreThanOnePOS.trim(), (Object)"1") || ObjectChecker.isTrue((String)runMoreThanOnePOS);
    }

    public static String codePrefix() {
        String codePrefix = POSGeneralSettings.getProperty((String)"codePrefix");
        if (ObjectChecker.isEmptyOrNull((Object)codePrefix)) {
            return "";
        }
        return codePrefix;
    }

    public static double getMessageDisplayTime() {
        String messageDisplayTime = POSGeneralSettings.getProperty((String)"messageDisplayTime");
        Double value = 30.0;
        if (ObjectChecker.isEmptyOrNull((Object)messageDisplayTime)) {
            return value;
        }
        value = Double.parseDouble(messageDisplayTime);
        return value > 0.0 ? value : 30.0;
    }

    public static boolean isPriceCheckerMode() {
        String priceCheckerMode = POSGeneralSettings.getProperty((String)"priceCheckerMode");
        if (ObjectChecker.isEmptyOrNull((Object)priceCheckerMode)) {
            return false;
        }
        return ObjectChecker.areEqual((Object)priceCheckerMode.trim(), (Object)"1") || ObjectChecker.isTrue((String)priceCheckerMode);
    }
}

