/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.util.Duration;

public class POSIdleMonitor {
    private final Timeline idleTimeline;
    private final EventHandler<Event> userEventHandler;

    public POSIdleMonitor(Duration idleTime, Runnable notifier, boolean startMonitoring) {
        this.idleTimeline = new Timeline(new KeyFrame[]{new KeyFrame(idleTime, e -> notifier.run(), new KeyValue[0])});
        this.idleTimeline.setCycleCount(1);
        this.userEventHandler = e -> this.notIdle();
        if (startMonitoring) {
            this.startMonitoring();
        }
    }

    public POSIdleMonitor(Duration idleTime, Runnable notifier) {
        this(idleTime, notifier, false);
    }

    public void register(Scene scene, EventType<? extends Event> eventType) {
        scene.addEventFilter(eventType, this.userEventHandler);
    }

    public void register(Node node, EventType<? extends Event> eventType) {
        node.addEventFilter(eventType, this.userEventHandler);
    }

    public void unregister(Scene scene, EventType<? extends Event> eventType) {
        scene.removeEventFilter(eventType, this.userEventHandler);
    }

    public void unregister(Node node, EventType<? extends Event> eventType) {
        node.removeEventFilter(eventType, this.userEventHandler);
    }

    public void notIdle() {
        if (this.idleTimeline.getStatus() == Animation.Status.RUNNING) {
            this.idleTimeline.playFromStart();
        }
    }

    public void startMonitoring() {
        this.idleTimeline.playFromStart();
    }

    public void stopMonitoring() {
        this.idleTimeline.stop();
    }
}

