/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.DTOPageData;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSSalesInvoice;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.controllers.MobilePOSResult;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.factories.POSSalesInvoiceFactory;
import com.namasoft.pos.util.POSResult;
import java.util.HashMap;
import java.util.List;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class POSInvoicesService {
    public static POSSalesInvoice fetchHeldInvoiceForCustomer(POSRegistery register, POSCustomer customer, POSResult result) {
        return POSInvoicesService.fetchHeldInvoiceForCustomer(register, customer.getCode(), result);
    }

    public static POSSalesInvoice fetchHeldInvoiceForCustomer(POSRegistery register, String customerCode, POSResult result) {
        return POSInvoicesService.fetchHeldInvoice(register, null, customerCode, result);
    }

    public static POSSalesInvoice fetchHeldInvoiceByCode(POSRegistery register, String invoiceCode, POSResult result) {
        return POSInvoicesService.fetchHeldInvoice(register, invoiceCode, null, result);
    }

    public static POSSalesInvoice fetchHeldInvoice(POSRegistery register, String invoiceCode, String customerCode, POSResult result) {
        List salesInvoices;
        Object basicQuery = "SELECT inv FROM POSSalesInvoice inv WHERE hold = true ";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (ObjectChecker.isNotEmptyOrNull((Object)invoiceCode)) {
            basicQuery = (String)basicQuery + " AND code =:invCode ";
            parameters.put("invCode", invoiceCode);
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)customerCode)) {
            basicQuery = (String)basicQuery + " AND (inv.customer.code=:customerCode OR inv.customer.phoneNumber=:customerCode) ";
            parameters.put("customerCode", customerCode);
        }
        if (ObjectChecker.isNotEmptyOrNull(salesInvoices = POSPersister.searchFor((String)basicQuery, parameters, DTOPageData.all()))) {
            return (POSSalesInvoice)salesInvoices.getFirst();
        }
        POSSalesInvoice remoteInvoice = null;
        if (register == null) {
            return null;
        }
        for (String contactAddress : register.fetchContactsAddresses()) {
            remoteInvoice = POSInvoicesService.fetchHeldInvoiceRemotely(contactAddress, invoiceCode, customerCode);
            if (remoteInvoice == null) continue;
            remoteInvoice.setCode(POSCodeGenerator.calcDraftCode(POSSalesInvoice.class, POSCodeGenerator.generateInvoiceCode(POSDocumentType.Invoice, register)));
            remoteInvoice.setHold(true);
            POSPersister.saveOrUpdate(remoteInvoice).addToAccumulateResult(result);
            if (result.isFailed().booleanValue()) {
                return null;
            }
            POSInvoicesService.deleteHeldInvoiceRemotely(contactAddress, ServerStringUtils.toUUIDStr((Object)remoteInvoice.getId()), result);
            return remoteInvoice;
        }
        result.failure(POSResourcesUtil.id("Can not find the invoice", new Object[0]), new Object[0]);
        return null;
    }

    private static POSSalesInvoice fetchHeldInvoiceRemotely(String url, String invoiceCode, String customerPhoneNumber) {
        try {
            RestTemplate restTemplate = new RestTemplate();
            String endpointURL = "http://" + url + "/invoice/?invoiceCode=" + ObjectChecker.toStringOrEmpty((Object)invoiceCode) + "&customerCode=" + ObjectChecker.toStringOrEmpty((Object)customerPhoneNumber);
            DTONamaPOSSalesInvoice dto = (DTONamaPOSSalesInvoice)restTemplate.getForObject(endpointURL, DTONamaPOSSalesInvoice.class, new Object[0]);
            if (dto == null) {
                return null;
            }
            return POSSalesInvoiceFactory.createPOSInvoiceFromDTO(dto);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            return null;
        }
    }

    private static POSResult deleteHeldInvoiceRemotely(String url, String invoiceId, POSResult result) {
        try {
            RestTemplate restTemplate = new RestTemplate();
            String endpointURL = "http://" + url + "/invoices/" + invoiceId;
            MobilePOSResult dto = (MobilePOSResult)restTemplate.postForObject(endpointURL, null, MobilePOSResult.class, new Object[0]);
            if (dto == null) {
                return null;
            }
            return result.accumulate(dto.toNormalResult());
        }
        catch (HttpClientErrorException e) {
            NaMaLogger.error((Throwable)e);
            return null;
        }
    }
}

