/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;

public class POSMediaUtil {
    private static final Map<String, MediaPlayer> mediaPlayersCache = new HashMap<String, MediaPlayer>();
    private static final String PAYMENT_FROM_RESOURCES = "payment-from-resources.mp3";
    private static final String ALERT_FROM_RESOURCES = "alert-from-resources.wav";

    public static void playPaymentSound() {
        String path = (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{POSSettingsInfo.fetchConfiguration().getLocalPOSPaymentSoundPath(), POSResourcesUtil.fetchPOSConfig().getPaymentSoundPath(), PAYMENT_FROM_RESOURCES});
        POSMediaUtil.playSound(path);
    }

    public static void playItemNotFoundSound() {
        String path = (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{POSResourcesUtil.fetchPOSConfig().getItemNotFoundAlertPath(), ALERT_FROM_RESOURCES});
        POSMediaUtil.playSound(path);
    }

    public static void playSound(String path) {
        if (ObjectChecker.areEqual((Object)path, (Object)"none")) {
            return;
        }
        MediaPlayer player = POSMediaUtil.fetchMediaPlayerFor(path);
        if (player == null) {
            return;
        }
        player.seek(Duration.ZERO);
        player.play();
    }

    private static MediaPlayer fetchMediaPlayerFor(String path) {
        try {
            MediaPlayer player = mediaPlayersCache.get(path);
            if (player != null) {
                return player;
            }
            player = POSMediaUtil.addAndGetMediaPlayerFor(path);
            mediaPlayersCache.put(path, player);
            return player;
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            return null;
        }
    }

    private static MediaPlayer addAndGetMediaPlayerFor(String path) throws Exception {
        String uri;
        String actualPath = path.replaceAll("\\\\", "/");
        if (ObjectChecker.isEmptyOrNull((Object)actualPath)) {
            return null;
        }
        if (ObjectChecker.isAnyEqualToFirst((Object)path, (Object[])new String[]{PAYMENT_FROM_RESOURCES, ALERT_FROM_RESOURCES})) {
            uri = ObjectChecker.toStringOrEmpty((Object)POSMediaUtil.class.getClassLoader().getResource(path).toURI());
        } else {
            uri = new File(path).toURI().toString();
            File f = new File(path);
            if (!f.exists()) {
                return null;
            }
        }
        Media media = new Media(uri);
        return new MediaPlayer(media);
    }
}

