/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.Triple;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.requests.ListApprovalsRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.contracts.common.dtos.results.ListResult;
import com.namasoft.contracts.common.services.CoreWS;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.util.POSResult;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.w3c.dom.events.EventTarget;

public class POSNotificationsTask {
    private Long lastNotificationCount = 0L;
    private ScheduledExecutorService notificationExecuter;

    public void startTask(Stage stage) {
        this.notificationExecuter = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, POSNotificationsTask.class.getSimpleName());
            thread.setUncaughtExceptionHandler(POSResourcesUtil.uncaughtExceptionsHandler);
            thread.setDaemon(true);
            return thread;
        });
        this.notificationExecuter.scheduleAtFixedRate(() -> {
            Thread.currentThread().setUncaughtExceptionHandler(POSResourcesUtil.uncaughtExceptionsHandler);
            CoreWS webService = (CoreWS)ServiceUtility.getServiceClient(CoreWS.class);
            POSSettingsInfo posSettingsInfo = POSSettingsInfo.fetchConfiguration();
            POSUser currentUser = posSettingsInfo.getCurrentUser();
            ListApprovalsRequest request = new ListApprovalsRequest(ServerStringUtils.toUUIDStr((Object)currentUser.getEmpId()));
            String userId = ServerStringUtils.toUUIDStr((Object)currentUser.getId());
            request.setUserId(userId);
            GetResult result = webService.countAwaitingApprovalsAndNotifications(request);
            Long notificationsCount = (Long)((Triple)result.getData()).getY();
            if (notificationsCount > this.lastNotificationCount) {
                ListResult top5UnreadNotifications = webService.listTop5UnreadNotifications(request);
                List notificationsList = top5UnreadNotifications.getList();
                String content = StringUtils.toCSVLineWithSep((String)"<br> <hr/>", (Object[])notificationsList.toArray());
                Platform.runLater(() -> {
                    POSTooltip tooltip = new POSTooltip("");
                    tooltip.setAutoFix(true);
                    tooltip.setHideOnEscape(true);
                    tooltip.setWrapText(true);
                    if (POSResourcesUtil.isArabic()) {
                        tooltip.setX(stage.getWidth());
                    } else {
                        tooltip.setX(0.0);
                    }
                    Rectangle2D boundsInScreen = Screen.getPrimary().getVisualBounds();
                    tooltip.setY(boundsInScreen.getMaxY());
                    tooltip.setMinHeight(boundsInScreen.getHeight() / 10.0);
                    tooltip.setMaxHeight(boundsInScreen.getHeight() / 2.0);
                    tooltip.setMaxWidth(boundsInScreen.getWidth() / 2.0);
                    tooltip.setMinWidth(boundsInScreen.getWidth() / 5.0);
                    WebView web = new WebView();
                    tooltip.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    WebEngine webEngine = web.getEngine();
                    webEngine.getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
                        if (newValue == Worker.State.SUCCEEDED) {
                            ((EventTarget)((Object)webEngine.getDocument().getElementById("close"))).addEventListener("click", evt -> tooltip.hide(), false);
                            ((EventTarget)((Object)webEngine.getDocument().getElementById("markAsRead"))).addEventListener("click", evt -> {
                                if (PosScene.noConnection()) {
                                    POSResult posResult = new POSResult();
                                    posResult.failure(POSResourcesUtil.id("Connection Failed", new Object[0]), new Object[0]);
                                    POSErrorAndInfoMessagesUtil.showError(posResult, stage);
                                } else {
                                    webService.markAsReadTop5Notification(request);
                                }
                                tooltip.hide();
                            }, false);
                        }
                    });
                    tooltip.setOnShowing(event -> {
                        KeyFrame kf1 = new KeyFrame(Duration.seconds((double)30.0), e -> tooltip.hide(), new KeyValue[0]);
                        Timeline timeline = new Timeline(new KeyFrame[]{kf1});
                        Platform.runLater(() -> ((Timeline)timeline).play());
                    });
                    String body = "<body style='background : #c3c4c4;font-size: 20px;text-align:center;'>" + content + "<br> <hr/><button id = 'close' style = 'font-size: 20px'>" + POSResourcesUtil.id("close", new Object[0]) + "</button><button id = 'markAsRead' style = 'font-size: 20px'>" + POSResourcesUtil.id("markAsRead", new Object[0]) + "</button></body>";
                    webEngine.loadContent(body);
                    tooltip.setGraphic((Node)web);
                    tooltip.show((Window)stage);
                });
                this.lastNotificationCount = notificationsCount;
            }
        }, 0L, 3L, TimeUnit.MINUTES);
    }

    public void shutdownNow() {
        Platform.runLater(() -> this.notificationExecuter.shutdownNow());
    }
}

