/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.ServiceResponse;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.requests.ReprocessInfo;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.results.ListResult;
import com.namasoft.modules.namapos.contracts.common.POSReadOnlineOrderResponse;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSSalesInvoice;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.controllers.NamaJSON;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.valueobjects.POSOnlineOrderToDeleteEntry;
import com.namasoft.pos.factories.POSSalesInvoiceFactory;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSWSClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.util.Duration;
import org.controlsfx.control.Notifications;

public class POSOnlineOrderReaderRunner
implements Runnable {
    private final ThreadFactory daemonThreadFactory = r -> {
        Thread thread = new Thread(r, "POSOnlineOrderReaderRunner");
        thread.setUncaughtExceptionHandler(POSResourcesUtil.uncaughtExceptionsHandler);
        thread.setDaemon(true);
        return thread;
    };
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(this.daemonThreadFactory);
    private Set<POSOnlineOrderToDeleteEntry> oldEntriesIdsToDelete = null;
    private static final POSOnlineOrderReaderRunner instance = new POSOnlineOrderReaderRunner();

    public static POSOnlineOrderReaderRunner instance() {
        return instance;
    }

    private POSOnlineOrderReaderRunner() {
    }

    public void readEntriesToBeRemoved() {
        if (this.oldEntriesIdsToDelete != null) {
            return;
        }
        NaMaLogger.info((Object)"POSOnlineOrderReaderRunner: Loading pending deletion entries");
        this.oldEntriesIdsToDelete = ConcurrentHashMap.newKeySet();
        List<POSOnlineOrderToDeleteEntry> entries = POSPersister.listAll(POSOnlineOrderToDeleteEntry.class);
        if (ObjectChecker.isEmptyOrNull(entries)) {
            return;
        }
        NaMaLogger.info((String)"POSOnlineOrderReaderRunner: Loaded {0} pending deletion entries", (Object[])new Object[]{entries.size()});
        this.oldEntriesIdsToDelete.addAll(entries);
    }

    @Override
    public void run() {
        try {
            this.readEntriesToBeRemoved();
            ListResult<POSReadOnlineOrderResponse> response = POSWSClient.instance.readPOSOnlineOrders((SendRequest<String>)new SendRequest((Object)ServerStringUtils.toUUIDStr((Object)POSResourcesUtil.fetchRegisterId())));
            List orders = response.getList();
            if (ObjectChecker.isEmptyOrNull((Object)orders)) {
                return;
            }
            NaMaLogger.info((String)"POSOnlineOrderReaderRunner: Found {0} online orders to process", (Object[])new Object[]{orders.size()});
            ArrayList<String> entriesIdsToRemove = new ArrayList<String>();
            for (POSReadOnlineOrderResponse order : orders) {
                String orderId = order.getEntryId();
                try {
                    DTONamaPOSSalesInvoice dto = NamaJSON.read(order.getOrderJson(), DTONamaPOSSalesInvoice.class);
                    if (dto == null) {
                        NaMaLogger.error((String)"POSOnlineOrderReaderRunner: Failed to parse order JSON for entry {0}", (Object[])new Object[]{orderId});
                        continue;
                    }
                    POSSalesInvoice salesInvoice = POSSalesInvoiceFactory.createPOSInvoiceFromDTO(dto);
                    POSRegistery register = POSResourcesUtil.fetchMainRegister();
                    salesInvoice.setCode(POSCodeGenerator.calcDraftCode(POSSalesInvoice.class, POSCodeGenerator.generateInvoiceCode(POSDocumentType.Invoice, register)));
                    salesInvoice.setHold(true);
                    salesInvoice.setFromCallCenter(true);
                    POSResult result = POSPersister.saveOrUpdate(salesInvoice);
                    if (!result.isSucceeded().booleanValue()) continue;
                    entriesIdsToRemove.add(order.getEntryId());
                    Platform.runLater(() -> {
                        String entityType = POSResourcesUtil.id(salesInvoice.calcNamaEntityType(), new Object[0]);
                        String orderCode = ObjectChecker.toStringOrEmpty((Object)salesInvoice.getCode());
                        String notification = String.format("%s %s\n%s", entityType, orderCode, POSResourcesUtil.id("Received Successfully", new Object[0]));
                        Notifications.create().title(POSResourcesUtil.id("Call Center - Order Received", new Object[0])).text(notification).styleClass("notification-success").hideAfter(Duration.seconds((double)6.0)).showInformation();
                    });
                }
                catch (Exception orderException) {
                    NaMaLogger.errorWithException((Throwable)orderException, (String)"POSOnlineOrderReaderRunner: Exception while processing order {0}", (Object[])new Object[]{orderId});
                }
            }
            this.deleteEntriesFromServer(entriesIdsToRemove);
            if (orders.size() >= 50) {
                POSOnlineOrderReaderRunner.runAgain();
            }
        }
        catch (Exception e) {
            NaMaLogger.errorWithException((Throwable)e, (String)"POSOnlineOrderReaderRunner: Fatal error during reader cycle", (Object[])new Object[0]);
        }
    }

    private void deleteEntriesFromServer(List<String> entriesIdsToRemove) {
        if (ObjectChecker.isEmptyOrNull(entriesIdsToRemove)) {
            return;
        }
        LinkedHashSet<String> allEntriesToDelete = new LinkedHashSet<String>(entriesIdsToRemove);
        if (ObjectChecker.isNotEmptyOrNull(this.oldEntriesIdsToDelete)) {
            this.oldEntriesIdsToDelete.stream().map(POSOnlineOrderToDeleteEntry::getEntriesIds).flatMap(ids -> Arrays.stream(ids.split(","))).forEach(allEntriesToDelete::add);
        }
        boolean deletionSuccess = false;
        try {
            ServiceResponse response = POSWSClient.instance.deletePOSOnlineOrders((SendRequest<ReprocessInfo>)new SendRequest((Object)new ReprocessInfo(new ArrayList<String>(allEntriesToDelete))));
            deletionSuccess = response.succeded();
        }
        catch (Exception e) {
            NaMaLogger.errorWithException((Throwable)e, (String)"POSOnlineOrderReaderRunner: Failed to delete online orders from server.", (Object[])new Object[0]);
        }
        if (!deletionSuccess) {
            NaMaLogger.error((String)"POSOnlineOrderReaderRunner: Deletion failed, saving {0} entries for retry", (Object[])new Object[]{allEntriesToDelete.size()});
            POSOnlineOrderToDeleteEntry newFailedEntry = new POSOnlineOrderToDeleteEntry(String.join((CharSequence)",", allEntriesToDelete));
            if (POSPersister.saveOrUpdate(newFailedEntry).isSucceeded().booleanValue()) {
                this.oldEntriesIdsToDelete.forEach(POSPersister::delete);
                this.oldEntriesIdsToDelete.clear();
            }
            this.oldEntriesIdsToDelete.add(newFailedEntry);
        } else {
            NaMaLogger.info((Object)"POSOnlineOrderReaderRunner: Successfully deleted entries from server");
            if (ObjectChecker.isNotEmptyOrNull(this.oldEntriesIdsToDelete)) {
                this.oldEntriesIdsToDelete.forEach(POSPersister::delete);
                this.oldEntriesIdsToDelete.clear();
            }
        }
    }

    public static void stop() {
        NaMaLogger.info((Object)"POSOnlineOrderReaderRunner: Shutting down online order reader");
        POSOnlineOrderReaderRunner.instance().executor.shutdownNow();
    }

    public static void start() {
        NaMaLogger.info((Object)"POSOnlineOrderReaderRunner: Starting online order reader with 1 minute interval");
        POSOnlineOrderReaderRunner.instance().executor.scheduleWithFixedDelay(POSOnlineOrderReaderRunner.instance(), 0L, 1L, TimeUnit.MINUTES);
    }

    public static void runAgain() {
        POSOnlineOrderReaderRunner.instance().executor.submit(POSOnlineOrderReaderRunner.instance());
    }
}

