/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.modules.namapos.contracts.requests.POSQuantitiesUpdaterReadRequest;
import com.namasoft.modules.namapos.contracts.valueobjects.DTONamaPOSItemQtyUpdater;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.valueobjects.POSItemCurrentQuantitySysEntry;
import com.namasoft.pos.util.POSQuantitiesUtils;
import com.namasoft.pos.util.POSWSClient;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class POSQuantitiesReaderRunner
implements Runnable {
    private ThreadFactory daemonThreadFactory = r -> {
        Thread thread = new Thread(r, "POSQuantitiesReaderRunner");
        thread.setUncaughtExceptionHandler(POSResourcesUtil.uncaughtExceptionsHandler);
        thread.setDaemon(true);
        return thread;
    };
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(this.daemonThreadFactory);
    private Date maxReadDate;
    private static POSQuantitiesReaderRunner instance;

    public static POSQuantitiesReaderRunner instance() {
        if (instance == null) {
            instance = new POSQuantitiesReaderRunner();
        }
        return instance;
    }

    private POSQuantitiesReaderRunner() {
    }

    @Override
    public void run() {
        this.loadQuantities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadQuantities() {
        List list = null;
        int pageSize = 100;
        try {
            if (POSQuantitiesUtils.qtyUpdateConfig() == null) {
                return;
            }
            this.readMaxReadDateFromDBIfNeeded();
            POSQuantitiesUpdaterReadRequest request = new POSQuantitiesUpdaterReadRequest();
            request.setFromDate(this.maxReadDate);
            request.setPageSize(pageSize);
            request.setRegisterCode(POSResourcesUtil.fetchMainRegister().getCode());
            list = POSWSClient.instance.listCurrentPOSQuantities((SendRequest<POSQuantitiesUpdaterReadRequest>)new SendRequest((Object)request)).getList();
            for (DTONamaPOSItemQtyUpdater updater : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("dimensionIdx", updater.getDimensionsIdx());
                POSItemCurrentQuantitySysEntry first = (POSItemCurrentQuantitySysEntry)CollectionsUtility.getFirst(POSPersister.searchFor("from ".concat(POSItemCurrentQuantitySysEntry.class.getSimpleName()).concat(" where dimensionIdx = :dimensionIdx"), map));
                if (first == null) {
                    first = new POSItemCurrentQuantitySysEntry();
                }
                first.updateFrom(updater);
                POSPersister.saveOrUpdate(first);
                if (this.maxReadDate != null && !this.maxReadDate.before(updater.getLastUpdateTime())) continue;
                this.maxReadDate = updater.getLastUpdateTime();
            }
        }
        finally {
            if (list != null && list.size() >= pageSize) {
                this.executor.schedule(this, 0L, TimeUnit.SECONDS);
            } else {
                this.executor.schedule(this, 1L, TimeUnit.MINUTES);
            }
        }
    }

    private void readMaxReadDateFromDBIfNeeded() {
        if (this.maxReadDate != null) {
            return;
        }
        this.maxReadDate = POSPersister.max(POSItemCurrentQuantitySysEntry.class, "lastUpdateTime", Date.class);
    }

    public static void stop() {
        POSQuantitiesReaderRunner.instance();
        NaMaLogger.info((Object)"***************///// Shutting dow POSQuantitiesReaderRunner \\\\\\\\\\********");
        POSQuantitiesReaderRunner.instance().executor.shutdownNow();
    }

    public static void start() {
        POSQuantitiesReaderRunner.instance().executor.schedule(POSQuantitiesReaderRunner.instance(), 0L, TimeUnit.MILLISECONDS);
    }
}

