/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.DTOMoney;
import com.namasoft.contracts.common.dtos.DTONamaRewardInfo;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.services.CoreUtilitiesWS;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.modules.basic.contracts.entities.DTODiscountCoupon;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTORewardPointsInfo;
import com.namasoft.modules.namapos.contracts.common.DTOPOSRequestOTPRequest;
import com.namasoft.modules.supplychain.contracts.dtos.DTORedeemRequest;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSDiscountCoupon;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSWSClient;
import java.math.BigDecimal;
import java.util.Date;

public class POSRewardPointsUtil {
    public static DTONamaRewardInfo calculateRemainingRewardInfo(POSCustomer customer, POSResult result) {
        if (customer == null) {
            result.failure("You must select customer to redeem reward points", new Object[0]);
            return null;
        }
        CoreUtilitiesWS coreWS = (CoreUtilitiesWS)ServiceUtility.getUtilityServiceClient(CoreUtilitiesWS.class);
        DTORewardPointsInfo info = new DTORewardPointsInfo();
        info.setCustomerRef(customer.toEntityReferenceData());
        info.setOnDate(new Date());
        if (ObjectChecker.isNotEmptyOrNull((Object)POSResourcesUtil.fetchMainRegister().getRewardPointConfig())) {
            info.setConfigRef(POSResourcesUtil.fetchMainRegister().getRewardPointConfig().toEntityReferenceData());
        } else {
            info.setConfigRef(POSResourcesUtil.fetchPOSConfig().getRewardPointsConfig());
        }
        try {
            return (DTONamaRewardInfo)coreWS.calculateRemainingRewardInfo(new SendRequest((Object)info)).getData();
        }
        catch (NaMaServiceExcepption e) {
            result.accumulate(ResultDTO.findLeafFailureResults((ResultDTO)e.getFaultInfo()));
            return null;
        }
    }

    public static void requestOTP(AbsPOSSales doc, BigDecimal redeemAmount, POSResult result) {
        block4: {
            if (ObjectChecker.isEmptyOrZero((BigDecimal)redeemAmount)) {
                if (result != null) {
                    result.failure("Please enter redeem amount", new Object[0]);
                }
                return;
            }
            try {
                DTOPOSRequestOTPRequest request = new DTOPOSRequestOTPRequest();
                String val = ObjectChecker.isEmptyOrNull((Object)redeemAmount) ? "0" : ObjectChecker.toStringOrEmpty((Object)redeemAmount);
                request.setAmount(new BigDecimal(val));
                request.setPointsOwner(POSSavable.staticToReference(doc.getCustomer()));
                request.setCurrency(POSSavable.staticToReference(doc.getCurrency()));
                request.setRegisterId(ServerStringUtils.toUUIDStr((Object)doc.getRegisterId()));
                request.setEntityId(ServerStringUtils.toUUIDStr((Object)doc.getId()));
                request.setValueDate(doc.getValueDate());
                POSWSClient.instance.requestOTP((SendRequest<DTOPOSRequestOTPRequest>)new SendRequest((Object)request)).getData();
            }
            catch (NaMaServiceExcepption e) {
                if (result == null) break block4;
                result.accumulate(ResultDTO.findLeafFailureResults((ResultDTO)e.getFaultInfo()));
            }
        }
    }

    public static String redeem(AbsPOSSales doc, BigDecimal amount, String otpValue, boolean requireOtp, POSResult result) {
        if (requireOtp && ObjectChecker.isEmptyOrNull((Object)otpValue)) {
            result.failure("Please enter the OTP", new Object[0]);
            return null;
        }
        DTORedeemRequest redeemRequest = new DTORedeemRequest();
        redeemRequest.setPointsOwner(doc.getCustomer().toEntityReferenceData());
        redeemRequest.setAtDate(new Date());
        redeemRequest.setOtpValue(otpValue);
        redeemRequest.setRegisterId(ServerStringUtils.toUUIDStr((Object)POSResourcesUtil.fetchRegisterId()));
        redeemRequest.setDoc(doc.toEntityReferenceData());
        DTOMoney money = new DTOMoney();
        money.setAmount(amount);
        money.setCurrency(POSMasterFile.toRef(doc.getCurrency()));
        redeemRequest.setMoney(money);
        POSDiscountCoupon coupon = new POSDiscountCoupon();
        try {
            DTODiscountCoupon couponDto = (DTODiscountCoupon)POSWSClient.instance.redeem((SendRequest<DTORedeemRequest>)new SendRequest((Object)redeemRequest)).getData();
            if (couponDto == null) {
                return "";
            }
            coupon.updateData(couponDto);
        }
        catch (NaMaServiceExcepption e) {
            result.accumulate(ResultDTO.findLeafFailureResults((ResultDTO)e.getFaultInfo()));
            return null;
        }
        POSPersister.saveOrUpdate(coupon).addToAccumulateResult(result);
        if (result.isFailed().booleanValue()) {
            return null;
        }
        return coupon.getCode();
    }
}

