/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.PropertyGetterInterceptor;
import com.namasoft.common.utils.tafqeet.CurrencyDetails;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class POSScreenSettings {
    private static List<PropertyGetterInterceptor> interceptors = new ArrayList<PropertyGetterInterceptor>();
    protected static Properties properties = null;
    public static final String settingsFilePath = "screenProperties.properties";

    public static void addInterceptor(PropertyGetterInterceptor interceptor) {
        interceptors.add(interceptor);
    }

    public static synchronized void reset() {
        properties = null;
        CurrencyDetails.reset();
    }

    public static String getProperty(String id, String defaultValue) {
        for (PropertyGetterInterceptor interceptor : interceptors) {
            if (!interceptor.wouldIntercept(id)) continue;
            return interceptor.getProperty(id, defaultValue);
        }
        Properties properties = POSScreenSettings.load();
        if (properties == null) {
            return null;
        }
        return properties.getProperty(id, defaultValue);
    }

    public static String getProperty(String id) {
        return POSScreenSettings.getProperty(id, null);
    }

    public static Properties getProperties() {
        return properties;
    }

    public static synchronized Properties load() {
        try {
            File file;
            if (properties == null) {
                properties = new Properties();
            }
            if (!(file = new File(settingsFilePath)).exists()) {
                return properties;
            }
            FileInputStream settingStream = new FileInputStream(file);
            properties.load(settingStream);
            ((InputStream)settingStream).close();
        }
        catch (Throwable e) {
            NaMaLogger.info((Object)"Could not read screen settings", (Throwable)e);
        }
        return properties;
    }

    public static void createSettingsFileIfNotFound() {
        properties = POSScreenSettings.load();
        if (ObjectChecker.isEmptyOrNull((Object)properties)) {
            properties.setProperty("compactMode", "true");
            properties.setProperty("colorfulMode", "true");
            properties.setProperty("traditionalMode", "false");
            properties.setProperty("darkMode", "false");
            properties.setProperty("boxColWidth", "");
            properties.setProperty("colorColWidth", "");
            properties.setProperty("revisionColWidth", "");
            properties.setProperty("lotColWidth", "");
            properties.setProperty("lineNumColWidth", "");
            properties.setProperty("serialColWidth", "");
            properties.setProperty("secondSerialColWidth", "");
            properties.setProperty("itemCodeColWidth", "");
            properties.setProperty("itemColWidth", "");
            properties.setProperty("qtyColWidth", "");
            properties.setProperty("unitPriceColWidth", "");
            properties.setProperty("totalPriceColWidth", "");
            properties.setProperty("disc1PercentColWidth", "");
            properties.setProperty("disc1ValColWidth", "");
            properties.setProperty("disc2PercentColWidth", "");
            properties.setProperty("disc2ValColWidth", "");
            properties.setProperty("tax1PercentColWidth", "");
            properties.setProperty("tax1ValColWidth", "");
            properties.setProperty("tax2PercentColWidth", "");
            properties.setProperty("tax2ValColWidth", "");
            properties.setProperty("netPriceColWidth", "");
            properties.setProperty("uomColWidth", "");
            properties.setProperty("sizeColWidth", "");
            properties.setProperty("afterDisc1ColWidth", "");
            properties.setProperty("afterDisc2ColWidth", "");
            properties.setProperty("afterTax1ColWidth", "");
            properties.setProperty("afterTax2ColWidth", "");
            properties.setProperty("depreciationReasonColWidth", "");
            properties.setProperty("returnReasonColWidth", "");
            properties.setProperty("itemActualCodeColWidth", "");
            POSScreenSettings.saveSetting(properties);
        }
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{POSScreenSettings.getProperty("itemColOrder")})) {
            properties.setProperty("lineNoColOrder", "0");
            properties.setProperty("itemCodeColOrder", "1");
            properties.setProperty("itemColOrder", "2");
            properties.setProperty("qtyColOrder", "3");
            properties.setProperty("uomColOrder", "4");
            properties.setProperty("colorColOrder", "5");
            properties.setProperty("sizeColOrder", "6");
            properties.setProperty("revisionColOrder", "7");
            properties.setProperty("lotColOrder", "8");
            properties.setProperty("serialNumColOrder", "9");
            properties.setProperty("secondSerialColOrder", "10");
            properties.setProperty("boxColOrder", "11");
            properties.setProperty("unitPriceColOrder", "12");
            properties.setProperty("totalPriceColOrder", "13");
            properties.setProperty("disc1ColOrder", "14");
            properties.setProperty("disc2ColOrder", "15");
            properties.setProperty("tax1ColOrder", "16");
            properties.setProperty("tax2ColOrder", "17");
            properties.setProperty("netPriceColOrder", "18");
            properties.setProperty("altCodeColOrder", "19");
            properties.setProperty("locatorColOrder", "20");
            properties.setProperty("unitCostColOrder", "21");
            properties.setProperty("totalCostColOrder", "22");
            properties.setProperty("resetDateColOrder", "23");
            properties.setProperty("productionDateColOrder", "24");
            properties.setProperty("expiryDateColOrder", "25");
            properties.setProperty("warehouseIssueColOrder", "26");
            properties.setProperty("depreciationReasonColOrder", "27");
            properties.setProperty("returnReasonColOrder", "28");
            properties.setProperty("itemActualCodeColOrder", "29");
            POSScreenSettings.saveSetting(properties);
        }
    }

    public static void saveSetting(Properties properties) {
        try (FileOutputStream out = new FileOutputStream(settingsFilePath);){
            properties.store(out, "save setting");
        }
        catch (IOException e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    public static String getLineNumColWidth() {
        return POSScreenSettings.getProperty("lineNumColWidth");
    }

    public static String getBtnsColWidth() {
        return POSScreenSettings.getProperty("btnsColWidth");
    }

    public static String getItemColWidth() {
        return POSScreenSettings.getProperty("itemColWidth");
    }

    public static String getItemCodeColWidth() {
        return POSScreenSettings.getProperty("itemCodeColWidth");
    }

    public static String getUomColWidth() {
        return POSScreenSettings.getProperty("uomColWidth");
    }

    public static String getSizeColWidth() {
        return POSScreenSettings.getProperty("sizeColWidth");
    }

    public static String getColorColWidth() {
        return POSScreenSettings.getProperty("colorColWidth");
    }

    public static String getRevisionColWidth() {
        return POSScreenSettings.getProperty("revisionColWidth");
    }

    public static String getQtyColWidth() {
        return POSScreenSettings.getProperty("qtyColWidth");
    }

    public static String getUnitPriceColWidth() {
        return POSScreenSettings.getProperty("unitPriceColWidth");
    }

    public static String getTotalPriceColWidth() {
        return POSScreenSettings.getProperty("totalPriceColWidth");
    }

    public static String getDisc1ValColWidth() {
        return POSScreenSettings.getProperty("disc1ValColWidth");
    }

    public static String getDisc1PercentColWidth() {
        return POSScreenSettings.getProperty("disc1PercentColWidth");
    }

    public static String getDisc2ValColWidth() {
        return POSScreenSettings.getProperty("disc2ValColWidth");
    }

    public static String getDisc2PercentColWidth() {
        return POSScreenSettings.getProperty("disc2PercentColWidth");
    }

    public static String getTax1ValColWidth() {
        return POSScreenSettings.getProperty("tax1ValColWidth");
    }

    public static String getTax1PercentColWidth() {
        return POSScreenSettings.getProperty("tax1PercentColWidth");
    }

    public static String getTax2ValColWidth() {
        return POSScreenSettings.getProperty("tax2ValColWidth");
    }

    public static String getTax2PercentColWidth() {
        return POSScreenSettings.getProperty("tax2PercentColWidth");
    }

    public static String getNetColWidth() {
        return POSScreenSettings.getProperty("netPriceColWidth");
    }

    public static String getLotColWidth() {
        return POSScreenSettings.getProperty("lotColWidth");
    }

    public static String getSerialColWidth() {
        return POSScreenSettings.getProperty("serialColWidth");
    }

    public static String getSecondSerialColWidth() {
        return POSScreenSettings.getProperty("secondSerialColWidth");
    }

    public static String getBoxColWidth() {
        return POSScreenSettings.getProperty("boxColWidth");
    }

    public static String getHideKeyPad() {
        return POSScreenSettings.getProperty("hideKeyPad");
    }

    public static String getHideNumbers() {
        return POSScreenSettings.getProperty("hideNumbers");
    }

    public static String getHideFavourites() {
        return POSScreenSettings.getProperty("hideFavourites");
    }

    public static String getAfterDisc1ColW() {
        return POSScreenSettings.getProperty("afterDisc1ColWidth");
    }

    public static String getAfterDisc2ColW() {
        return POSScreenSettings.getProperty("afterDisc2ColWidth");
    }

    public static String getAfterTax1ColW() {
        return POSScreenSettings.getProperty("afterTax1ColWidth");
    }

    public static String getAfterTax2ColW() {
        return POSScreenSettings.getProperty("afterTax2ColWidth");
    }

    public static String getDepreciationReasonColW() {
        return POSScreenSettings.getProperty("depreciationReasonColWidth");
    }

    public static String getReturnReasonColW() {
        return POSScreenSettings.getProperty("returnReasonColWidth");
    }

    public static String getItemActualCodeColW() {
        return POSScreenSettings.getProperty("itemActualCodeColWidth");
    }

    public static String getLineNoColOrder() {
        String property = POSScreenSettings.getProperty("lineNoColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-1";
        }
        return property;
    }

    public static String getItemCodeColOrder() {
        String property = POSScreenSettings.getProperty("itemCodeColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-2";
        }
        return property;
    }

    public static String getItemColOrder() {
        String property = POSScreenSettings.getProperty("itemColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-3";
        }
        return property;
    }

    public static String getWareIssueColOrder() {
        String property = POSScreenSettings.getProperty("warehouseIssueColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-33";
        }
        return property;
    }

    public static String getQtyColOrder() {
        String property = POSScreenSettings.getProperty("qtyColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-4";
        }
        return property;
    }

    public static String getUOMColOrder() {
        String property = POSScreenSettings.getProperty("uomColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-5";
        }
        return property;
    }

    public static String getSizeColOrder() {
        String property = POSScreenSettings.getProperty("sizeColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-6";
        }
        return property;
    }

    public static String getColorColOrder() {
        String property = POSScreenSettings.getProperty("colorColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-7";
        }
        return property;
    }

    public static String getRevisionColOrder() {
        String property = POSScreenSettings.getProperty("revisionColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-8";
        }
        return property;
    }

    public static String getLotColOrder() {
        String property = POSScreenSettings.getProperty("lotColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-9";
        }
        return property;
    }

    public static String getSerialNumColOrder() {
        String property = POSScreenSettings.getProperty("serialNumColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-10";
        }
        return property;
    }

    public static String getSecondSerialColOrder() {
        String property = POSScreenSettings.getProperty("secondSerialColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-11";
        }
        return property;
    }

    public static String getBoxColOrder() {
        String property = POSScreenSettings.getProperty("boxColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-12";
        }
        return property;
    }

    public static String getUnitPriceColOrder() {
        String property = POSScreenSettings.getProperty("unitPriceColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-13";
        }
        return property;
    }

    public static String getTotalPriceColOrder() {
        String property = POSScreenSettings.getProperty("totalPriceColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-14";
        }
        return property;
    }

    public static String getDisc1ColOrder() {
        String property = POSScreenSettings.getProperty("disc1ColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-15";
        }
        return property;
    }

    public static String getDisc2ColOrder() {
        String property = POSScreenSettings.getProperty("disc2ColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-16";
        }
        return property;
    }

    public static String getTax1ColOrder() {
        String property = POSScreenSettings.getProperty("tax1ColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-17";
        }
        return property;
    }

    public static String getTax2ColOrder() {
        String property = POSScreenSettings.getProperty("tax2ColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-18";
        }
        return property;
    }

    public static String getNetPriceColOrder() {
        String property = POSScreenSettings.getProperty("netPriceColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-19";
        }
        return property;
    }

    public static String getAltCodeColOrder() {
        String property = POSScreenSettings.getProperty("altCodeColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-20";
        }
        return property;
    }

    public static String getLocatorColOrder() {
        String property = POSScreenSettings.getProperty("locatorColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-21";
        }
        return property;
    }

    public static String getUnitCostColOrder() {
        String property = POSScreenSettings.getProperty("unitCostColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-22";
        }
        return property;
    }

    public static String getTotalCostColOrder() {
        String property = POSScreenSettings.getProperty("totalCostColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-23";
        }
        return property;
    }

    public static String getResetDateColOrder() {
        String property = POSScreenSettings.getProperty("resetDateColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-24";
        }
        return property;
    }

    public static String getProductionDateColOrder() {
        String property = POSScreenSettings.getProperty("productionDateColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-25";
        }
        return property;
    }

    public static String getExpiryColOrder() {
        String property = POSScreenSettings.getProperty("expiryDateColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-26";
        }
        return property;
    }

    public static String getDisc3ColOrder() {
        String property = POSScreenSettings.getProperty("disc3ColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-27";
        }
        return property;
    }

    public static String getDisc4ColOrder() {
        String property = POSScreenSettings.getProperty("disc4ColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-28";
        }
        return property;
    }

    public static String getDisc5ColOrder() {
        String property = POSScreenSettings.getProperty("disc5ColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-29";
        }
        return property;
    }

    public static String getDisc6ColOrder() {
        String property = POSScreenSettings.getProperty("disc6ColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-30";
        }
        return property;
    }

    public static String getDisc7ColOrder() {
        String property = POSScreenSettings.getProperty("disc7ColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-31";
        }
        return property;
    }

    public static String getDisc8ColOrder() {
        String property = POSScreenSettings.getProperty("disc8ColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-31";
        }
        return property;
    }

    public static String getRemarksOrder() {
        String property = POSScreenSettings.getProperty("remarksColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-32";
        }
        return property;
    }

    public static String getDepreciationReasonColOrder() {
        String property = POSScreenSettings.getProperty("depreciationReasonColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-34";
        }
        return property;
    }

    public static String getReturnReasonColOrder() {
        String property = POSScreenSettings.getProperty("returnReasonColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-35";
        }
        return property;
    }

    public static String getItemActualCodeColOrder() {
        String property = POSScreenSettings.getProperty("itemActualCodeColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-36";
        }
        return property;
    }

    public static String getSalesmanColOrder() {
        String property = POSScreenSettings.getProperty("salesmanColOrder");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return "-37";
        }
        return property;
    }

    public static String getLocatorColW() {
        return POSScreenSettings.getProperty("locatorColWidth");
    }

    public static String getAltCodeColWidth() {
        return POSScreenSettings.getProperty("altCodeColWidth");
    }

    public static double getTableHeadersFont() {
        String property = POSScreenSettings.getProperty("tableHeadersFont");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return 17.0;
        }
        return Double.valueOf(property);
    }

    public static double getTableCellsFont() {
        String property = POSScreenSettings.getProperty("tableCellsFont");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return 18.0;
        }
        return Double.valueOf(property);
    }

    public static double getTextFieldsFont() {
        String property = POSScreenSettings.getProperty("textFieldsFont");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return 20.0;
        }
        return Double.valueOf(property);
    }

    public static double getShortcutHeight() {
        String property = POSScreenSettings.getProperty("shortcutHeight");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return 50.0;
        }
        return Double.valueOf(property);
    }

    public static double getSearchDialogWidth() {
        String property = POSScreenSettings.getProperty("searchDialogW");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return 0.0;
        }
        return Double.valueOf(property);
    }

    public static double getSearchDialogHeight() {
        String property = POSScreenSettings.getProperty("searchDialogH");
        if (ObjectChecker.isEmptyOrNull((Object)property)) {
            return 0.0;
        }
        return Double.valueOf(property);
    }

    public static int getSearchRecordsCountPerPage() {
        Integer property = ObjectChecker.tryParseInt((String)POSScreenSettings.getProperty("searchDialogRecordsCount"));
        if (ObjectChecker.isEmptyOrZero((Integer)property)) {
            property = 10;
        }
        return property;
    }

    public static String getDisc3ValColWidth() {
        return POSScreenSettings.getProperty("disc3ValColWidth");
    }

    public static String getDisc3PercentColWidth() {
        return POSScreenSettings.getProperty("disc3PercentColWidth");
    }

    public static String getAfterDisc3ColW() {
        return POSScreenSettings.getProperty("afterDisc3ColWidth");
    }

    public static String getDisc4ValColWidth() {
        return POSScreenSettings.getProperty("disc4ValColWidth");
    }

    public static String getDisc4PercentColWidth() {
        return POSScreenSettings.getProperty("disc4PercentColWidth");
    }

    public static String getAfterDisc4ColW() {
        return POSScreenSettings.getProperty("afterDisc4ColWidth");
    }

    public static String getDisc5ValColWidth() {
        return POSScreenSettings.getProperty("disc5ValColWidth");
    }

    public static String getDisc5PercentColWidth() {
        return POSScreenSettings.getProperty("disc5PercentColWidth");
    }

    public static String getAfterDisc5ColW() {
        return POSScreenSettings.getProperty("afterDisc5ColWidth");
    }

    public static String getDisc6ValColWidth() {
        return POSScreenSettings.getProperty("disc6ValColWidth");
    }

    public static String getDisc6PercentColWidth() {
        return POSScreenSettings.getProperty("disc6PercentColWidth");
    }

    public static String getAfterDisc6ColW() {
        return POSScreenSettings.getProperty("afterDisc6ColWidth");
    }

    public static String getDisc7ValColWidth() {
        return POSScreenSettings.getProperty("disc7ValColWidth");
    }

    public static String getDisc7PercentColWidth() {
        return POSScreenSettings.getProperty("disc7PercentColWidth");
    }

    public static String getAfterDisc7ColW() {
        return POSScreenSettings.getProperty("afterDisc7ColWidth");
    }

    public static String getDisc8ValColWidth() {
        return POSScreenSettings.getProperty("disc8ValColWidth");
    }

    public static String getDisc8PercentColWidth() {
        return POSScreenSettings.getProperty("disc8PercentColWidth");
    }

    public static String getAfterDisc8ColW() {
        return POSScreenSettings.getProperty("afterDisc8ColWidth");
    }

    public static String getRemarksColWidth() {
        return POSScreenSettings.getProperty("remarksColOrder");
    }
}

