/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSActionLine;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.domain.entities.POSUser;
import com.namasoft.pos.util.LoginUtil;
import com.namasoft.pos.util.POSResult;
import java.util.Date;
import java.util.List;

public class POSSecurityUtil {
    private static POSUser lastLoginCapabilityAdmin = null;

    public static POSResult checkIfHasCapabilityForNewDoc(POSSecurityCapability capability) {
        return POSSecurityUtil.checkIfHasCapability(POSResourcesUtil.currentScreen, null, capability);
    }

    public static POSResult checkIfHasCapability(POSSecurityCapability capability) {
        IHasToolBar screen = POSResourcesUtil.currentScreen;
        return POSSecurityUtil.checkIfHasCapability(screen, screen.document(), capability);
    }

    public static <T extends POSMasterFile> POSResult checkIfHasCapability(IHasToolBar screen, T doc, POSSecurityCapability capability) {
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        POSResult result = POSSecurityUtil.userCan(currentUser.getUserId(), currentUser.getPassword(), capability);
        if (result.isSucceeded().booleanValue()) {
            return result;
        }
        POSSecurityUtil.showSecurityDialog(screen, doc, capability, result, currentUser, false);
        return result;
    }

    public static void addActionLine(String capability, POSMasterFile doc, Date actionDate, POSUser authorizedUser) {
        POSActionLine line = new POSActionLine();
        line.setCapability(POSResourcesUtil.idToEnglish(capability, new Object[0]));
        line.setActionDate(actionDate);
        line.assignIds();
        if (doc != null) {
            line.setDocType(doc.calcNamaEntityType());
            line.setDocCode(doc.getCode());
            line.setDocId(doc.getId());
        }
        line.setCurrentUser(POSSettingsInfo.fetchConfiguration().getCurrentUser());
        line.setAuthorizedUser(authorizedUser);
        POSPersister.saveOrUpdate(line);
    }

    private static void addActionLine(POSSecurityCapability capability, POSMasterFile doc, POSUser authorizedUser) {
        POSSecurityUtil.addActionLine(capability.name(), doc, new Date(), authorizedUser);
        POSSecurityUtil.setLastLoginCapabilityAdmin(null);
    }

    private static void updateDiscountApplierIfNeeded(AbsPOSSales salesDoc, POSSecurityCapability capability) {
        if (ObjectChecker.areNotEqual((Object)capability, (Object)POSSecurityCapability.CanMakeDocDisc)) {
            return;
        }
        if (!(salesDoc instanceof POSSalesInvoice)) {
            return;
        }
        if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getConsiderMaxDiscountFromApplier())) {
            return;
        }
        ((POSSalesInvoice)salesDoc).setDiscountApplier(POSSecurityUtil.getLastLoginCapabilityAdmin().getEmpId());
    }

    public static POSResult userCan(POSSecurityCapability capability) {
        if (POSSettingsInfo.fetchConfiguration().getCurrentUser() == null) {
            POSResult posResult = new POSResult();
            posResult.failure(String.format("User not logged in", new Object[0]), new Object[0]);
            return posResult;
        }
        return POSSecurityUtil.userCan(POSSettingsInfo.fetchConfiguration().getCurrentUser().getUserId(), POSSettingsInfo.fetchConfiguration().getCurrentUser().getPassword(), capability);
    }

    public static POSResult userCan(String userId, String password, POSSecurityCapability capability) {
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        POSResult result = new POSResult();
        POSUser user = null;
        user = ObjectChecker.areEqual((Object)currentUser.getUserId(), (Object)userId) ? currentUser : LoginUtil.authenticateUser(userId, password, result);
        if (ObjectChecker.isNotEmptyOrNull((Object)user)) {
            if (POSSecurityUtil.fetchUserCapability(capability, user)) {
                result.setFailed(false);
                if (ObjectChecker.areNotEqual((Object)user, (Object)currentUser)) {
                    lastLoginCapabilityAdmin = user;
                }
            } else {
                result.failure(POSResourcesUtil.id("This user has not this capability", new Object[0]) + " - " + POSResourcesUtil.id(capability.name(), new Object[0]), new Object[0]);
            }
        } else {
            result.failure(String.format("Wrong user name or password", new Object[0]), new Object[0]);
        }
        return result;
    }

    private static boolean fetchUserCapability(POSSecurityCapability capability, POSUser user) {
        if (ObjectChecker.isEmptyOrNull((Object)user.getSecurity())) {
            return false;
        }
        if (ObjectChecker.isTrue((Boolean)user.getSecurity().getAllCapabilities())) {
            return true;
        }
        if (user.getSecurity().getCapabilities().stream().anyMatch(c -> ObjectChecker.areEqual((Object)c.getCapability(), (Object)capability.name()))) {
            return true;
        }
        switch (capability) {
            case CanEditItemCode: {
                return user.getSecurity().getCanEditItemCode();
            }
            case CanCancelSalesLine: {
                return user.getSecurity().getCanCancelSalesLine();
            }
            case CanDepreciateSalesLine: {
                return user.getSecurity().getCanDepreciateSalesLine();
            }
            case CanEditPrice: {
                return user.getSecurity().getCanEditItemPrice();
            }
            case CanEditDeliveryCost: {
                return user.getSecurity().getCanEditDeliveryCost();
            }
            case CanEditQty: {
                return user.getSecurity().getCanEditLineQty();
            }
            case CanMakeLineDisc: {
                return user.getSecurity().getCanMakeLineDisc();
            }
            case CanMakeDocDisc: {
                return user.getSecurity().getCanMakeDocDisc();
            }
            case CanCancelInvoiceBeforeSave: {
                return user.getSecurity().getCanCancelInvoiceBeforeSave();
            }
            case CanMakePayments: {
                return user.getSecurity().getCanMakePaymentDoc();
            }
            case CanMakeReceipts: {
                return user.getSecurity().getCanMakeReceiptDoc();
            }
            case CanOpenCloseShift: {
                return user.getSecurity().getCanOpenCloseShifts();
            }
            case CanEditSettings: {
                return user.getSecurity().getCanEditSettings();
            }
            case CanMakeReturnWithoutInvoice: {
                return user.getSecurity().getCanReturnWithoutInvoice();
            }
            case CanInquireForPrice: {
                return user.getSecurity().getCanInquireForPrices();
            }
            case CanMakeCashCount: {
                return user.getSecurity().getCanMakeCashCount();
            }
            case CanDeleteHold: {
                return user.getSecurity().getCanDeleteHeldInvoices();
            }
            case CanEditSalesUom: {
                return user.getSecurity().getCanEditSalesUom();
            }
            case CanHoldInvoice: {
                return user.getSecurity().getCanHoldInvoice();
            }
            case CanOpenCashDrawer: {
                return user.getSecurity().getCanOpenCashDrawer();
            }
            case CanAddCustomer: {
                return user.getSecurity().getCanAddCustomer();
            }
            case CanOpenOldInvoice: {
                return user.getSecurity().getCanOpenOldInvoice();
            }
            case CanPayWithCreditVal: {
                return user.getSecurity().getCanPayWithCreditVal();
            }
            case CanEditItemDims: {
                return user.getSecurity().getCanEditItemDims();
            }
            case CanReplaceWithoutInvoice: {
                return user.getSecurity().getCanReplaceWithoutInvoice();
            }
            case CanViewAccountant: {
                return user.getSecurity().getCanViewAccountantBalance();
            }
            case CanPrintFullInvoice: {
                return user.getSecurity().getCanPrintFullInvoice();
            }
            case CanEditSalesMan: {
                return user.getSecurity().getCanEditSalesMan();
            }
            case CanMakeLineTaxes: {
                return user.getSecurity().getCanMakeLineTaxes();
            }
            case CanCloseAnotherUserShift: {
                return user.getSecurity().getCanCloseAnotherUserShift();
            }
            case CanEditInvoiceClassification: {
                return user.getSecurity().getCanEditInvoiceClassification();
            }
            case CanSearchOnItemCode: {
                return user.getSecurity().getCanSearchOnItemCode();
            }
            case CanSearchOnInvoiceInReturnAndReplacement: {
                return user.getSecurity().getCanSearchOnInvInRetAndRepl();
            }
            case CanMakeReplacement: {
                return user.getSecurity().getCanMakeReplacement();
            }
            case CanMakeReturn: {
                return user.getSecurity().getCanMakeReturn();
            }
            case CanShowDataTransferErrors: {
                return user.getSecurity().getCanShowDataTransferErrors();
            }
            case CanSearchByInvCodePart: {
                return user.getSecurity().getCanSearchByInvoiceCodePart();
            }
            case CanUseCalculator: {
                return user.getSecurity().getCanUseCalculator();
            }
            case CanUseKeyBoard: {
                return user.getSecurity().getCanUseKeyBoard();
            }
            case CanShowPaymentsDetails: {
                return user.getSecurity().getCanShowPaymentsDetails();
            }
            case CanMakeStockTransferReq: {
                return user.getSecurity().getCanMakeStockTransferReq();
            }
            case CanGiveFreeItems: {
                return user.getSecurity().getCanGiveFreeItems();
            }
            case CanShowFieldIds: {
                return user.getSecurity().getCanShowFieldIds();
            }
            case CanEditServiceItemPrice: {
                return user.getSecurity().getCanEditServiceItemPrice();
            }
            case CanCancelTaxes: {
                return user.getSecurity().getCanCancelTaxes();
            }
            case CanSearchOnCustomers: {
                return user.getSecurity().getCanSearchOnCustomers();
            }
            case CanRePrintDocuments: {
                return user.getSecurity().getCanRePrintDocuments();
            }
            case CanEditReturnUnitPrice: {
                return user.getSecurity().getCanEditReturnUnitPrice();
            }
            case CanEditReturnDiscOrTax: {
                return user.getSecurity().getCanEditReturnDiscOrTax();
            }
            case CanReorderSalesColumns: {
                return ObjectChecker.isFalseOrNull((Boolean)user.getSecurity().getPreventReorderColumns());
            }
            case CanResizeSalesColumns: {
                return ObjectChecker.isFalseOrNull((Boolean)user.getSecurity().getPreventResizeColumns());
            }
            case CanViewNotification: {
                return ObjectChecker.isFalseOrNull((Boolean)user.getSecurity().getPreventViewNotifications());
            }
            case CanReturnInAnotherUserShift: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getCanReturnInAnotherUserShift());
            }
            case CanReplaceInAnotherUserShift: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getCanReplaceInAnotherUserShift());
            }
            case CanUseAnotherUserShift: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getCanUseAnotherUserShift());
            }
            case CanUseShortcuts: {
                return ObjectChecker.isFalseOrNull((Boolean)user.getSecurity().getDeactivateShortcuts());
            }
            case CanUseCriticalMethods: {
                return ObjectChecker.isFalseOrNull((Boolean)user.getSecurity().getPreventUsingCriticalMethods());
            }
            case CanUserFractionDiscounts: {
                return ObjectChecker.isFalseOrNull((Boolean)user.getSecurity().getPreventFractionDiscount());
            }
            case CanEditCustomer: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getCanEditCustomer());
            }
            case CanDelayInvoicePayment: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getCanDelayInvoicePayment());
            }
            case CanReceiptFromPurchaseInv: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getCanReceiptFromPurchaseInv());
            }
            case CanReceiptFromStockTransfer: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getCanReceiptFromStockTransfer());
            }
            case CanReceiptWithoutOriginDoc: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getCanReceiptWithoutOriginDoc());
            }
            case ShowAllInvoices: {
                return ObjectChecker.isFalseOrNull((Boolean)user.getSecurity().getShowCurrentShiftInvoicesOnly());
            }
            case ShowAllPayments: {
                return ObjectChecker.isFalseOrNull((Boolean)user.getSecurity().getShowCurrentShiftPaymentsOnly());
            }
            case ShowAllReceipts: {
                return ObjectChecker.isFalseOrNull((Boolean)user.getSecurity().getShowCurrentShiftReceiptsOnly());
            }
            case AllowSalesmanUpdate: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getAllowSalesmanUpdate());
            }
            case AllowHideOffersDialog: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getAllowHideOffersDialog());
            }
            case CanPrintHeldInvoice: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getCanPrintHeldInvoice());
            }
            case CanMakeScrapDoc: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getCanMakeScrapDoc());
            }
            case CanMakeShortfallsDoc: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getCanMakeShortfallsDoc());
            }
            case CanRemoveSalesReturnFreeItems: {
                return ObjectChecker.isTrue((Boolean)user.getSecurity().getCanRemoveSalesReturnFreeItems());
            }
        }
        return false;
    }

    public static POSUser getLastLoginCapabilityAdmin() {
        return lastLoginCapabilityAdmin;
    }

    public static void setLastLoginCapabilityAdmin(POSUser lastLoginCapabilityAdmin) {
        POSSecurityUtil.lastLoginCapabilityAdmin = lastLoginCapabilityAdmin;
    }

    public static <T extends POSMasterFile> POSResult checkIfNotHavePreventCapability(IHasToolBar screen, T doc, POSSecurityCapability preventCapability) {
        POSUser currentUser = POSSettingsInfo.fetchConfiguration().getCurrentUser();
        POSResult result = POSSecurityUtil.userCan(currentUser.getUserId(), currentUser.getPassword(), preventCapability);
        boolean doesNotHaveThePreventCapability = result.isFailed();
        if (doesNotHaveThePreventCapability) {
            return result;
        }
        result.failure("User prevented from this action", new Object[0]);
        POSSecurityUtil.showSecurityDialog(screen, doc, preventCapability, result, currentUser, true);
        return result;
    }

    private static <T extends POSMasterFile> void showSecurityDialog(IHasToolBar screen, T doc, POSSecurityCapability capability, POSResult result, POSUser currentUser, boolean preventCapability) {
        List authorizationFor = POSResourcesUtil.fetchPOSConfig().getRequestAuthorizationFor();
        if (ObjectChecker.isNotEmptyOrNull((Object)authorizationFor) && authorizationFor.stream().anyMatch(auth -> ObjectChecker.areEqual((Object)auth.getCapability(), (Object)capability.name()))) {
            PosScene.lockDialogHeader = result.getMessageByLanguage();
            POSUser authorizedUser = PosScene.showSecurityDialog(capability, preventCapability);
            if (authorizedUser != null && ObjectChecker.areNotEqual((Object)currentUser.getId(), (Object)authorizedUser.getId())) {
                if (screen != null) {
                    if (screen instanceof AbsPosSalesScreen && doc != null) {
                        POSSecurityUtil.updateDiscountApplierIfNeeded((AbsPOSSales)doc, capability);
                    }
                    POSSecurityUtil.addActionLine(capability, doc, authorizedUser);
                }
                result.setFailed(false);
            }
        }
        if (screen != null && result.isFailed().booleanValue()) {
            POSErrorAndInfoMessagesUtil.showError(result, screen.fetchStage());
        }
    }
}

