/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.flatobjects.LocalDateUtils;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaProgressBarDialog;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.IPOSShiftScreen;
import com.namasoft.pos.application.POSOldDocsUtility;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.controllers.MobileDTOPOSShift;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.AbsPOSShiftInventory;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSInventory;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSShiftClose;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.util.POSResult;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.concurrent.Task;

public class POSShiftInventoryService {
    public static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");

    public static Date parseDate(String value) {
        LocalDateTime ldt = LocalDateTime.parse(value, dateFormat);
        return Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static AbsPOSShiftInventory createShiftDoc(POSRegistery register, boolean shift, String code, IPOSShiftScreen shiftView) {
        AbsPOSShiftInventory shiftOrInventory = null;
        if (shift) {
            shiftOrInventory = POSResourcesUtil.fetchLastOpenShift(register);
            if (ObjectChecker.isNotEmptyOrNull((Object)shiftOrInventory) && ObjectChecker.isNotEmptyOrNull((Object)shiftOrInventory.getCode())) {
                String lastOpenCode = shiftOrInventory.getCode();
                shiftOrInventory = new POSShiftClose();
                shiftOrInventory.setCode(lastOpenCode);
            } else {
                shiftOrInventory = new POSShiftOpen();
                POSShiftInventoryService.removeExpiredDocs(register, shiftView);
            }
        } else {
            shiftOrInventory = new POSInventory();
        }
        if (ObjectChecker.isEmptyOrNull((Object)shiftOrInventory.getCode())) {
            shiftOrInventory.setCode(code);
        }
        Date date = new Date();
        String[] dataAndTime = dateFormat.format(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).split(" ");
        shiftOrInventory.setShiftDate(new Date(dataAndTime[0]));
        shiftOrInventory.setShiftTime(dataAndTime[1]);
        shiftOrInventory.setRegistery(register);
        shiftOrInventory.setView((IHasToolBar)((Object)shiftView));
        return shiftOrInventory;
    }

    private static void removeExpiredDocs(POSRegistery register, IPOSShiftScreen shiftView) {
        Integer removeDocsAfter = ObjectChecker.getFirstNotEmptyOrZero((Integer[])new Integer[]{register.getRemoveDocsAfter()});
        if (ObjectChecker.isEmptyOrZero((Integer)removeDocsAfter)) {
            return;
        }
        Date creationDate = LocalDateUtils.localDateToDate((LocalDate)LocalDate.now().minusDays(removeDocsAfter.intValue()));
        String condition = " Where creationDate <= :creationDate AND sent = true";
        HashMap<String, Object> params = POSPersister.params("creationDate", creationDate);
        Task deletionTask = POSOldDocsUtility.fetchDeletionTask(condition, params);
        if (shiftView == null) {
            Thread thread = new Thread((Runnable)deletionTask, "removeExpiredDocs");
            thread.setPriority(10);
            thread.setDaemon(true);
            thread.start();
        } else {
            NamaProgressBarDialog progressBarDialog = new NamaProgressBarDialog();
            progressBarDialog.constructNamaProgressBarDialog(deletionTask);
            progressBarDialog.getDialogPane().setHeaderText(POSResourcesUtil.id("deletingExpiredDocsProcess", new Object[0]));
            progressBarDialog.showAndWait();
        }
    }

    public static <T extends IPOSShiftScreen & IHasToolBar> void saveShift(POSCreateShiftRequest request, POSResult result) {
        POSRegistery register = POSResourcesUtil.fetchRegister(request.registerId);
        request.shiftDetails.set(0, request.shiftDetails.get(0));
        POSShiftInventoryService.validateShift(register, request.isShift, request.isShiftClosing, request.code, request.shiftDetails, result);
        if (result.isFailed().booleanValue()) {
            return;
        }
        POSShiftInventoryService.updateShiftData(request.shift, register, request.remarks, request.code, request.shiftDetails, request.view);
        POSShiftInventoryService.fireAction(register, request.shift, request.isShift, result);
    }

    private static <T extends IPOSShiftScreen & IHasToolBar> void validateShift(POSRegistery register, boolean isShift, boolean isShiftClosing, String code, List<AbsPOSInventoryLine> shiftDetails, POSResult result) {
        boolean debitValueNoConsistent;
        if (ObjectChecker.isEmptyOrNull((Object)code)) {
            result.failure(POSResourcesUtil.id("Please enter code", new Object[0]), new Object[0]);
        }
        if (ObjectChecker.isEmptyOrNull((Object)POSResourcesUtil.fetchLastOpenShift(register)) && !isShift) {
            result.failure("Please open shift firstly", new Object[0]);
        }
        String query = " where hold = true and registerId =:registerId ";
        HashMap<String, Object> params = POSPersister.params("registerId", register.getId());
        List<?> holdInvoices = POSPersister.listAll(POSSalesInvoice.class, query, params, "code");
        List<?> holdReturns = POSPersister.listAll(POSSalesReturn.class, query, params, "code");
        List<?> holdReplacements = POSPersister.listAll(POSSalesReplacement.class, query, params, "code");
        boolean shiftClosing = isShiftClosing;
        if (shiftClosing && ObjectChecker.isAnyNotEmptyOrNull((Object[])new Object[]{holdInvoices, holdReturns, holdReplacements}) && ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getPreventCloseOnHoldDocExist())) {
            result.failure(POSResourcesUtil.id("You can not close shift if there is any held invoices", new Object[0]), new Object[0]);
        }
        String creditNotesQuery = " where shiftCode=:shiftCode";
        POSShiftInventoryService.validateShiftNotHasUnusedCreditNotesIfNeeded(code, result, creditNotesQuery, shiftClosing);
        String query2 = " where paymentDelayed = true and registerId =:registerId ";
        List<?> delayedInvoices = POSPersister.listAll(POSSalesInvoice.class, query2, params, "code");
        if (shiftClosing && ObjectChecker.isAnyNotEmptyOrNull((Object[])new Object[]{delayedInvoices})) {
            result.failure(POSResourcesUtil.id("You can not close shift if there is any delayed payment invoices", new Object[0]), new Object[0]);
        }
        if (!CollectionsUtility.filter(shiftDetails, object -> object.isCash() != false && object.getActualRemaining().compareTo(BigDecimal.ZERO) < 0).isEmpty()) {
            result.failure(POSResourcesUtil.id("Negative actual value", new Object[0]), new Object[0]);
        }
        if (debitValueNoConsistent = shiftDetails.stream().anyMatch(object -> object.getActualRemaining().compareTo(object.getAccountantRemaining()) != 0 && object.getPaymentWay().equalsIgnoreCase(POSResourcesUtil.id("debitValue", new Object[0])))) {
            result.failure("Cannot change debit value", new Object[0]);
        }
    }

    private static void validateShiftNotHasUnusedCreditNotesIfNeeded(String code, POSResult result, String creditNotesQuery, boolean shiftClosing) {
        if (ObjectChecker.isAnyFalseOrNull((Boolean[])new Boolean[]{shiftClosing, POSResourcesUtil.fetchPOSConfig().getPreventShiftCloseOnUnusedCreditNotes()})) {
            return;
        }
        List<?> creditNotes = POSPersister.listAll(POSCreditNote.class, creditNotesQuery, POSPersister.params("shiftCode", code), "code");
        boolean hasUnusedCreditNote = creditNotes.stream().anyMatch(l -> ObjectChecker.isNotEmptyOrZero((BigDecimal)l.calcUnPaidAmount()));
        if (hasUnusedCreditNote) {
            result.failure(POSResourcesUtil.id("You can not close shift if there is any unused credit notes", new Object[0]), new Object[0]);
        }
    }

    private static <T extends IPOSShiftScreen & IHasToolBar> void updateShiftData(AbsPOSShiftInventory shift, POSRegistery register, String remarks, String code, List<AbsPOSInventoryLine> shiftDetails, IHasToolBar view) {
        Date date1 = new Date();
        String[] dataAndTime1 = dateFormat.format(date1.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).split(" ");
        shift.setShiftDate(date1);
        shift.setTime(dataAndTime1[1]);
        shift.setRemarks(remarks);
        shift.updateCode(code);
        shift.setRegistery(register);
        shift.updateDetails(shiftDetails);
        shift.setView(view);
        POSResourcesUtil.updateDocDateAndTime(shift);
    }

    private static <T extends IPOSShiftScreen & IHasToolBar> void fireAction(POSRegistery register, AbsPOSShiftInventory shift, boolean isShift, POSResult result) {
        if (isShift) {
            if (shift instanceof POSShiftOpen) {
                POSShiftOpen shiftOpen = (POSShiftOpen)shift;
                shiftOpen.open(register, result);
            } else {
                ((POSShiftClose)shift).close(register, result);
            }
        } else {
            ((POSInventory)shift).setShiftCode(POSResourcesUtil.fetchLastOpenShift().getCode());
            ((POSInventory)shift).save();
        }
    }

    public static class POSCreateShiftRequest {
        private AbsPOSShiftInventory shift;
        private Boolean isShift;
        private Boolean isShiftClosing;
        private String code;
        private String registerId;
        private String remarks;
        private List<AbsPOSInventoryLine> shiftDetails;
        private IHasToolBar view;

        public POSCreateShiftRequest() {
        }

        public POSCreateShiftRequest(IPOSShiftScreen shiftScreen) {
            this.setShift(shiftScreen.getShiftOrInventory());
            this.setIsShift(shiftScreen.isShift());
            this.setShiftClosing(shiftScreen.isShiftClosing());
            this.setCode(shiftScreen.getCode());
            this.setRegisterId(shiftScreen.getRegisteryCodeTextField().getIdBox().getText());
            this.setRemarks(shiftScreen.getRemarksField().getText());
            this.setShiftDetails(shiftScreen.calcLines());
            this.setView((IHasToolBar)((Object)shiftScreen));
        }

        public POSCreateShiftRequest(MobileDTOPOSShift shiftDto) {
            AbsPOSShiftInventory actualShift = shiftDto.toPOSShift();
            this.setShift(actualShift);
            this.setIsShift(true);
            this.setShiftClosing(ObjectChecker.areEqual((Object)shiftDto.getEntityType(), (Object)"POSShiftClosing"));
            this.setCode(shiftDto.getCode());
            this.setRegisterId(shiftDto.getRegister().getId());
            this.setRemarks(shiftDto.getRemarks());
            for (AbsPOSInventoryLine detail : actualShift.fetchDetails()) {
                this.getShiftDetails().add(detail);
            }
            this.setView(null);
        }

        public AbsPOSShiftInventory getShift() {
            return this.shift;
        }

        public void setShift(AbsPOSShiftInventory shift) {
            this.shift = shift;
        }

        public void setIsShift(Boolean shift) {
            this.isShift = shift;
        }

        public boolean getIsShift() {
            return this.isShift;
        }

        public Boolean getShiftClosing() {
            return this.isShiftClosing;
        }

        public void setShiftClosing(Boolean shiftClosing) {
            this.isShiftClosing = shiftClosing;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getRegisterId() {
            return this.registerId;
        }

        public void setRegisterId(String registerId) {
            this.registerId = registerId;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public void setRemarks(String remarks) {
            this.remarks = remarks;
        }

        public List<AbsPOSInventoryLine> getShiftDetails() {
            if (this.shiftDetails == null) {
                this.shiftDetails = new ArrayList<AbsPOSInventoryLine>();
            }
            return this.shiftDetails;
        }

        public void setShiftDetails(List<AbsPOSInventoryLine> shiftDetails) {
            this.shiftDetails = shiftDetails;
        }

        public IHasToolBar getView() {
            return this.view;
        }

        public void setView(IHasToolBar view) {
            this.view = view;
        }
    }
}

