/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PaymentInfo;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.entities.POSRegistery;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PayRequest {
    private String remarks;
    private AbsPOSSales salesDoc;
    private AbsPosSalesScreen screen;
    private BigDecimal cashValue;
    private Map<POSPaymentMethod, List<PaymentInfo>> payments;
    private boolean useCreditNotes = ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getUseCreditNotes());
    private List<PaymentInfo> creditNotesInfo;
    private String creditNoteMethodName = "Credit Note";
    private boolean useCoupons = ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchPOSConfig().getUseCoupons());
    private List<PaymentInfo> couponsInfo;
    private BigDecimal defaultCashAmount;
    private BigDecimal debitAmount;
    private String couponMethodName = "Coupon";
    private boolean delayPayment;
    private BigDecimal value;
    private POSDocumentType docType;
    private BigDecimal remainingAmount;
    private boolean printFullInvoice;
    private boolean shouldPrintAfterPayment;
    private POSRegistery register;

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public AbsPOSSales getSalesDoc() {
        return this.salesDoc;
    }

    public void setSalesDoc(AbsPOSSales salesDoc) {
        this.salesDoc = salesDoc;
    }

    public AbsPosSalesScreen getScreen() {
        return this.screen;
    }

    public void setScreen(AbsPosSalesScreen screen) {
        this.screen = screen;
    }

    public BigDecimal getCashValue() {
        return ObjectChecker.toZeroIfNull((BigDecimal)this.cashValue);
    }

    public void setCashValue(BigDecimal cashValue) {
        this.cashValue = cashValue;
    }

    public Map<POSPaymentMethod, List<PaymentInfo>> getPayments() {
        return this.payments;
    }

    public void setPayments(Map<POSPaymentMethod, List<PaymentInfo>> payments) {
        this.payments = payments;
    }

    public boolean isUseCreditNotes() {
        return this.useCreditNotes;
    }

    public List<PaymentInfo> getCreditNotesInfo() {
        if (this.creditNotesInfo == null) {
            this.creditNotesInfo = new ArrayList<PaymentInfo>();
        }
        return this.creditNotesInfo;
    }

    public void setCreditNotesInfo(List<PaymentInfo> creditNotesInfo) {
        this.creditNotesInfo = creditNotesInfo;
    }

    public String getCreditNoteMethodName() {
        if (this.couponsInfo == null) {
            this.couponsInfo = new ArrayList<PaymentInfo>();
        }
        return this.creditNoteMethodName;
    }

    public void setCreditNoteMethodName(String creditNoteMethodName) {
        this.creditNoteMethodName = creditNoteMethodName;
    }

    public boolean isUseCoupons() {
        return this.useCoupons;
    }

    public List<PaymentInfo> getCouponsInfo() {
        if (this.couponsInfo == null) {
            this.couponsInfo = new ArrayList<PaymentInfo>();
        }
        return this.couponsInfo;
    }

    public void setCouponsInfo(List<PaymentInfo> couponsInfo) {
        this.couponsInfo = couponsInfo;
    }

    public BigDecimal getDefaultCashAmount() {
        return ObjectChecker.toZeroIfNull((BigDecimal)this.defaultCashAmount);
    }

    public void setDefaultCashAmount(BigDecimal defaultCashAmount) {
        this.defaultCashAmount = defaultCashAmount;
    }

    public BigDecimal getDebitAmount() {
        return ObjectChecker.toZeroIfNull((BigDecimal)this.debitAmount);
    }

    public void setDebitAmount(BigDecimal debitAmount) {
        this.debitAmount = debitAmount;
    }

    public String getCouponMethodName() {
        return this.couponMethodName;
    }

    public void setCouponMethodName(String couponMethodName) {
        this.couponMethodName = couponMethodName;
    }

    public boolean isDelayPayment() {
        return this.delayPayment;
    }

    public void setDelayPayment(boolean delayPayment) {
        this.delayPayment = delayPayment;
    }

    public BigDecimal getValue() {
        return ObjectChecker.toZeroIfNull((BigDecimal)this.value);
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public POSDocumentType getDocType() {
        return this.docType;
    }

    public void setDocType(POSDocumentType docType) {
        this.docType = docType;
    }

    public BigDecimal getRemainingAmount() {
        return ObjectChecker.toZeroIfNull((BigDecimal)this.remainingAmount);
    }

    public void setRemainingAmount(BigDecimal remainingAmount) {
        this.remainingAmount = remainingAmount;
    }

    public boolean isPrintFullInvoice() {
        return this.printFullInvoice;
    }

    public void setPrintFullInvoice(boolean printFullInvoice) {
        this.printFullInvoice = printFullInvoice;
    }

    public boolean isShouldPrintAfterPayment() {
        return this.shouldPrintAfterPayment;
    }

    public void setShouldPrintAfterPayment(boolean shouldPrintAfterPayment) {
        this.shouldPrintAfterPayment = shouldPrintAfterPayment;
    }

    public POSRegistery getRegister() {
        return this.register;
    }

    public void setRegister(POSRegistery register) {
        this.register = register;
    }
}

