/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.util;

import com.namasoft.common.Pair;
import com.namasoft.pos.application.IPOSCachedObject;
import com.namasoft.pos.domain.valueobjects.POSItemSalesPriceResDetail;
import com.namasoft.pos.util.POSPricesCachingUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PosPriceCachedObject
implements IPOSCachedObject {
    private List<Pair<BigDecimal, POSItemSalesPriceResDetail>> resDetail;
    private Date lastUsageDate;

    public PosPriceCachedObject() {
        this.setLastUsageDate(new Date());
        this.setResDetail(new ArrayList<Pair<BigDecimal, POSItemSalesPriceResDetail>>());
    }

    public void setResDetail(List<Pair<BigDecimal, POSItemSalesPriceResDetail>> resDetail) {
        this.resDetail = resDetail;
    }

    @Override
    public Date getLastUsageDate() {
        return this.lastUsageDate;
    }

    @Override
    public void setLastUsageDate(Date lastUsageDate) {
        this.lastUsageDate = lastUsageDate;
    }

    public POSItemSalesPriceResDetail findApprPriceResDetail(BigDecimal qty) {
        Pair first = this.resDetail.stream().filter(l -> ((BigDecimal)l.getX()).equals(qty)).findFirst().orElse(null);
        if (first != null) {
            return (POSItemSalesPriceResDetail)first.getY();
        }
        return null;
    }

    public static void appendOrCreate(BigDecimal qty, String key, POSItemSalesPriceResDetail priceResDetail) {
        PosPriceCachedObject posPriceCachedObject = POSPricesCachingUtil.priceEntries.get(key);
        if (posPriceCachedObject == null) {
            posPriceCachedObject = new PosPriceCachedObject();
            posPriceCachedObject.resDetail.add((Pair<BigDecimal, POSItemSalesPriceResDetail>)new Pair((Object)qty, (Object)priceResDetail));
            POSPricesCachingUtil.priceEntries.put(key, posPriceCachedObject);
            return;
        }
        POSItemSalesPriceResDetail priceRes = priceResDetail;
        Pair old = posPriceCachedObject.resDetail.stream().filter(l -> ((BigDecimal)l.getX()).equals(qty)).findFirst().orElse(null);
        if (old != null) {
            old.setY((Object)priceResDetail);
        } else {
            posPriceCachedObject.resDetail.add((Pair<BigDecimal, POSItemSalesPriceResDetail>)new Pair((Object)qty, (Object)priceRes));
        }
    }
}

