/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader;

import com.namasoft.upgrader.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtils {
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES";
    private static final byte[] key = new byte[]{1, -55, 12, 66, 32, 88, 10, 12, 127, -116, 118, 75, 96, -32, 84, 75};
    public static final String prefix = "$EN$:-";

    public static String encrypt(String input) {
        return CryptoUtils.encrypt(input, key);
    }

    public static String encrypt(String input, String key) {
        try {
            return CryptoUtils.encrypt(input, key.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isNotEmptyOrNull(Object object) {
        return !CryptoUtils.isEmptyOrNull(object);
    }

    public static boolean isEmptyOrNull(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object instanceof String) {
            return ((String)object).isEmpty();
        }
        if (object instanceof StringBuilder) {
            return ((StringBuilder)object).length() == 0;
        }
        return false;
    }

    public static String encrypt(String input, byte[] key) {
        if (CryptoUtils.isEmptyOrNull(input)) {
            return input;
        }
        try {
            byte[] encrypted = CryptoUtils.doCrypt(1, input.getBytes("utf-8"), key);
            return Base64.toBase64(encrypted);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String safeEncrypt(String input) {
        if (input.contains(prefix)) {
            return input;
        }
        return prefix + CryptoUtils.encrypt(input);
    }

    public static String decryptConsiderPrefix(String input) {
        String encryptedInput = input.substring(prefix.length());
        return CryptoUtils.decrypt(encryptedInput);
    }

    public static String decrypt(String input) {
        return CryptoUtils.decrypt(input, key);
    }

    public static String decrypt(String input, String key) {
        try {
            return CryptoUtils.decrypt(input, key.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String input, byte[] key) {
        if (CryptoUtils.isEmptyOrNull(input)) {
            return input;
        }
        byte[] decryptedBytes = CryptoUtils.doCrypt(2, Base64.fromBase64(input), key);
        try {
            return new String(decryptedBytes, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] doCrypt(int cipherMode, byte[] input, byte[] key) {
        byte[] outputBytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(cipherMode, secretKey);
            outputBytes = cipher.doFinal(input);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        return outputBytes;
    }

    public static void main(String[] args) {
        String s = CryptoUtils.safeEncrypt("123");
        System.out.println(s);
        System.out.println(CryptoUtils.decryptConsiderPrefix("$EN$:-8BEB"));
    }
}

