/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader;

import com.namasoft.upgrader.ProgressHandler;
import com.namasoft.upgrader.UIUtils;

public class FileConsoleProgressHandler
implements ProgressHandler {
    private long contentLength;
    private String url;
    private String toPath;
    private double progress;
    private boolean logURL;

    public FileConsoleProgressHandler() {
        this(true);
    }

    public FileConsoleProgressHandler(boolean logURL) {
        this.logURL = logURL;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void setToPath(String toPath) {
        this.toPath = toPath;
    }

    @Override
    public void onContentLengthAvailaible(long contentLength) {
        UIUtils.msg("Downloading " + (this.logURL ? this.url : "") + " To " + this.toPath + ": " + contentLength / 0x100000L + " MB of data");
        this.contentLength = contentLength;
    }

    @Override
    public void onReadProgress(long read) {
        long currentPercent = read * 10000L / this.contentLength;
        double currentProgress = (double)currentPercent / 100.0;
        if (currentProgress - this.progress > 0.5 || this.progress >= 99.6) {
            UIUtils.msg(currentProgress + "%");
            this.progress = currentProgress;
        }
    }

    public double getProgress() {
        return this.progress;
    }
}

