/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader;

import com.namasoft.upgrader.UIUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtils {
    public static List<String> readFile(String fileName) {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            reader.close();
            return lines;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteDir(File file) {
        FileUtils.deleteDir(file, false);
    }

    public static void deleteDir(File file, boolean deleteContentsOnly) {
        File[] contents = file.listFiles();
        if (contents != null) {
            for (File f : contents) {
                FileUtils.deleteDir(f, false);
            }
        }
        if (!deleteContentsOnly) {
            file.delete();
        }
    }

    public static void copy(Path source, Path target) throws IOException {
        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
    }

    public static boolean testWrite(Path elevatedRunner) {
        try {
            Files.write(elevatedRunner, Arrays.asList(""), new OpenOption[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void unZipIt(File zipFile, File outputFolder) {
        FileUtils.unZipIt(zipFile, outputFolder.getAbsolutePath(), "", new String[0]);
    }

    public static void unZipIt(File zipFile, String outputFolderName, String omittedPrefix, String ... ignoredPrefixes) {
        try {
            File folder = new File(outputFolderName);
            folder.mkdir();
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                for (String ignoredPrefix : ignoredPrefixes) {
                    if (ignoredPrefix != null && !ignoredPrefix.isEmpty() && !ze.getName().startsWith(ignoredPrefix)) continue;
                }
                String name = ze.getName();
                if (omittedPrefix.length() > 0) {
                    name = !name.startsWith(omittedPrefix) ? "" : (name.length() < omittedPrefix.length() ? "" : name.substring(omittedPrefix.length()));
                }
                if (name.isEmpty()) {
                    ze = zis.getNextEntry();
                    continue;
                }
                if (ze.isDirectory()) {
                    new File(folder, name).mkdirs();
                    ze = zis.getNextEntry();
                    continue;
                }
                String fileName = name;
                File newFile = new File(folder, fileName).getAbsoluteFile();
                UIUtils.msg("Inflating File: " + String.valueOf(newFile.getAbsoluteFile()));
                new File(newFile.getParent()).mkdirs();
                Files.copy(zis, newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

