/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader;

import java.lang.management.ManagementFactory;

public class Platform {
    private static final int UNSPECIFIED = -1;
    private static final int MAC = 0;
    private static final int LINUX = 1;
    private static final int WINDOWS = 2;
    private static final int SOLARIS = 3;
    private static final int FREEBSD = 4;
    private static final int osType;
    private static int arch;
    private static Boolean isInDebugMode;

    private Platform() {
    }

    public static final boolean isMac() {
        return osType == 0;
    }

    public static final boolean isLinux() {
        return osType == 1;
    }

    public static final boolean isWindows() {
        return osType == 2;
    }

    public static final boolean isSolaris() {
        return osType == 3;
    }

    public static final boolean isFreeBSD() {
        return osType == 4;
    }

    public static final boolean isX11() {
        return !Platform.isWindows() && !Platform.isMac();
    }

    static boolean isUbuntu64() {
        return Platform.isLinux() && Platform.is64();
    }

    public static boolean is64() {
        return arch == 64;
    }

    static boolean isUbuntu32() {
        return Platform.isLinux() && !Platform.is64();
    }

    static boolean isWindows64() {
        return Platform.isWindows() && Platform.is64();
    }

    static boolean isWindows32() {
        return Platform.isWindows() && !Platform.is64();
    }

    public static boolean isInDebugMode() {
        if (isInDebugMode != null) {
            return isInDebugMode;
        }
        Platform.readIsInDebugMode();
        return isInDebugMode;
    }

    private static void readIsInDebugMode() {
        try {
            isInDebugMode = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
        }
        catch (Exception e) {
            isInDebugMode = false;
        }
    }

    static {
        String osName = System.getProperty("os.name");
        osType = osName.startsWith("Linux") ? 1 : (osName.startsWith("Mac") || osName.startsWith("Darwin") ? 0 : (osName.startsWith("Windows") ? 2 : (osName.startsWith("Solaris") || osName.startsWith("SunOS") ? 3 : (osName.startsWith("FreeBSD") ? 4 : -1))));
        arch = System.getProperty("os.arch").indexOf("64") != -1 ? 64 : 32;
    }
}

