/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import java.util.function.Consumer;

public class PrintStreamOverriderListener
extends PrintStream {
    private final ByteArrayOutputStream myOut = (ByteArrayOutputStream)this.out;
    private String oldOutput = "";
    private final Consumer<String> printer;

    public PrintStreamOverriderListener(Consumer<String> printer) {
        super(new ByteArrayOutputStream());
        this.printer = printer;
    }

    @Override
    public void flush() {
        super.flush();
        this.onOutput();
    }

    @Override
    public void close() {
        super.close();
        this.onOutput();
    }

    @Override
    public boolean checkError() {
        return super.checkError();
    }

    @Override
    protected void setError() {
        super.setError();
        this.onOutput();
    }

    @Override
    protected void clearError() {
        super.clearError();
        this.onOutput();
    }

    @Override
    public void write(int b) {
        super.write(b);
        this.onOutput();
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        super.write(buf, off, len);
        this.onOutput();
    }

    @Override
    public void write(byte[] buf) throws IOException {
        super.write(buf);
        this.onOutput();
    }

    @Override
    public void writeBytes(byte[] buf) {
        super.writeBytes(buf);
        this.onOutput();
    }

    @Override
    public void print(boolean b) {
        super.print(b);
        this.onOutput();
    }

    @Override
    public void print(char c) {
        super.print(c);
        this.onOutput();
    }

    @Override
    public void print(int i) {
        super.print(i);
        this.onOutput();
    }

    @Override
    public void print(long l) {
        super.print(l);
        this.onOutput();
    }

    @Override
    public void print(float f) {
        super.print(f);
        this.onOutput();
    }

    @Override
    public void print(double d) {
        super.print(d);
        this.onOutput();
    }

    @Override
    public void print(char[] s) {
        super.print(s);
        this.onOutput();
    }

    @Override
    public void print(String s) {
        super.print(s);
        this.onOutput();
    }

    @Override
    public void print(Object obj) {
        super.print(obj);
        this.onOutput();
    }

    @Override
    public void println() {
        super.println();
        this.onOutput();
    }

    @Override
    public void println(boolean x) {
        super.println(x);
        this.onOutput();
    }

    @Override
    public void println(char x) {
        super.println(x);
        this.onOutput();
    }

    @Override
    public void println(int x) {
        super.println(x);
        this.onOutput();
    }

    @Override
    public void println(long x) {
        super.println(x);
        this.onOutput();
    }

    @Override
    public void println(float x) {
        super.println(x);
        this.onOutput();
    }

    @Override
    public void println(double x) {
        super.println(x);
        this.onOutput();
    }

    @Override
    public void println(char[] x) {
        super.println(x);
        this.onOutput();
    }

    @Override
    public void println(String x) {
        super.println(x);
        this.onOutput();
    }

    @Override
    public void println(Object x) {
        super.println(x);
        this.onOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream printf(String format, Object ... args) {
        try {
            PrintStream printStream = super.printf(format, args);
            return printStream;
        }
        finally {
            this.onOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        try {
            PrintStream printStream = super.printf(l, format, args);
            return printStream;
        }
        finally {
            this.onOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream format(String format, Object ... args) {
        try {
            PrintStream printStream = super.format(format, args);
            return printStream;
        }
        finally {
            this.onOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        try {
            PrintStream printStream = super.format(l, format, args);
            return printStream;
        }
        finally {
            this.onOutput();
        }
    }

    @Override
    public PrintStream append(CharSequence csq) {
        return super.append(csq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        try {
            PrintStream printStream = super.append(csq, start, end);
            return printStream;
        }
        finally {
            this.onOutput();
        }
    }

    @Override
    public PrintStream append(char c) {
        try {
            PrintStream printStream = super.append(c);
            return printStream;
        }
        finally {
            this.onOutput();
        }
    }

    private void onOutput() {
        String newOutput = new String(this.myOut.toByteArray());
        if (newOutput.length() > this.oldOutput.length()) {
            String diff = newOutput.substring(this.oldOutput.length());
            this.oldOutput = newOutput;
            this.printer.accept(diff);
        }
    }
}

