/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader;

import com.namasoft.upgrader.FileUtils;
import com.namasoft.upgrader.Platform;
import com.namasoft.upgrader.UIUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ProcessesUtil {
    public static void startService(String service) throws InterruptedException, IOException {
        if (Platform.isWindows()) {
            ProcessesUtil.runProcessToConsole("net", "start", service);
        } else if (Platform.isLinux()) {
            ProcessesUtil.runProcessToConsole("service", service, "start");
        }
    }

    public static void stopServiceAndWaitTilItIsStopped(String serviceName) throws InterruptedException, IOException {
        ProcessesUtil.stopService(serviceName);
        ProcessesUtil.waitTillServiceIsStopped(List.of(serviceName));
    }

    public static void stopService(String serviceName) throws InterruptedException, IOException {
        if (Platform.isWindows()) {
            ProcessesUtil.runProcessToConsole("net", "stop", serviceName);
        } else if (Platform.isLinux()) {
            ProcessesUtil.runProcessToConsole("service", serviceName, "stop");
        }
    }

    public static void waitTillServiceIsStopped(List<String> serviceNames) throws IOException, InterruptedException {
        boolean serviceRunning = false;
        UIUtils.msg("Checking service status");
        int count = 0;
        do {
            ++count;
            serviceRunning = false;
            for (String service : serviceNames) {
                serviceRunning = false;
                ServiceStatus serviceStatus = ProcessesUtil.getServiceStatus(service);
                if (serviceStatus == ServiceStatus.STOPPED) continue;
                serviceRunning = true;
                ProcessesUtil.stopService(service);
                break;
            }
            if (!serviceRunning) continue;
            UIUtils.msg("\rService Still Running - " + count);
            Thread.sleep(2000L);
        } while (serviceRunning && count < 1200);
        if (serviceRunning) {
            UIUtils.prompt("Service is still running, please stop it manually and run upgrade again");
            System.exit(1);
        }
    }

    public static String extractServiceStartName(List<String> output) {
        String serviceStartNameLine = output.stream().filter(line -> line.trim().startsWith("SERVICE_START_NAME")).findFirst().orElse("");
        return ProcessesUtil.substringAfter(serviceStartNameLine, ":").trim();
    }

    public static ServiceStatus getServiceStatus(String tomcat) throws IOException, InterruptedException {
        if (Platform.isWindows()) {
            return ProcessesUtil.parseWindowsStatus(ProcessesUtil.runProcessAndGetOutput("sc", "query", "\"" + tomcat + "\""));
        }
        if (Platform.isLinux()) {
            return ProcessesUtil.parseLinuxStatus(ProcessesUtil.runProcessAndGetOutput("service", tomcat, "status"));
        }
        throw new RuntimeException("Unknown platform");
    }

    private static ServiceStatus parseLinuxStatus(List<String> output) {
        for (String s : output) {
            if (!s.contains("(running)")) continue;
            return ServiceStatus.RUNNING;
        }
        return ServiceStatus.STOPPED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceStatus parseWindowsStatus(List<String> output) {
        for (String s : output) {
            int start;
            if (!s.trim().startsWith("STATE ")) continue;
            for (int i = start = s.indexOf(":") + 1; i < s.length(); ++i) {
                ServiceStatus serviceStatus;
                if (!Character.isDigit(s.charAt(i))) continue;
                int state = Integer.parseInt(String.valueOf(s.charAt(i)));
                switch (state) {
                    case 1: {
                        serviceStatus = ServiceStatus.STOPPED;
                        return serviceStatus;
                    }
                    case 3: {
                        serviceStatus = ServiceStatus.STOP_PENDING;
                        return serviceStatus;
                    }
                    case 2: {
                        serviceStatus = ServiceStatus.START_PENDING;
                        return serviceStatus;
                    }
                    case 4: {
                        serviceStatus = ServiceStatus.RUNNING;
                        return serviceStatus;
                    }
                    default: {
                        serviceStatus = ServiceStatus.UNKNOWN;
                    }
                }
                return serviceStatus;
            }
        }
        return ServiceStatus.UNKNOWN;
    }

    public static ServiceStartupType parseWindowsStartType(List<String> output) {
        for (String s : output) {
            if (!s.trim().startsWith("START_TYPE ")) continue;
            if (s.toLowerCase().contains("disabled")) {
                return ServiceStartupType.DISABLED;
            }
            if (s.toLowerCase().contains("demand_start")) {
                return ServiceStartupType.MANUAL;
            }
            if (s.toLowerCase().contains("auto_start") && s.toLowerCase().contains("delayed")) {
                return ServiceStartupType.AUTO_DELAYED;
            }
            if (!s.toLowerCase().contains("auto_start")) continue;
            return ServiceStartupType.AUTO;
        }
        return ServiceStartupType.UNKNOWN;
    }

    public static int runProcessToConsole(File workingDirectory, String ... cmd) throws IOException, InterruptedException {
        return ProcessesUtil.runProcessToStream(System.out, workingDirectory, cmd);
    }

    public static int runProcessToStream(OutputStream stream, File workingDirectory, String ... cmd) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(cmd).directory(workingDirectory);
        return ProcessesUtil.runProcessToStream(builder, stream, null);
    }

    public static int runProcessToConsole(String ... cmd) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(cmd);
        return ProcessesUtil.runProcessToConsole(builder);
    }

    public static int runProcessToConsole(ProcessBuilder builder) throws IOException, InterruptedException {
        return ProcessesUtil.runProcessToConsole(builder, null);
    }

    public static int runProcessToConsole(ProcessBuilder builder, Consumer<Process> betweenPollsCallback) throws IOException, InterruptedException {
        builder.redirectError(ProcessBuilder.Redirect.PIPE);
        return ProcessesUtil.runProcessToStream(builder, System.out, betweenPollsCallback);
    }

    public static int runProcessToStream(ProcessBuilder builder, OutputStream stream, Consumer<Process> betweenPollsCallback) throws IOException, InterruptedException {
        Process process = builder.start();
        while (process.isAlive()) {
            while (process.isAlive() && process.getInputStream().available() > 0) {
                if (!process.isAlive()) continue;
                stream.write(new byte[]{(byte)process.getInputStream().read()});
            }
            while (process.isAlive() && process.getErrorStream() != null && process.getErrorStream().available() > 0) {
                if (!process.isAlive()) continue;
                stream.write(new byte[]{(byte)process.getErrorStream().read()});
            }
            if (betweenPollsCallback != null) {
                betweenPollsCallback.accept(process);
            }
            Thread.sleep(250L);
        }
        return process.exitValue();
    }

    public static List<String> runProcessAndGetOutput(String ... cmd) throws IOException, InterruptedException {
        return ProcessesUtil.runProcessAndGetOutput(null, cmd);
    }

    public static List<String> runProcessAndGetOutput(File workingDirectory, String ... cmd) throws IOException, InterruptedException {
        return ProcessesUtil.runProcessAndGetOutput(workingDirectory, null, cmd);
    }

    public static List<String> runProcessAndGetOutput(File workingDirectory, Consumer<ProcessBuilder> beforeRun, String ... cmd) throws IOException, InterruptedException {
        return ProcessesUtil.runProcessAndGetOutput_(workingDirectory, beforeRun, cmd).commandOutput();
    }

    public static ProcessOutput runProcessAndGetOutput_(File workingDirectory, Consumer<ProcessBuilder> beforeRun, String ... cmd) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(cmd);
        if (workingDirectory != null) {
            builder.directory(workingDirectory);
        }
        Path tempFile = Files.createTempFile("xx", "yy", new FileAttribute[0]);
        builder.redirectOutput(tempFile.toFile());
        builder.redirectError(tempFile.toFile());
        if (beforeRun != null) {
            beforeRun.accept(builder);
        }
        Process process = builder.start();
        process.waitFor();
        List<String> lines = FileUtils.readFile(tempFile.toFile().getAbsolutePath());
        tempFile.toFile().delete();
        List<String> output = lines.stream().map(s -> s.replace("\u0000", "")).collect(Collectors.toList());
        if ("true".equalsIgnoreCase(System.getProperty("print-process-output"))) {
            System.out.println("---------------");
            if (workingDirectory != null) {
                System.out.println("Working Directory: " + workingDirectory.getAbsolutePath());
            }
            System.out.println(String.join((CharSequence)" ", cmd));
            System.out.println("Exit Code: " + process.exitValue());
            output.forEach(System.out::println);
            System.out.println("---------------");
        }
        return new ProcessOutput(process.exitValue(), output);
    }

    public static String substringAfter(String str, String separator) {
        if (str == null || str.isEmpty() || separator == null || separator.isEmpty()) {
            return str;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static void addFilesToZipFile(File zipFile, File entriesRoot, File ... newEntries) throws IOException {
        ZipEntry entry;
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        boolean renameOk = zipFile.renameTo(tempFile);
        if (!renameOk) {
            throw new RuntimeException("Could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
        while ((entry = zin.getNextEntry()) != null) {
            String name = entry.getName();
            if (!ProcessesUtil.isEntryNotFoundInNewEntries(entriesRoot, name, newEntries)) continue;
            out.putNextEntry(new ZipEntry(name));
            ProcessesUtil.copy(buf, zin, out);
        }
        zin.close();
        for (int i = 0; i < newEntries.length; ++i) {
            File newEntry = newEntries[i];
            FileInputStream in = new FileInputStream(newEntry);
            out.putNextEntry(new ZipEntry(ProcessesUtil.entryName(entriesRoot, newEntry)));
            ProcessesUtil.copy(buf, in, out);
            out.closeEntry();
            ((InputStream)in).close();
        }
        out.close();
        tempFile.delete();
    }

    private static void copy(byte[] buf, InputStream zin, OutputStream out) throws IOException {
        int len;
        while ((len = zin.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    private static boolean isEntryNotFoundInNewEntries(File entriesRoot, String entryName, File[] newEntries) {
        boolean notInFiles = true;
        for (File f : newEntries) {
            if (!ProcessesUtil.entryName(entriesRoot, f).equals(entryName)) continue;
            notInFiles = false;
            break;
        }
        return notInFiles;
    }

    private static String entryName(File entriesRoot, File entry) {
        return entry.getAbsoluteFile().getAbsolutePath().substring(entriesRoot.getAbsoluteFile().getAbsolutePath().length() + 1).replace('\\', '/');
    }

    public static enum ServiceStatus {
        RUNNING,
        STOPPED,
        STOP_PENDING,
        UNKNOWN,
        START_PENDING;

    }

    public static enum ServiceStartupType {
        MANUAL,
        AUTO,
        AUTO_DELAYED,
        DISABLED,
        UNKNOWN;

    }

    public record ProcessOutput(int exitCode, List<String> commandOutput) {
        public boolean isError() {
            return this.exitCode != 0;
        }

        public String output() {
            return String.join((CharSequence)"\n", this.commandOutput);
        }
    }
}

