/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class TomcatLibraries {
    private List<TomcatLib> tomcatLibs;
    private List<TomcatLib> zipFileLibs;

    public LibraryVersion tomcatOldestVersionOf(String libName) {
        return this.oldestVersionOf(this.getTomcatLibs(), libName, false);
    }

    public LibraryVersion tomcatOldestVersion_nameContains(String libName) {
        return this.oldestVersionOf_(this.getTomcatLibs(), libName, false, String::contains);
    }

    public LibraryVersion tomcatOldestVersion_nameStartsWith(String libName) {
        return this.oldestVersionOf_(this.getTomcatLibs(), libName, false, String::startsWith);
    }

    public LibraryVersion zipFileVersionOf(String libName) {
        return this.oldestVersionOf(this.getZipFileLibs(), libName, false);
    }

    private LibraryVersion oldestVersionOf(List<TomcatLib> libs, String libName, boolean exceptionIfMoreThanOneVersionExists) {
        return this.oldestVersionOf_(libs, libName, exceptionIfMoreThanOneVersionExists, String::equals);
    }

    private LibraryVersion oldestVersionOf_(List<TomcatLib> libs, String libName, boolean exceptionIfMoreThanOneVersionExists, BiFunction<String, String, Boolean> comparator) {
        if (libs == null || libs.isEmpty()) {
            return LibraryVersion.empty();
        }
        List lib = libs.stream().filter(l -> l.getName() != null && (Boolean)comparator.apply(l.getName(), libName) != false).collect(Collectors.toList());
        if (lib.isEmpty()) {
            return LibraryVersion.empty();
        }
        if (lib.size() == 1) {
            return ((TomcatLib)lib.get(0)).getVersion();
        }
        if (exceptionIfMoreThanOneVersionExists) {
            throw new RuntimeException(MessageFormat.format("More than one version of the library {0} exist, here they are {1}", libName, lib));
        }
        return LibraryVersion.selectOldest(lib.stream().map(TomcatLib::getVersion).collect(Collectors.toList()));
    }

    public void deleteAllVersionsOfTomcatLibraryIfFound(String libName) {
        this.getTomcatLibs().stream().filter(l -> l.getName() != null && l.getName().equals(libName)).forEach(TomcatLib::delete);
    }

    public void deleteAllVersionsOfTomcatLibraryIfFound_nameContains(String libName) {
        this.getTomcatLibs().stream().filter(l -> l.getName() != null && l.getName().contains(libName)).forEach(TomcatLib::delete);
    }

    public void deleteAllVersionsOfTomcatLibraryIfFound_nameStartsWith(String libName) {
        this.getTomcatLibs().stream().filter(l -> l.getName() != null && l.getName().startsWith(libName)).forEach(TomcatLib::delete);
    }

    public void deleteOldTomcatLibraries() {
        for (TomcatLib lib : this.getTomcatLibs()) {
            if (!this.zipFileVersionOf(lib.getName()).isAfter(lib.getVersion())) continue;
            lib.delete();
        }
    }

    public List<TomcatLib> getTomcatLibs() {
        return this.tomcatLibs;
    }

    public void setTomcatLibs(List<TomcatLib> tomcatLibs) {
        this.tomcatLibs = tomcatLibs;
    }

    public List<TomcatLib> getZipFileLibs() {
        return this.zipFileLibs;
    }

    public void setZipFileLibs(List<TomcatLib> zipFileLibs) {
        this.zipFileLibs = zipFileLibs;
    }

    public void initTomcatLibraries(String tomcatFolder) {
        File libFolder = new File(new File(tomcatFolder), "lib");
        this.tomcatLibs = Arrays.stream(libFolder.listFiles()).filter(file -> file.getName().toLowerCase().endsWith(".jar")).map(TomcatLibraries::toLib).collect(Collectors.toList());
    }

    public void initZipFileLibraries(String zipFilePath) throws IOException {
        ZipEntry ze;
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFilePath));
        this.zipFileLibs = new ArrayList<TomcatLib>();
        while ((ze = zis.getNextEntry()) != null) {
            if (!ze.getName().toLowerCase().endsWith(".jar")) continue;
            this.zipFileLibs.add(TomcatLibraries.toLib(ze));
        }
        zis.closeEntry();
        zis.close();
    }

    private static TomcatLib toLib(File file) {
        TomcatLib lib = new TomcatLib();
        lib.setFullPath(file.getAbsolutePath());
        TomcatLibraries.fileToLib(file, lib);
        return lib;
    }

    private static TomcatLib toLib(ZipEntry entry) {
        File file = new File(entry.getName());
        TomcatLib lib = new TomcatLib();
        lib.setFullPath("zip://" + entry.getName());
        TomcatLibraries.fileToLib(file, lib);
        return lib;
    }

    private static void fileToLib(File file, TomcatLib lib) {
        lib.setFileName(file.getName());
        int versionSeparator = lib.getFileName().lastIndexOf("-");
        if (versionSeparator >= 0) {
            lib.setName(lib.getFileName().substring(0, versionSeparator));
            lib.setVersion(LibraryVersion.create(file, lib.getFileName().substring(versionSeparator + 1, lib.getFileName().length() - 4)));
        }
    }

    public static void main(String[] args) throws IOException {
        TomcatLibraries libraries = new TomcatLibraries();
        libraries.initTomcatLibraries("C:\\Program Files\\Apache Software Foundation\\Tomcat 9.0");
        libraries.initZipFileLibraries("C:\\Users\\Ahmed\\Downloads\\extras.zip");
        libraries.zipFileLibs.forEach(System.out::println);
        libraries.tomcatLibs.forEach(System.out::println);
    }

    public static class LibraryVersion {
        private String version;
        private final File file;

        public static LibraryVersion empty() {
            return new LibraryVersion(null);
        }

        public LibraryVersion(File file) {
            this(file, "");
        }

        public LibraryVersion(File file, String version) {
            this.version = version;
            this.file = file;
        }

        public static LibraryVersion create(File file, String version) {
            return new LibraryVersion(file, version);
        }

        public static LibraryVersion selectOldest(List<LibraryVersion> versions) {
            LibraryVersion oldest = null;
            for (LibraryVersion version : versions) {
                if (oldest != null && !version.isBefore(oldest.version)) continue;
                oldest = version;
            }
            return oldest;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public int compareTo(String other) {
            if (this.getVersion() == null || this.version.isEmpty()) {
                if (other == null || other.isEmpty()) {
                    return 0;
                }
                return -1;
            }
            if (other == null || other.isEmpty()) {
                return 1;
            }
            String[] otherParts = other.split("\\.");
            String[] myParts = this.getVersion().split("\\.");
            for (int i = 0; i < myParts.length && i < otherParts.length; ++i) {
                String mv = myParts[i];
                String ov = otherParts[i];
                int compare = this.tryParseInt(mv) != null && this.tryParseInt(ov) != null ? this.tryParseInt(mv).compareTo(this.tryParseInt(ov)) : mv.compareTo(ov);
                if (compare == 0) continue;
                return compare;
            }
            return Integer.compare(myParts.length, otherParts.length);
        }

        private Integer tryParseInt(String v) {
            try {
                return Integer.parseInt(v);
            }
            catch (Exception e) {
                return null;
            }
        }

        public boolean isBefore(String version) {
            return this.compareTo(version) < 0;
        }

        public boolean isAfter(LibraryVersion version) {
            String str = "";
            if (version != null) {
                str = version.getVersion();
            }
            return this.isAfter(str);
        }

        public boolean isAfter(String version) {
            return this.compareTo(version) > 0;
        }

        public boolean isSameAs(String version) {
            return this.compareTo(version) == 0;
        }

        public boolean isEmpty() {
            return this.version == null || this.version.isEmpty();
        }

        public boolean exists() {
            return !this.isEmpty();
        }

        public String toString() {
            return this.getVersion();
        }

        public long fileSize() {
            return this.file == null ? 0L : this.file.length();
        }
    }

    public static class TomcatLib {
        private String name;
        private String fullPath;
        private String fileName;
        private LibraryVersion version;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public LibraryVersion getVersion() {
            return this.version;
        }

        public void setVersion(LibraryVersion version) {
            this.version = version;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public void setFullPath(String fullPath) {
            this.fullPath = fullPath;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String toString() {
            return this.getFullPath() + ": " + this.getName() + "," + String.valueOf(this.getVersion());
        }

        public boolean delete() {
            return new File(this.getFullPath()).delete();
        }
    }
}

