/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader;

import com.namasoft.upgrader.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public class UIUtils {
    private static BufferedReader in;
    private static boolean htmlMode;
    private static Boolean isJavaw;

    public static String prompt(String msg) {
        return UIUtils.prompt(msg, null);
    }

    public static String prompt(String msg, String defaultValue) {
        if (UIUtils.isJavaw()) {
            return JOptionPane.showInputDialog(msg);
        }
        UIUtils.init();
        if (defaultValue != null) {
            UIUtils.msg(msg + " - press enter for default value: " + defaultValue);
        } else {
            UIUtils.msg(msg);
        }
        try {
            String s = in.readLine();
            if (defaultValue != null && s.trim().isEmpty()) {
                return defaultValue;
            }
            return s;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isJavaw() {
        if (isJavaw != null) {
            return isJavaw;
        }
        try {
            System.in.available();
            isJavaw = false;
            return isJavaw;
        }
        catch (IOException e) {
            isJavaw = true;
            return isJavaw;
        }
    }

    private static void init() {
        if (in == null) {
            in = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static boolean isAdmin() {
        if (Platform.isInDebugMode()) {
            return true;
        }
        Preferences prefs = Preferences.systemRoot();
        try {
            prefs.put("foo", "bar");
            prefs.remove("foo");
            prefs.flush();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void msg(String msg) {
        if (msg.startsWith("\r") && !msg.startsWith("\r\n")) {
            System.out.print(msg);
        } else if (htmlMode) {
            System.out.println("<br/>" + msg);
        } else {
            System.out.println(msg);
        }
        System.out.flush();
    }

    public static void activateHTMLMode() {
        htmlMode = true;
    }

    public static boolean isHtmlMode() {
        return htmlMode;
    }

    public static void error(Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        UIUtils.msg(writer.getBuffer().toString());
    }

    static {
        isJavaw = null;
    }
}

