/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader;

import com.namasoft.pos.upgrader.POSUpgrader;
import com.namasoft.printserve.upgrader.InstallerUpgrader;
import com.namasoft.printserve.upgrader.PrintServer;
import com.namasoft.upgrader.AttendanceCronUpgrader;
import com.namasoft.upgrader.CloudManUpgrader;
import com.namasoft.upgrader.ConsoleProgressHandler;
import com.namasoft.upgrader.CryptoUtils;
import com.namasoft.upgrader.FileConsoleProgressHandler;
import com.namasoft.upgrader.FileDownloader;
import com.namasoft.upgrader.FileUtils;
import com.namasoft.upgrader.KitchenAppUpgrader;
import com.namasoft.upgrader.Platform;
import com.namasoft.upgrader.ProcessesUtil;
import com.namasoft.upgrader.ProgressHandler;
import com.namasoft.upgrader.TomcatLibraries;
import com.namasoft.upgrader.UIUtils;
import com.namasoft.upgrader.UpgLcMngr;
import com.namasoft.upgrader.ZatcaUpgrader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Upgrader {
    public static final String UPGRADER_OUTPUT_FILE_NAME = "upgrader-output.txt";
    private static final String UPGRADER_VERSION = "master-java-21-v3";
    private String[] args;
    private String tomcatFolder;
    private Boolean outputToFile;
    private PrintStream out;
    private PrintStream oldOut;

    public Upgrader(String[] args) {
        this.args = args;
    }

    public static File calcTomcatExeFile(String tomcatPath) {
        return new File(tomcatPath, "bin/" + Upgrader.calcTomcatServiceNameFromPath(tomcatPath) + ".exe");
    }

    public static void main(String[] args) throws Exception {
        if (Upgrader.isPOSUpgrader()) {
            POSUpgrader.upgrade(args);
            return;
        }
        if (Upgrader.isAttCron()) {
            AttendanceCronUpgrader.start(args);
            return;
        }
        if (Upgrader.isZatca()) {
            ZatcaUpgrader.start(args);
            return;
        }
        if (Upgrader.isKitchenApp()) {
            KitchenAppUpgrader.start(args);
            return;
        }
        if (Upgrader.isCloudMan()) {
            CloudManUpgrader.start(args);
            return;
        }
        if (Upgrader.isPrintServer()) {
            PrintServer.start(args);
            return;
        }
        if (Upgrader.isInstaller()) {
            InstallerUpgrader.start(args);
            return;
        }
        try {
            Upgrader upgrader = new Upgrader(args);
            upgrader.overrideSystemOutIfNeeded();
            String upgraderTomcatFolder = upgrader.getTomcatFolder();
            Upgrader.runAsAdminIfNeeded(upgraderTomcatFolder);
            upgrader.upgrade(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter(out));
            UIUtils.prompt("Exception happended:" + out.toString());
        }
    }

    public static void runAsAdminIfNeeded(String upgraderTomcatFolder) throws IOException, InterruptedException {
        if (!UIUtils.isAdmin() || UIUtils.isJavaw()) {
            Path elevatedRunner = Paths.get("run-nama-upgraded-elevated.js", new String[0]);
            if (!FileUtils.testWrite(elevatedRunner)) {
                elevatedRunner = new File(new File(System.getProperty("user.home")), "run-nama-upgraded-elevated.js").toPath();
            }
            Files.write(elevatedRunner, Upgrader.createElevatedRunnerScript(upgraderTomcatFolder), new OpenOption[0]);
            if (Platform.isWindows()) {
                ProcessesUtil.runProcessToConsole(new File(upgraderTomcatFolder), "cmd", "/c", "start", "cscript", elevatedRunner.toFile().getAbsolutePath());
            } else {
                UIUtils.msg("Admin not handled in linux systems");
            }
            System.exit(0);
        }
    }

    private void overrideSystemOutIfNeeded() throws FileNotFoundException {
        Path upgraderOutput = this.calcUpgraderOutputFile().toPath();
        if (this.isOutputToFile()) {
            this.oldOut = System.out;
            this.out = new PrintStream(new FileOutputStream(upgraderOutput.toFile()));
            System.setOut(this.out);
        }
    }

    private boolean isOutputToFile() {
        if (this.outputToFile != null) {
            return this.outputToFile;
        }
        this.outputToFile = "true".equalsIgnoreCase(System.getProperty("outputtofile")) && FileUtils.testWrite(this.calcUpgraderOutputFile().toPath());
        return this.outputToFile;
    }

    private File calcUpgraderOutputFile() {
        return new File(new File(this.getTomcatFolder()), UPGRADER_OUTPUT_FILE_NAME);
    }

    private static List<String> createElevatedRunnerScript(String tomcatFolder) {
        String s = MessageFormat.format("new ActiveXObject(\"Shell.Application\").ShellExecute(\"cmd\", \"/c java \\\"-Duser.dir={0}\\\" \\\"-Doutputtofile={3}\\\" -jar \\\"{1}\\\" \\\"{2}\\\"\", \"\", \"runas\");", Upgrader.escapePath(Upgrader.fetchCurrentDir()), Upgrader.escapePath(Upgrader.fetchJarPath()), Upgrader.escapePath(tomcatFolder), System.getProperty("outputtofile"));
        return Arrays.asList(s);
    }

    private void checkIfCustomerNameIsDefined(String tomcatFolder) throws IOException {
        String customer = Upgrader.getCustomerName(tomcatFolder);
        if (customer == null || customer.isEmpty()) {
            UIUtils.prompt("Please define customer name in nama.properties (customer=xyz)");
            System.exit(1);
        }
    }

    private static String getCustomerName(String tomcatFolder) throws IOException {
        Properties namaProperties = Upgrader.loadNamaPropertiesFromTomcat(tomcatFolder);
        return namaProperties.getProperty("customer");
    }

    private static String getSubRelease(String tomcatFolder) throws IOException {
        Properties namaProperties = Upgrader.loadNamaPropertiesFromTomcat(tomcatFolder);
        String subRelease = namaProperties.getProperty("sub-release", "");
        if (subRelease.equalsIgnoreCase("gui3") || subRelease.equalsIgnoreCase("zatca2") || subRelease.equalsIgnoreCase("new-zatca-jakarta")) {
            return "";
        }
        return subRelease;
    }

    private static boolean shouldUseNamasoftNotCRM(String tomcatFolder) throws IOException {
        Properties namaProperties = Upgrader.loadNamaPropertiesFromTomcat(tomcatFolder);
        return namaProperties.getProperty("use-namasoft-for-nlm") != null && "true".equalsIgnoreCase(namaProperties.getProperty("use-namasoft-for-nlm"));
    }

    private static String getSubserver(String tomcatFolder) throws IOException {
        Properties namaProperties = Upgrader.loadNamaPropertiesFromTomcat(tomcatFolder);
        return namaProperties.getProperty("subserver");
    }

    private static Properties loadNamaPropertiesFromTomcat(String tomcatFolder) throws IOException {
        Properties namaProperties = new Properties();
        FileInputStream propertiesStream = new FileInputStream(new File(new File(tomcatFolder), "lib/nama.properties"));
        namaProperties.load(propertiesStream);
        propertiesStream.close();
        return namaProperties;
    }

    private static String escapePath(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("/", "\\\\");
    }

    private static String fetchJarPath() {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        return new File(classPath).getAbsolutePath();
    }

    private static String fetchCurrentDir() {
        return new File(".").getAbsolutePath();
    }

    public void upgrade(String[] args) throws Exception {
        String cleanTemp;
        String subRelease;
        boolean handleExtrasOnly;
        this.args = args;
        this.getTomcatFolder();
        this.checkIfCustomerNameIsDefined(this.tomcatFolder);
        if (Upgrader.shouldUseNamasoftNotCRM(this.tomcatFolder)) {
            System.setProperty("use-namasoft-com-not-crm", "true");
        }
        List<String> tomcatServiceNames = Upgrader.getTomcatServiceNames(this.tomcatFolder);
        boolean isOffline = this.isOffline();
        Path releaseFolder = Files.createTempDirectory("namarelease", new FileAttribute[0]);
        Path extrasFile = null;
        ProgressHandler progressHandler = new ConsoleProgressHandler(true);
        if (this.isOutputToFile()) {
            progressHandler = new FileConsoleProgressHandler(false);
        }
        boolean bl = handleExtrasOnly = "true".equalsIgnoreCase(System.getProperty("handle-extras-only")) || ManagementFactory.getRuntimeMXBean().getClassPath().toLowerCase().contains("extras-only");
        if (!handleExtrasOnly) {
            this.checkForLicenceAndRequestNewIfNeeded(this.tomcatFolder);
        }
        TomcatLibraries libraries = new TomcatLibraries();
        libraries.initTomcatLibraries(this.tomcatFolder);
        if (libraries.tomcatOldestVersionOf("mssql-jdbc").isBefore("11.2") || libraries.tomcatOldestVersion_nameContains("log4jdbc").exists()) {
            try {
                Upgrader.fixContextXmlIfNeeded(this.tomcatFolder);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Object subReleasePath = (subRelease = Upgrader.getSubRelease(this.tomcatFolder)).isEmpty() ? "" : "/sub-releases/" + subRelease;
        Upgrader.deleteDeprecatedLibsFromTomcat(libraries);
        if (this.checkIfShouldUpdateExtras(libraries)) {
            extrasFile = Upgrader.downloadExtrasFile(releaseFolder, isOffline, (String)subReleasePath, progressHandler);
        }
        if (handleExtrasOnly) {
            Upgrader.handleExtrasFile(this.tomcatFolder, extrasFile);
            System.out.println("Exiting because handle-extras-only was specified");
            return;
        }
        Path releaseFile = Files.createTempFile(releaseFolder, "nama", "release", new FileAttribute[0]);
        String url = UpgLcMngr.fetchNlmServer() + "/nlm/download.php?rel=current&st=" + this.getServerToken() + "&subr=" + subRelease + "&upgversion=master-java-21-v3";
        if (isOffline) {
            Files.copy(new File(UIUtils.prompt("Please Specify Release file path\n" + url)).toPath(), releaseFile, StandardCopyOption.REPLACE_EXISTING);
        } else {
            FileDownloader.downloadLarge(url, progressHandler, releaseFile.toFile());
        }
        boolean hasPOS = false;
        try (Iterator<String> scanner = new Scanner(new URL("https://namasoft.com/nlm/cmods?haspos=" + Upgrader.getCustomerName(this.tomcatFolder)).openStream(), "UTF-8").useDelimiter("\\A");){
            if (((Scanner)scanner).hasNext()) {
                hasPOS = "true".equals(((Scanner)scanner).next().trim());
            }
        }
        if (releaseFile.toFile().length() <= 0x100000L) {
            UIUtils.msg("");
            UIUtils.msg("Could not download release for customer " + Upgrader.getCustomerName(this.tomcatFolder));
            Files.readAllLines(releaseFile).forEach(UIUtils::msg);
            if (!this.isOutputToFile()) {
                UIUtils.msg("Press enter key to exit");
                System.in.read();
            }
            System.exit(1);
        }
        FileUtils.unZipIt(releaseFile.toFile(), releaseFolder.toFile());
        for (String tomcat : tomcatServiceNames) {
            ProcessesUtil.stopService(tomcat);
        }
        ProcessesUtil.waitTillServiceIsStopped(tomcatServiceNames);
        Upgrader.deleteDeprecatedLibsFromTomcat(libraries);
        Upgrader.handleExtrasFile(this.tomcatFolder, extrasFile);
        File tomcatERPWarFile = new File(new File(this.getTomcatFolder()), "webapps/erp.war");
        File posZipFile = new File(new File(this.getTomcatFolder()), "webapps/ROOT/pos.zip");
        File newPosZipFile = new File(new File(this.getTomcatFolder()), "webapps/ROOT/newpos.zip");
        File tomcatBasicServicesWarFile = new File(new File(this.getTomcatFolder()), "webapps/basic-services.war");
        File oldReleasesFolder = new File(this.getTomcatFolder(), "Old-Releases");
        File oldReleaseFolder = new File(oldReleasesFolder, "Old-Release-" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        try {
            if (tomcatBasicServicesWarFile.exists() && tomcatERPWarFile.exists()) {
                UIUtils.msg("Copying old release to the folder " + oldReleaseFolder.getAbsolutePath());
                oldReleaseFolder.mkdirs();
                FileUtils.copy(tomcatBasicServicesWarFile.toPath(), new File(oldReleaseFolder, tomcatBasicServicesWarFile.getName()).toPath());
                FileUtils.copy(tomcatERPWarFile.toPath(), new File(oldReleaseFolder, tomcatERPWarFile.getName()).toPath());
                if (posZipFile.exists()) {
                    FileUtils.copy(posZipFile.toPath(), new File(oldReleaseFolder, posZipFile.getName()).toPath());
                }
                if (newPosZipFile.exists()) {
                    FileUtils.copy(newPosZipFile.toPath(), new File(oldReleaseFolder, newPosZipFile.getName()).toPath());
                }
            }
        }
        catch (Exception e) {
            UIUtils.msg("Could not copy old release to the folder " + oldReleaseFolder.getAbsolutePath());
            UIUtils.error(e);
        }
        this.runExtractors(new File(releaseFolder.toFile(), "wars"), "extractAll.bat", "extras.bat");
        FileUtils.copy(new File(releaseFolder.toFile(), "wars/erp.war").toPath(), tomcatERPWarFile.toPath());
        FileUtils.copy(new File(releaseFolder.toFile(), "wars/basic-services.war").toPath(), tomcatBasicServicesWarFile.toPath());
        FileUtils.deleteDir(new File(new File(this.getTomcatFolder()), "webapps/erp"));
        FileUtils.deleteDir(new File(new File(this.getTomcatFolder()), "webapps/basic-services"));
        FileUtils.deleteDir(new File(new File(this.getTomcatFolder()), "webapps/erp5"));
        new File(new File(this.getTomcatFolder()), "webapps/erp5.war").delete();
        for (String tomcat : tomcatServiceNames) {
            ProcessesUtil.startService(tomcat);
        }
        FileUtils.deleteDir(releaseFolder.toFile());
        if (extrasFile != null) {
            extrasFile.toFile().delete();
        }
        if ((cleanTemp = "yes") != null && cleanTemp.toLowerCase().contains("y")) {
            FileUtils.deleteDir(new File(new File(this.getTomcatFolder()), "temp"), true);
        }
        while (this.makeSureTomcatIsRunningBeforeExit(tomcatServiceNames)) {
        }
        if (hasPOS) {
            String latestVersion = new Scanner(new URL(UpgLcMngr.fetchNlmServer() + "/nlm/download.php?releasename=get&subr=" + subRelease).openStream(), "UTF-8").useDelimiter("\\A").next();
            FileDownloader.downloadLarge("https://namasoft.com" + (String)subReleasePath + "/bin/pos/pos" + latestVersion + ".zip", progressHandler, posZipFile);
            FileDownloader.downloadLarge("https://namasoft.com/bin/newpos/pos.zip", progressHandler, newPosZipFile);
        }
        if (this.oldOut != null) {
            System.setOut(this.oldOut);
        }
        if (this.out != null) {
            this.out.close();
        }
        this.calcUpgraderOutputFile().delete();
    }

    private static void fixContextXmlIfNeeded(String tomcatFolder) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        File file = new File(new File(tomcatFolder), "conf/context.xml");
        Document doc = Upgrader.loadXmlFile(file);
        NodeList resources = doc.getElementsByTagName("Resource");
        for (int i = 0; i < resources.getLength(); ++i) {
            Node item = resources.item(i);
            if (!"jdbc/nama".equals(item.getAttributes().getNamedItem("name").getNodeValue())) continue;
            Node url = item.getAttributes().getNamedItem("url");
            Object value = url.getNodeValue();
            if (!((String)value).trim().endsWith(";")) {
                value = (String)value + ";";
            }
            if (!((String)value).toLowerCase().contains("encrypt=true;")) {
                value = (String)value + "encrypt=true;";
            }
            if (!((String)value).toLowerCase().contains("trustservercertificate=true;")) {
                value = (String)value + "trustServerCertificate=true;";
            }
            if (((String)value).contains("log4jdbc:")) {
                value = ((String)value).replace("log4jdbc:", "");
            }
            url.setNodeValue((String)value);
            Node driver = item.getAttributes().getNamedItem("driverClassName");
            driver.setNodeValue("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        }
        Upgrader.saveXmlFile(doc, file);
    }

    public static Document loadXmlFile(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(file);
        doc.getDocumentElement().normalize();
        return doc;
    }

    public static void saveXmlFile(Document doc, File file) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
    }

    private static Path downloadExtrasFile(Path releaseFolder, boolean isOffline, String subReleasePath, ProgressHandler progressHandler) throws IOException, InterruptedException {
        UIUtils.msg("Found Old Dependency Version, downloading new version");
        Path extrasFile = Files.createTempFile(releaseFolder, "nama", "extras", new FileAttribute[0]);
        String url = "https://namasoft.com" + subReleasePath + "/bin/extras/extras.zip";
        if (isOffline) {
            Files.copy(new File(UIUtils.prompt("Please Specify Extras file path\n" + url)).toPath(), extrasFile, StandardCopyOption.REPLACE_EXISTING);
        } else {
            FileDownloader.downloadLarge(url, progressHandler, extrasFile.toFile());
        }
        return extrasFile;
    }

    public static void migrateExtrasAndContextForTomcat10(String tomcatFolder) throws Exception {
        String subRelease = Upgrader.getSubRelease(tomcatFolder);
        Object subReleasePath = subRelease.isEmpty() ? "" : "/sub-releases/" + subRelease;
        Path releaseFolder = Files.createTempDirectory("namarelease", new FileAttribute[0]);
        Path extrasFile = Upgrader.downloadExtrasFile(releaseFolder, false, (String)subReleasePath, new ConsoleProgressHandler(true));
        Upgrader.handleExtrasFile(tomcatFolder, extrasFile);
        Upgrader.fixContextXmlIfNeeded(tomcatFolder);
    }

    private static void handleExtrasFile(String tomcatFolder, Path extrasFile) throws IOException {
        if (extrasFile != null) {
            FileUtils.unZipIt(extrasFile.toFile(), tomcatFolder, "extras/tomcat-server/", "extras/dev-deps", "extras/tomcat-server/conf");
            TomcatLibraries libraries = new TomcatLibraries();
            libraries.initTomcatLibraries(tomcatFolder);
            libraries.initZipFileLibraries(extrasFile.toFile().getAbsolutePath());
            libraries.deleteOldTomcatLibraries();
            libraries.deleteAllVersionsOfTomcatLibraryIfFound("sqljdbc");
            libraries.deleteAllVersionsOfTomcatLibraryIfFound_nameStartsWith("log4jdbc");
            libraries.deleteAllVersionsOfTomcatLibraryIfFound("log4j");
        }
    }

    private String getServerToken() {
        return new UpgLcMngr(this.tomcatFolder).getServerToken();
    }

    private void checkForLicenceAndRequestNewIfNeeded(String tomcatFolder) throws IOException, InterruptedException {
        UpgLcMngr manager = new UpgLcMngr(tomcatFolder);
        if (manager.invalid()) {
            if (manager.noLicence()) {
                if (UIUtils.isHtmlMode()) {
                    UIUtils.msg("There is no licence defined for this server, please upgrade using the upgrader jar manually");
                    System.exit(1);
                } else {
                    String fetchedKey;
                    String keyId;
                    String subServer = Upgrader.getSubserver(this.getTomcatFolder());
                    String customerName = Upgrader.getCustomerName(this.getTomcatFolder());
                    String key = UIUtils.prompt("There is no licence defined, if you have a key please type it here, otherwise press enter and the system will try to request a licence automatically");
                    if (CryptoUtils.isNotEmptyOrNull(key)) {
                        String validationResult = UpgLcMngr.checkKey(key);
                        if (!"valid".equalsIgnoreCase(validationResult)) {
                            UIUtils.prompt("Key invalid - Reason: " + validationResult);
                            System.exit(-1);
                            return;
                        }
                        UpgLcMngr.installKey(tomcatFolder, key);
                        return;
                    }
                    UIUtils.msg("The system will try to request a licence for the customer " + Upgrader.getCustomerName(tomcatFolder));
                    String customerSubServers = UpgLcMngr.fetchSubServers(customerName);
                    if (CryptoUtils.isEmptyOrNull(subServer) && CryptoUtils.isNotEmptyOrNull(customerSubServers)) {
                        List<String> subServers = Arrays.asList(customerSubServers.split(","));
                        int count = 0;
                        do {
                            ++count;
                            subServer = UIUtils.prompt("Type the sub server id, it has to be one of the following: " + customerSubServers);
                            if (CryptoUtils.isEmptyOrNull(subServer)) {
                                UIUtils.msg("You must specify a subserver");
                                continue;
                            }
                            if (subServers.contains(subServer.trim())) continue;
                            UIUtils.msg("The sub server " + subServer + " is not a valid sub server for the customer " + customerName);
                            subServer = "";
                        } while (CryptoUtils.isEmptyOrNull(subServer.trim()) && count < 3);
                        if (CryptoUtils.isEmptyOrNull(subServer)) {
                            UIUtils.msg("The system requested that you provide a valid sub server for THREE times and you are ignoring that request, please contact technical support");
                            System.exit(-1);
                        }
                    }
                    if ((keyId = UpgLcMngr.requestKey(customerName, subServer, "upgrader")).contains(" ")) {
                        UIUtils.prompt("Could not request a key, reason: " + keyId);
                        System.exit(-1);
                        return;
                    }
                    int trials = 1;
                    do {
                        StringBuilder dots = new StringBuilder();
                        for (int i = 0; i < trials % 10; ++i) {
                            dots.append(".");
                        }
                        UIUtils.msg("\rWaiting for the key request to be approved" + String.valueOf(dots));
                        Thread.sleep(5000L);
                        fetchedKey = UpgLcMngr.tryFetchKey(keyId);
                        ++trials;
                    } while (CryptoUtils.isEmptyOrNull(fetchedKey));
                    UIUtils.msg("");
                    if (fetchedKey.contains(" ")) {
                        UIUtils.prompt("Could not obtain key, reason: " + fetchedKey);
                        System.exit(-1);
                        return;
                    }
                    UpgLcMngr.installKey(tomcatFolder, fetchedKey);
                }
            } else {
                UIUtils.prompt("Invalid Licence - Can not Upgrade - Reason: " + manager.invalidReason());
                System.exit(1);
            }
        }
    }

    private boolean makeSureTomcatIsRunningBeforeExit(List<String> tomcatServiceNames) throws IOException, InterruptedException {
        boolean anyNotRunning = false;
        for (String tomcat : tomcatServiceNames) {
            UIUtils.msg("Ensuring that service " + tomcat + " is running");
            ProcessesUtil.ServiceStatus serviceStatus = ProcessesUtil.getServiceStatus(tomcat);
            if (serviceStatus != ProcessesUtil.ServiceStatus.RUNNING) {
                UIUtils.msg("The service " + tomcat + " is not running, trying to start it again");
                anyNotRunning = true;
                Thread.sleep(2000L);
                ProcessesUtil.startService(tomcat);
                continue;
            }
            UIUtils.msg("Service " + tomcat + " is running, nothing to do");
        }
        return anyNotRunning;
    }

    private boolean checkIfShouldUpdateExtras(TomcatLibraries libraries) {
        if (libraries.tomcatOldestVersionOf("mssql-jdbc").isBefore("11.2")) {
            UIUtils.msg("mssql-jdbc is old");
            return true;
        }
        if (libraries.tomcatOldestVersionOf("protobuf-java").isBefore("4.29")) {
            UIUtils.msg("protobuf-java is old");
            return true;
        }
        if (libraries.tomcatOldestVersionOf("p6spy").isBefore("3.9.1")) {
            UIUtils.msg("P6Spy missing");
            return true;
        }
        if (libraries.tomcatOldestVersion_nameStartsWith("slf4j-api").isBefore("2")) {
            UIUtils.msg("sl4j exists, should be deleted");
            return true;
        }
        if (libraries.tomcatOldestVersion_nameStartsWith("log4jdbc").exists()) {
            UIUtils.msg("log4jdb exists, should be deleted");
            return true;
        }
        if (libraries.tomcatOldestVersion_nameStartsWith("mysql-connector-java").exists()) {
            UIUtils.msg("mysql-connector-java exists, should be deleted");
            return true;
        }
        if (libraries.tomcatOldestVersion_nameStartsWith("nama-event-bus").fileSize() <= 15288L) {
            UIUtils.msg("nama-event-bus is old, should be updated");
            return true;
        }
        return false;
    }

    private static void deleteDeprecatedLibsFromTomcat(TomcatLibraries libraries) {
        if (libraries.tomcatOldestVersionOf("sqljdbc").isSameAs("4.0")) {
            UIUtils.msg("sql-jdbc version 4.0 exists, deleting it");
            libraries.deleteAllVersionsOfTomcatLibraryIfFound("sqljdbc");
        }
        if (libraries.tomcatOldestVersionOf("mysql-connector-java").exists()) {
            UIUtils.msg("mysql-connector-java exists, deleting it");
            libraries.deleteAllVersionsOfTomcatLibraryIfFound("mysql-connector-java");
        }
        List<String> toDeletePrefixes = Arrays.asList("ant", "itext", "avalon", "groovy", "barbecue", "barcode4j", "batik", "commons", "core", "curvesapi", "jackson-dataformat", "jasperreports", "jcommander", "jcommon", "jfreechart", "jline", "jquery", "junit", "openpdf", "opentest", "picocli", "poi", "qdox", "stax2", "testng", "woodstox", "xml-apis", "xmlbeans", "xmlgraphics", "slf4j-log4j12", "jackson-databind", "jackson-core", "jackson-annotations");
        for (String libPrefix : toDeletePrefixes) {
            if (!libraries.tomcatOldestVersion_nameStartsWith(libPrefix).exists()) continue;
            UIUtils.msg(libPrefix + " exists, deleting it");
            libraries.deleteAllVersionsOfTomcatLibraryIfFound_nameStartsWith(libPrefix);
        }
    }

    private void runExtractors(File warsFolder, String ... batFiles) throws IOException {
        HashMap<String, List> fileNewEntries = new HashMap<String, List>();
        for (String batFile : batFiles) {
            File file = new File(warsFolder, batFile);
            if (!file.exists()) {
                UIUtils.msg("Could not find file " + String.valueOf(file.getAbsoluteFile()));
                continue;
            }
            List lines = Files.lines(file.toPath()).collect(Collectors.toList());
            for (String line : lines) {
                if (line == null || line.trim().isEmpty() || !line.startsWith("jar -uf ")) continue;
                line = line.substring("jar -uf ".length());
                ArrayList<String> parts = new ArrayList<String>(Arrays.asList(line.split(" ")));
                for (int i = parts.size() - 1; i >= 0; --i) {
                    String part = (String)parts.get(i);
                    if (part == null || part.trim().isEmpty()) {
                        parts.remove(i);
                        continue;
                    }
                    if ((part = part.trim()).startsWith("\"")) {
                        part = part.substring(1);
                        parts.set(i, part);
                    }
                    if (!part.endsWith("\"")) continue;
                    part = part.substring(0, part.length() - 1);
                    parts.set(i, part);
                }
                String warFileToAddTo = (String)parts.remove(0);
                fileNewEntries.computeIfAbsent(warFileToAddTo, k -> new ArrayList()).addAll(parts);
            }
        }
        for (Map.Entry entry : fileNewEntries.entrySet()) {
            entry.setValue(new ArrayList(new HashSet((Collection)entry.getValue())));
            File[] newEntries = (File[])((List)entry.getValue()).stream().map(s -> new File(warsFolder, (String)s)).toArray(File[]::new);
            ProcessesUtil.addFilesToZipFile(new File(warsFolder, (String)entry.getKey()), warsFolder, newEntries);
        }
    }

    private static boolean isAttCron() {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        return classPath.toLowerCase().contains("cron");
    }

    private static boolean isZatca() {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        return classPath.toLowerCase().contains("zatca");
    }

    private static boolean isKitchenApp() {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        return classPath.toLowerCase().contains("kitchen");
    }

    private static boolean isCloudMan() {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        return classPath.toLowerCase().contains("cloudman");
    }

    public static boolean isPOSUpgrader() {
        if ("pos".equals(System.getProperty("upgrader-type"))) {
            return true;
        }
        if ("tomcat10".equals(System.getProperty("upgrader-type"))) {
            return false;
        }
        if ("nama".equals(System.getProperty("upgrader-type"))) {
            return false;
        }
        if ("printing-server".equals(System.getProperty("upgrader-type"))) {
            return false;
        }
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        return classPath.toLowerCase().contains("pos");
    }

    public static boolean isPrintServer() {
        if ("printing-server".equals(System.getProperty("upgrader-type"))) {
            return true;
        }
        if ("tomcat10".equals(System.getProperty("upgrader-type"))) {
            return false;
        }
        if ("pos".equals(System.getProperty("upgrader-type"))) {
            return false;
        }
        if ("nama".equals(System.getProperty("upgrader-type"))) {
            return false;
        }
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        return classPath.toLowerCase().contains("print");
    }

    public static boolean isInstaller() {
        if ("installer".equals(System.getProperty("upgrader-type"))) {
            return true;
        }
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        return classPath.toLowerCase().contains("installer");
    }

    private boolean isOffline() {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        if (classPath.toLowerCase().contains("offline")) {
            return true;
        }
        if (classPath.toLowerCase().contains("online")) {
            return false;
        }
        return !this.isNamasoftReachable();
    }

    private boolean isNamasoftReachable() {
        try {
            InetAddress address = InetAddress.getByName("namasoft.com");
            if (address.isReachable(5000)) {
                return true;
            }
            System.err.println("namasoft.com not reachable, you will have to provide locally downloaded files");
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<String> getTomcatServiceNames(String tomcatFolder) throws IOException, InterruptedException {
        Properties namaProperties;
        String definedTomcat;
        if (!Platform.isWindows() && (definedTomcat = (namaProperties = Upgrader.loadNamaPropertiesFromTomcat(tomcatFolder)).getProperty("tomcatservice")) != null && !definedTomcat.isEmpty()) {
            return Arrays.asList(definedTomcat);
        }
        String definedTomcat2 = Upgrader.calcTomcatServiceNameFromPath(tomcatFolder);
        if (!definedTomcat2.isEmpty()) {
            return List.of(definedTomcat2);
        }
        return Upgrader.getAvailableTomcatServices();
    }

    public static String calcTomcatServiceNameFromPath(String tomcatPath) {
        File bin;
        File[] binFiles;
        File current = new File(tomcatPath).getAbsoluteFile();
        if (current.getName().equals("bin")) {
            current = current.getParentFile();
        }
        if ((binFiles = (bin = new File(current, "bin")).listFiles()) == null) {
            return "";
        }
        File tomcatServiceExe = Arrays.stream(binFiles).filter(f -> f.getName().toLowerCase().endsWith(".exe")).filter(f -> !f.getName().toLowerCase().endsWith("w.exe")).findFirst().orElse(null);
        if (tomcatServiceExe == null) {
            return "";
        }
        return tomcatServiceExe.getName().substring(0, tomcatServiceExe.getName().length() - ".exe".length());
    }

    public static List<String> getAvailableTomcatServices() throws IOException, InterruptedException {
        List<String> lines = ProcessesUtil.runProcessAndGetOutput("sc", "queryex", "type=", "service", "state=", "all");
        ArrayList<String> services = new ArrayList<String>();
        for (String line : lines) {
            String substring;
            if (!line.startsWith("SERVICE_NAME: ") || !(substring = line.substring("SERVICE_NAME: ".length())).toLowerCase().contains("tomcat")) continue;
            services.add(substring);
        }
        return services;
    }

    private String getTomcatFolder() {
        if (this.tomcatFolder != null) {
            return this.tomcatFolder;
        }
        if (this.args.length > 0 && this.args[0] != null && !this.args[0].isEmpty()) {
            this.tomcatFolder = this.args[0];
        }
        if (this.tomcatFolder == null && new File("./conf").exists() && new File("./lib").exists() && new File("./webapps").exists()) {
            this.tomcatFolder = new File(new File("./webapps").getParent()).getAbsolutePath();
        }
        if (this.tomcatFolder == null) {
            this.tomcatFolder = UIUtils.prompt("Please specify tomcat folder:");
        }
        return this.tomcatFolder;
    }

    public static class CloudManMain {
        public static void main(String[] args) throws IOException, InterruptedException {
            CloudManUpgrader.start(args);
        }
    }

    public static class AttCronMain {
        public static void main(String[] args) throws IOException, InterruptedException {
            AttendanceCronUpgrader.start(args);
        }
    }

    public static class InstallerMain {
        public static void main(String[] args) throws IOException, InterruptedException {
            InstallerUpgrader.start(args);
        }
    }

    public static class PrintingServerMain {
        public static void main(String[] args) throws IOException, InterruptedException {
            PrintServer.start(args);
        }
    }
}

