/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader.migrator;

import com.namasoft.upgrader.ConsoleProgressHandler;
import com.namasoft.upgrader.FileDownloader;
import com.namasoft.upgrader.ProcessesUtil;
import com.namasoft.upgrader.UIUtils;
import com.namasoft.upgrader.Upgrader;
import com.namasoft.upgrader.migrator.TomcatExeArgsParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class Tomcat10Migrator {
    public static void migrate(String tomcat9Path, String tomcat10Path) {
        if (!Tomcat10Migrator.validateTomcatPaths(tomcat9Path, tomcat10Path)) {
            return;
        }
        File source = new File(tomcat9Path);
        File target = new File(tomcat10Path);
        try {
            UIUtils.msg("Stopping tomcat 9");
            Tomcat10Migrator.stopTomcat(source);
            Tomcat10Migrator.stopTomcat(target);
            Tomcat10Migrator.copyAndThenDeleteSource(source, target, "conf/context.xml");
            Tomcat10Migrator.copyAndThenDeleteSource(source, target, "lib/nc.jars");
            Tomcat10Migrator.copyAndThenDeleteSource(source, target, "lib/nama.properties");
            UIUtils.msg("Making tomcat 9 manual");
            Tomcat10Migrator.makeTomcat9Manual(source);
            Upgrader.migrateExtrasAndContextForTomcat10(tomcat10Path);
            Tomcat10Migrator.addSpringInstrumentAsJavaAgentToTomcatJvmOptions9IfNeeded(target);
            if (!UIUtils.isJavaw()) {
                String[] args = new String[]{tomcat10Path};
                Upgrader upgrader = new Upgrader(args);
                upgrader.upgrade(args);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void addSpringInstrumentAsJavaAgentToTomcatJvmOptions9IfNeeded(File target) throws IOException, InterruptedException {
        File instrumentJar = Tomcat10Migrator.downloadSpringInstrumentIfNeeded(target);
        TomcatExeArgsParser args = TomcatExeArgsParser.fetchAndParse(target.getAbsolutePath());
        if (!args.getJvmOptions9().contains("-javaagent")) {
            Tomcat10Migrator.addJavaAgentToTomcat(target.getAbsolutePath(), instrumentJar);
        }
    }

    public static int addJavaAgentToTomcat(String tomcatPath, File instrumentJar) throws IOException, InterruptedException {
        return ProcessesUtil.runProcessToConsole(Upgrader.calcTomcatExeFile(tomcatPath).getAbsolutePath(), "//US", "++JvmOptions9", "\"-javaagent:" + instrumentJar.getAbsolutePath() + "\"");
    }

    public static int addXXOmitStackTraceInFastThrow(String tomcatPath) throws IOException, InterruptedException {
        return ProcessesUtil.runProcessToConsole(Upgrader.calcTomcatExeFile(tomcatPath).getAbsolutePath(), "//US", "++JvmOptions", "\"-XX:-OmitStackTraceInFastThrow\"");
    }

    public static int addUserLanguageUS(String tomcatPath) throws IOException, InterruptedException {
        return ProcessesUtil.runProcessToConsole(Upgrader.calcTomcatExeFile(tomcatPath).getAbsolutePath(), "//US", "++JvmOptions", "\"-Duser.language=en-US\"");
    }

    public static File downloadSpringInstrumentIfNeeded(File saveInPath) throws IOException, InterruptedException {
        String springVersion = "6.1.10";
        File springInstrument = new File(saveInPath.getParent(), "spring-instrument-" + springVersion + ".jar");
        if (!springInstrument.exists()) {
            FileDownloader.downloadLarge("https://repo.maven.apache.org/maven2/org/springframework/spring-instrument/" + springVersion + "/spring-instrument-" + springVersion + ".jar", new ConsoleProgressHandler(true), springInstrument);
        }
        return springInstrument;
    }

    private static void stopTomcat(File tomcatPath) throws IOException, InterruptedException {
        ProcessesUtil.stopServiceAndWaitTilItIsStopped(Upgrader.calcTomcatServiceNameFromPath(tomcatPath.getAbsolutePath()));
    }

    private static void makeTomcat9Manual(File tomcat9Path) throws IOException, InterruptedException {
        File tomcatExe = Upgrader.calcTomcatExeFile(tomcat9Path.getAbsolutePath());
        ProcessesUtil.runProcessToConsole(tomcatExe.getAbsolutePath(), "update", "--Startup", "manual");
    }

    private static void copyAndThenDeleteSource(File source, File target, String file) throws IOException {
        File sourceFile = new File(source, file);
        Files.copy(sourceFile.toPath(), new File(target, file).toPath(), StandardCopyOption.REPLACE_EXISTING);
        Files.deleteIfExists(sourceFile.toPath());
    }

    private static boolean validateTomcatPaths(String tomcat9Path, String tomcat10Path) {
        return Tomcat10Migrator.validateTomcatPath(new File(tomcat9Path)) && Tomcat10Migrator.validateTomcatPath(new File(tomcat10Path));
    }

    public static boolean validateTomcatPath(File tomcatDir) {
        File[] files = tomcatDir.listFiles((dir, name) -> dir == tomcatDir && (name.equals("lib") || name.equals("conf") || name.equals("webapps")));
        if (files == null) {
            return false;
        }
        return files.length == 3;
    }
}

