/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.type.format.FormatMapper;
import org.hibernate.type.format.FormatMapperCreationContext;
import org.hibernate.type.format.jackson.JacksonJsonFormatMapper;
import org.hibernate.type.format.jackson.JacksonXmlFormatMapper;

public final class JacksonIntegration {
    private static final boolean JACKSON_XML_AVAILABLE = JacksonIntegration.ableToLoadJacksonXMLMapper();
    private static final boolean JACKSON_JSON_AVAILABLE = JacksonIntegration.ableToLoadJacksonJSONMapper();

    private JacksonIntegration() {
    }

    private static boolean ableToLoadJacksonJSONMapper() {
        return JacksonIntegration.canLoad("com.fasterxml.jackson.databind.ObjectMapper");
    }

    private static boolean ableToLoadJacksonXMLMapper() {
        return JacksonIntegration.canLoad("com.fasterxml.jackson.dataformat.xml.XmlMapper");
    }

    public static @Nullable FormatMapper getXMLJacksonFormatMapperOrNull(FormatMapperCreationContext creationContext) {
        return JACKSON_XML_AVAILABLE ? new JacksonXmlFormatMapper(creationContext) : null;
    }

    public static @Nullable FormatMapper getJsonJacksonFormatMapperOrNull(FormatMapperCreationContext creationContext) {
        return JACKSON_JSON_AVAILABLE ? new JacksonJsonFormatMapper(creationContext) : null;
    }

    public static @Nullable FormatMapper getJsonJacksonFormatMapperOrNull() {
        return JACKSON_JSON_AVAILABLE ? new JacksonJsonFormatMapper() : null;
    }

    private static boolean canLoad(String name) {
        try {
            JacksonIntegration.class.getClassLoader().loadClass(name);
            return true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            return false;
        }
    }

    static List<Module> loadModules(FormatMapperCreationContext creationContext) {
        ClassLoader classLoader = JacksonIntegration.class.getClassLoader();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null && classLoader != contextClassLoader) {
            try {
                if (ObjectMapper.class == contextClassLoader.loadClass("com.fasterxml.jackson.databind.ObjectMapper")) {
                    return creationContext.getBootstrapContext().getServiceRegistry().requireService(ClassLoaderService.class).workWithClassLoader(ObjectMapper::findModules);
                }
            }
            catch (ClassNotFoundException | LinkageError throwable) {
                // empty catch block
            }
        }
        return ObjectMapper.findModules((ClassLoader)classLoader);
    }
}

