/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.krysalis.barcode4j.BarcodeClassResolver;
import org.krysalis.barcode4j.BarcodeException;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.DefaultBarcodeClassResolver;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.w3c.dom.DocumentFragment;

public class BarcodeUtil {
    private BarcodeClassResolver classResolver = new DefaultBarcodeClassResolver();

    private BarcodeUtil() {
    }

    public static BarcodeUtil getInstance() {
        return ThreadsafeLazySingleton.INSTANCE;
    }

    public BarcodeClassResolver getClassResolver() {
        return this.classResolver;
    }

    public static BarcodeGenerator createBarcodeGenerator(Configuration cfg, BarcodeClassResolver classResolver) throws BarcodeException, ConfigurationException {
        Class cl = null;
        try {
            String type = cfg.getName();
            try {
                cl = classResolver.resolve(type);
            }
            catch (ClassNotFoundException cnfe) {
                cl = null;
            }
            Configuration child = null;
            if (cl == null) {
                Configuration[] children = cfg.getChildren();
                if (children.length == 0) {
                    throw new BarcodeException("Barcode configuration element expected");
                }
                for (int i = 0; i < children.length; ++i) {
                    child = children[i];
                    type = child.getName();
                    try {
                        cl = classResolver.resolve(type);
                        break;
                    }
                    catch (ClassNotFoundException cnfe) {
                        cl = null;
                        continue;
                    }
                }
            }
            if (cl == null) {
                throw new BarcodeException("No known barcode configuration element found");
            }
            BarcodeGenerator gen = (BarcodeGenerator)cl.newInstance();
            try {
                ContainerUtil.configure((Object)gen, (Configuration)(child != null ? child : cfg));
            }
            catch (IllegalArgumentException iae) {
                throw new ConfigurationException("Cannot configure barcode generator", (Throwable)iae);
            }
            try {
                ContainerUtil.initialize((Object)gen);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot initialize barcode generator. " + e.getMessage());
            }
            return gen;
        }
        catch (IllegalAccessException ia) {
            throw new RuntimeException("Problem while instantiating a barcode generator: " + ia.getMessage(), ia);
        }
        catch (InstantiationException ie) {
            throw new BarcodeException("Error instantiating a barcode generator: " + cl != null ? cl.getName() : "class not resolved", ie);
        }
    }

    public BarcodeGenerator createBarcodeGenerator(Configuration cfg) throws ConfigurationException, BarcodeException {
        return BarcodeUtil.createBarcodeGenerator(cfg, this.classResolver);
    }

    public DocumentFragment generateSVGBarcode(Configuration cfg, String msg) throws ConfigurationException, BarcodeException {
        BarcodeGenerator gen = this.createBarcodeGenerator(cfg);
        SVGCanvasProvider svg = new SVGCanvasProvider(false, 0);
        gen.generateBarcode(svg, msg);
        return svg.getDOMFragment();
    }

    private static class ThreadsafeLazySingleton {
        private static final BarcodeUtil INSTANCE = new BarcodeUtil();

        private ThreadsafeLazySingleton() {
        }
    }
}

