/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.krysalis.barcode4j.BarcodeClassResolver;
import org.krysalis.barcode4j.tools.ZXingUtil;

public class DefaultBarcodeClassResolver
implements BarcodeClassResolver {
    private Map<String, String> classes;
    private Set<String> mainIDs;

    public DefaultBarcodeClassResolver() {
        this.registerBarcodeClass("codabar", "org.krysalis.barcode4j.impl.codabar.Codabar", true);
        this.registerBarcodeClass("code39", "org.krysalis.barcode4j.impl.code39.Code39", true);
        this.registerBarcodeClass("code128", "org.krysalis.barcode4j.impl.code128.Code128", true);
        this.registerBarcodeClass("ean-128", "org.krysalis.barcode4j.impl.code128.EAN128", true);
        this.registerBarcodeClass("ean128", "org.krysalis.barcode4j.impl.code128.EAN128");
        this.registerBarcodeClass("2of5", "org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5");
        this.registerBarcodeClass("intl2of5", "org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5", true);
        this.registerBarcodeClass("interleaved2of5", "org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5");
        this.registerBarcodeClass("itf-14", "org.krysalis.barcode4j.impl.int2of5.ITF14", true);
        this.registerBarcodeClass("itf14", "org.krysalis.barcode4j.impl.int2of5.ITF14");
        this.registerBarcodeClass("ean-13", "org.krysalis.barcode4j.impl.upcean.EAN13", true);
        this.registerBarcodeClass("ean13", "org.krysalis.barcode4j.impl.upcean.EAN13");
        this.registerBarcodeClass("ean-8", "org.krysalis.barcode4j.impl.upcean.EAN8", true);
        this.registerBarcodeClass("ean8", "org.krysalis.barcode4j.impl.upcean.EAN8");
        this.registerBarcodeClass("upc-a", "org.krysalis.barcode4j.impl.upcean.UPCA", true);
        this.registerBarcodeClass("upca", "org.krysalis.barcode4j.impl.upcean.UPCA");
        this.registerBarcodeClass("upc-e", "org.krysalis.barcode4j.impl.upcean.UPCE", true);
        this.registerBarcodeClass("upce", "org.krysalis.barcode4j.impl.upcean.UPCE");
        this.registerBarcodeClass("postnet", "org.krysalis.barcode4j.impl.postnet.POSTNET", true);
        this.registerBarcodeClass("royal-mail-cbc", "org.krysalis.barcode4j.impl.fourstate.RoyalMailCBC", true);
        this.registerBarcodeClass("usps4cb", "org.krysalis.barcode4j.impl.fourstate.USPSIntelligentMail", true);
        this.registerBarcodeClass("pdf417", "org.krysalis.barcode4j.impl.pdf417.PDF417", true);
        this.registerBarcodeClass("datamatrix", "org.krysalis.barcode4j.impl.datamatrix.DataMatrix", true);
        if (ZXingUtil.isZxingAvailable()) {
            String clazz = "org.krysalis.barcode4j.impl.qr.QRCode";
            this.registerBarcodeClass("qr", "org.krysalis.barcode4j.impl.qr.QRCode", true);
            this.registerBarcodeClass("qrcode", "org.krysalis.barcode4j.impl.qr.QRCode");
            this.registerBarcodeClass("qr-code", "org.krysalis.barcode4j.impl.qr.QRCode");
        }
    }

    public void registerBarcodeClass(String id, String classname) {
        this.registerBarcodeClass(id, classname, false);
    }

    public void registerBarcodeClass(String id, String classname, boolean mainID) {
        if (this.classes == null) {
            this.classes = new HashMap<String, String>();
            this.mainIDs = new HashSet<String>();
        }
        this.classes.put(id.toLowerCase(), classname);
        if (mainID) {
            this.mainIDs.add(id);
        }
    }

    @Override
    public Class resolve(String name) throws ClassNotFoundException {
        String clazz = null;
        if (this.classes != null) {
            clazz = this.classes.get(name.toLowerCase());
        }
        if (clazz == null) {
            clazz = name;
        }
        return Class.forName(clazz);
    }

    @Override
    public Class resolveBean(String name) throws ClassNotFoundException {
        String clazz = null;
        if (this.classes != null) {
            clazz = this.classes.get(name.toLowerCase());
        }
        if (clazz == null) {
            clazz = name;
        }
        return Class.forName(clazz + "Bean");
    }

    @Override
    public Collection<String> getBarcodeNames() {
        return Collections.unmodifiableCollection(this.mainIDs);
    }
}

