/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.TextAlignment;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.DrawingUtil;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.tools.MessagePatternUtil;

public class DefaultCanvasLogicHandler
implements ClassicBarcodeLogicHandler {
    protected AbstractBarcodeBean bcBean;
    protected Canvas canvas;
    protected BarcodeDimension dimensions;
    private double x = 0.0;
    private double y;
    private String formattedMsg;

    public DefaultCanvasLogicHandler(AbstractBarcodeBean bcBean, Canvas canvas) {
        this.bcBean = bcBean;
        this.canvas = canvas;
    }

    protected double getStartX() {
        if (this.bcBean.hasQuietZone()) {
            return this.bcBean.getQuietZone();
        }
        return 0.0;
    }

    protected double getStartY() {
        double y = 0.0;
        if (this.bcBean.hasQuietZone()) {
            y += this.bcBean.getVerticalQuietZone();
        }
        if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
            y += this.bcBean.getHumanReadableHeight();
        }
        return y;
    }

    @Override
    public void startBarcode(String msg, String formattedMsg) {
        this.formattedMsg = MessagePatternUtil.applyCustomMessagePattern(formattedMsg, this.bcBean.getPattern());
        this.dimensions = this.bcBean.calcDimensions(msg);
        this.canvas.establishDimensions(this.dimensions);
        this.x = this.getStartX();
        this.y = this.getStartY();
    }

    @Override
    public void startBarGroup(BarGroup type, String submsg) {
    }

    @Override
    public void addBar(boolean black, int width) {
        double w = this.bcBean.getBarWidth(width);
        if (black) {
            this.canvas.drawRectWH(this.x, this.y, w, this.bcBean.getBarHeight());
        }
        this.x += w;
    }

    @Override
    public void endBarGroup() {
    }

    @Override
    public void endBarcode() {
        if (this.bcBean.getMsgPosition() != HumanReadablePlacement.HRP_NONE) {
            double ty = this.getTextBaselinePosition();
            DrawingUtil.drawText(this.canvas, this.bcBean, this.formattedMsg, this.getStartX(), this.x, ty, TextAlignment.TA_CENTER);
        }
    }

    protected double getTextBaselinePosition() {
        if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_TOP) {
            double ty = this.bcBean.getHumanReadableHeight();
            if (this.bcBean.hasFontDescender()) {
                ty -= this.bcBean.getHumanReadableHeight() / 13.0 * 3.0;
            }
            return ty;
        }
        if (this.bcBean.getMsgPosition() == HumanReadablePlacement.HRP_BOTTOM) {
            double ty = this.bcBean.getHeight();
            if (this.bcBean.hasFontDescender()) {
                ty -= this.bcBean.getHumanReadableHeight() / 13.0 * 3.0;
            }
            return ty;
        }
        throw new IllegalStateException("not applicable");
    }
}

