/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.code128;

import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.DefaultCanvasLogicHandler;
import org.krysalis.barcode4j.impl.code128.Code128LogicImpl;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;

public class Code128Bean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = (double)0.21f;
    protected static final int DEFAULT_CODESET = 7;
    private int codeset = 7;

    public Code128Bean() {
        this.moduleWidth = 0.21f;
        this.setQuietZone(10.0 * this.moduleWidth);
        this.setVerticalQuietZone(0.0);
    }

    public void setCodeset(int codeset) {
        if (codeset == 0) {
            throw new IllegalArgumentException("At least one codeset must be allowed");
        }
        this.codeset = codeset;
    }

    public int getCodeset() {
        return this.codeset;
    }

    @Override
    protected boolean hasFontDescender() {
        return true;
    }

    @Override
    public double getBarWidth(int width) {
        if (width >= 1 && width <= 4) {
            return (double)width * this.moduleWidth;
        }
        throw new IllegalArgumentException("Only widths 1 and 2 allowed");
    }

    @Override
    public BarcodeDimension calcDimensions(String msg) {
        Code128LogicImpl impl = this.createLogicImpl();
        int msgLen = 0;
        msgLen = impl.createEncodedMessage(msg).length + 1;
        double width = (double)(msgLen * 11 + 13) * this.getModuleWidth();
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        double vqz = this.hasQuietZone() ? this.quietZoneVertical : 0.0;
        return new BarcodeDimension(width, this.getHeight(), width + 2.0 * qz, this.getHeight() + 2.0 * vqz, qz, vqz);
    }

    private Code128LogicImpl createLogicImpl() {
        return new Code128LogicImpl(this.getCodeset());
    }

    @Override
    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler handler = new DefaultCanvasLogicHandler(this, new Canvas(canvas));
        Code128LogicImpl impl = this.createLogicImpl();
        impl.generateBarcodeLogic(handler, msg);
    }
}

