/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.code128;

import org.krysalis.barcode4j.impl.code128.Code128Constants;
import org.krysalis.barcode4j.impl.code128.Code128Encoder;

public class DefaultCode128Encoder
implements Code128Encoder,
Code128Constants {
    private static final int START_A = 103;
    private static final int START_B = 104;
    private static final int START_C = 105;
    private static final int GOTO_A = 101;
    private static final int GOTO_B = 100;
    private static final int GOTO_C = 99;
    private static final int FNC_1 = 102;
    private static final int FNC_2 = 97;
    private static final int FNC_3 = 96;
    private static final int FNC_4 = 244;
    private static final int SHIFT = 98;
    private int codesets;

    public DefaultCode128Encoder(int codesets) {
        this.codesets = codesets;
    }

    public DefaultCode128Encoder() {
        this(7);
    }

    private boolean needA(char c) {
        return c < ' ';
    }

    private boolean needB(char c) {
        return c >= '`' && c < '\u0080';
    }

    private int encodeAorB(char c, int codeset) {
        if (c == '\u00f1') {
            return 102;
        }
        if (c == '\u00f2') {
            return 97;
        }
        if (c == '\u00f3') {
            return 96;
        }
        if (c == '\u00f4') {
            if (codeset == 1) {
                return 101;
            }
            return 100;
        }
        if (codeset == 1) {
            if (c >= '\u0000' && c < ' ') {
                return c + 64;
            }
            if (c >= ' ' && c <= '_') {
                return c - 32;
            }
            throw new IllegalArgumentException("Illegal character: " + c);
        }
        if (codeset == 2) {
            if (c >= ' ' && c < '\u0080') {
                return c - 32;
            }
            throw new IllegalArgumentException("Illegal character: " + c);
        }
        throw new IllegalArgumentException("Only A or B allowed");
    }

    private boolean isAllowed(int codeset) {
        return (this.codesets & codeset) != 0;
    }

    private boolean isAAllowed() {
        return this.isAllowed(1);
    }

    private boolean isBAllowed() {
        return this.isAllowed(2);
    }

    private boolean isCAllowed() {
        return this.isAllowed(4);
    }

    @Override
    public int[] encode(String message) {
        int countC;
        int[] encoded = new int[message.length() * 2];
        int encodedPos = 0;
        int startAorBPos = 0;
        int messageLength = message.length();
        for (int messagePos = 0; messagePos < messageLength; messagePos += countC + 1) {
            int fnc1Pos;
            countC = 0;
            int saveChar = 0;
            boolean extraDigitAtEnd = false;
            while (this.isCAllowed() && messagePos + countC < messageLength) {
                char character = message.charAt(messagePos + countC);
                if (character >= '0' && character <= '9') {
                    if (messagePos + countC + 1 == messageLength) {
                        extraDigitAtEnd = true;
                        break;
                    }
                    character = message.charAt(messagePos + countC + 1);
                    if (character < '0' || character > '9') break;
                    ++saveChar;
                    countC += 2;
                    continue;
                }
                if (character != '\u00f1' || messagePos != 0 && countC <= 0) break;
                ++countC;
            }
            if (saveChar < 2 && countC != messageLength) continue;
            if (extraDigitAtEnd && ((fnc1Pos = message.indexOf(241, messagePos)) < 0 || fnc1Pos > messagePos + countC)) {
                ++messagePos;
            }
            encodedPos += this.encodeAordB(message, startAorBPos, messagePos, encoded, encodedPos);
            startAorBPos = messagePos + countC;
            encodedPos += this.encodeC(message, messagePos, startAorBPos, encoded, encodedPos);
        }
        encodedPos += this.encodeAordB(message, startAorBPos, messageLength, encoded, encodedPos);
        int[] result = new int[encodedPos];
        System.arraycopy(encoded, 0, result, 0, result.length);
        return result;
    }

    private int encodeC(String message, int start, int finish, int[] encoded, int startEncodedPos) {
        if (start == finish) {
            return 0;
        }
        int encodedPos = startEncodedPos;
        encoded[encodedPos++] = start == 0 ? 105 : 99;
        int messagePos = start;
        while (messagePos < finish) {
            char character = message.charAt(messagePos);
            if (character == '\u00f1') {
                encoded[encodedPos++] = 102;
                ++messagePos;
                continue;
            }
            encoded[encodedPos++] = Character.digit(character, 10) * 10 + Character.digit(message.charAt(messagePos + 1), 10);
            messagePos += 2;
        }
        return encodedPos - startEncodedPos;
    }

    private int encodeAordB(String message, int start, int finish, int[] encoded, int startEncodedPos) {
        char character;
        int messagePos;
        if (start == finish) {
            return 0;
        }
        int encodedPos = startEncodedPos;
        boolean aUsed = false;
        boolean bUsed = false;
        boolean inB = false;
        if (this.isBAllowed()) {
            inB = true;
            for (messagePos = start; messagePos < finish; ++messagePos) {
                character = message.charAt(messagePos);
                if (this.needA(character)) {
                    inB = false;
                } else {
                    if (!this.needB(character)) continue;
                    inB = true;
                }
                break;
            }
        } else if (!this.isAAllowed()) {
            if (finish - start == 1) {
                throw new IllegalArgumentException("The message has an odd number of digits. The number of digits must be even for Codeset C.");
            }
            throw new IllegalArgumentException("Invalid characters found for Code 128 Codeset A or B which are disabled.");
        }
        if (inB) {
            encoded[encodedPos++] = start == 0 ? 104 : 100;
            bUsed = true;
        } else {
            encoded[encodedPos++] = start == 0 ? 103 : 101;
            aUsed = true;
        }
        for (messagePos = start; messagePos < finish; ++messagePos) {
            character = message.charAt(messagePos);
            if (inB) {
                if (this.needA(character)) {
                    if (messagePos + 1 < finish && this.needA(message.charAt(messagePos + 1))) {
                        encoded[encodedPos++] = 101;
                        inB = false;
                    } else {
                        encoded[encodedPos++] = 98;
                    }
                    aUsed = true;
                    encoded[encodedPos++] = this.encodeAorB(character, 1);
                    continue;
                }
                encoded[encodedPos++] = this.encodeAorB(character, 2);
                continue;
            }
            if (this.needB(character)) {
                if (messagePos + 1 < finish && this.needB(message.charAt(messagePos + 1))) {
                    encoded[encodedPos++] = 100;
                    inB = true;
                } else {
                    encoded[encodedPos++] = 98;
                }
                bUsed = true;
                encoded[encodedPos++] = this.encodeAorB(character, 2);
                continue;
            }
            encoded[encodedPos++] = this.encodeAorB(character, 1);
        }
        if (aUsed && !this.isAAllowed()) {
            throw new IllegalArgumentException("Invalid characters found for Code 128 Codeset A which is disabled.");
        }
        if (bUsed && !this.isBAllowed()) {
            throw new IllegalArgumentException("Invalid characters found for Code 128 Codeset B which is disabled.");
        }
        return encodedPos - startEncodedPos;
    }
}

