/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.fourstate;

import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.fourstate.AbstractRMCBCKIXLogicImpl;

public class RoyalMailCBCLogicImpl
extends AbstractRMCBCKIXLogicImpl {
    public RoyalMailCBCLogicImpl(ChecksumMode mode) {
        super(mode);
    }

    @Override
    public char calcChecksum(String msg) {
        String[] codewords = this.encodeHighLevel(RoyalMailCBCLogicImpl.removeStartStop(msg));
        int[] multiplier = new int[]{4, 2, 1, 0};
        int upperSum = 0;
        int lowerSum = 0;
        for (int i = 0; i < codewords.length; ++i) {
            int upper = 0;
            int lower = 0;
            for (int j = 0; j < 4; ++j) {
                int v = codewords[i].charAt(j) - 48;
                upper += (v & 1) * multiplier[j];
                lower += ((v & 2) >> 1) * multiplier[j];
            }
            upperSum += upper % 6;
            lowerSum += lower % 6;
        }
        int row = upperSum % 6;
        row = row == 0 ? 5 : --row;
        int col = lowerSum % 6;
        col = col == 0 ? 5 : --col;
        int idx = row * 6 + col;
        if (idx < 10) {
            return (char)(48 + idx);
        }
        return (char)(65 + idx - 10);
    }

    protected String handleChecksum(String msg) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD || this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return msg + this.calcChecksum(msg);
        }
        if (this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            if (!this.validateChecksum(msg)) {
                throw new IllegalArgumentException("Message '" + msg + "' has a bad checksum. Expected: " + this.calcChecksum(msg.substring(0, msg.length() - 1)));
            }
            return msg;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
            return msg;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + this.getChecksumMode());
    }

    public static String removeStartStop(String msg) {
        StringBuffer sb = new StringBuffer(msg.length());
        int c = msg.length();
        block3: for (int i = 0; i < c; ++i) {
            char ch = msg.charAt(i);
            switch (ch) {
                case '(': 
                case ')': 
                case '[': 
                case ']': {
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String normalizeMessage(String msg) {
        String s = RoyalMailCBCLogicImpl.removeStartStop(msg);
        s = this.handleChecksum(s);
        return "(" + s + ")";
    }
}

