/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.qr;

import com.google.zxing.WriterException;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.awt.Dimension;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.DefaultTwoDimCanvasLogicHandler;
import org.krysalis.barcode4j.impl.qr.QRLogicImpl;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.tools.ECIUtil;
import org.krysalis.barcode4j.tools.UnitConv;

public class QRCodeBean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = UnitConv.in2mm(0.013888888888888888);
    private char errorCorrectionLevel = (char)76;
    private String encoding = "ISO-8859-1";
    private Dimension minSize;
    private Dimension maxSize;

    public QRCodeBean() {
        this.height = 0.0;
        this.moduleWidth = DEFAULT_MODULE_WIDTH;
        this.setQuietZone(4.0 * this.moduleWidth);
    }

    public void setErrorCorrectionLevel(char level) {
        switch (level) {
            case 'H': 
            case 'L': 
            case 'M': 
            case 'Q': {
                this.errorCorrectionLevel = level;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid error correction level. Valid levels are: L, M, Q and H");
            }
        }
    }

    public char getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public void setEncoding(String encoding) {
        if (ECIUtil.getECIForEncoding(encoding) < 0) {
            throw new IllegalArgumentException("Not a valid encoding: " + encoding);
        }
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setMinSize(Dimension minSize) {
        this.minSize = minSize != null ? new Dimension(minSize) : null;
    }

    public Dimension getMinSize() {
        if (this.minSize != null) {
            return new Dimension(this.minSize);
        }
        return null;
    }

    public void setMaxSize(Dimension maxSize) {
        this.maxSize = maxSize != null ? new Dimension(maxSize) : null;
    }

    public Dimension getMaxSize() {
        if (this.maxSize != null) {
            return new Dimension(this.maxSize);
        }
        return null;
    }

    @Override
    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultTwoDimCanvasLogicHandler handler = new DefaultTwoDimCanvasLogicHandler(this, new Canvas(canvas));
        QRLogicImpl impl = new QRLogicImpl();
        impl.generateBarcodeLogic(handler, msg, this.encoding, this.errorCorrectionLevel, this.getMinSize(), this.getMaxSize());
    }

    @Override
    public BarcodeDimension calcDimensions(String msg) {
        QRCode code;
        try {
            code = Encoder.encode((String)msg, (ErrorCorrectionLevel)QRLogicImpl.getZXingErrorLevel(this.errorCorrectionLevel), QRLogicImpl.createHints(this.encoding));
        }
        catch (WriterException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        ByteMatrix matrix = code.getMatrix();
        int effWidth = matrix.getWidth();
        int effHeight = matrix.getHeight();
        this.checkSizeConstraints(effWidth, effHeight);
        double width = (double)effWidth * this.getModuleWidth();
        double height = (double)effHeight * this.getBarHeight();
        double qzh = this.hasQuietZone() ? this.getQuietZone() : 0.0;
        double qzv = this.hasQuietZone() ? this.getVerticalQuietZone() : 0.0;
        return new BarcodeDimension(width, height, width + 2.0 * qzh, height + 2.0 * qzv, qzh, qzv);
    }

    private void checkSizeConstraints(int width, int height) {
        if (this.minSize != null && (width < this.minSize.width || height < this.minSize.height)) {
            throw new IllegalArgumentException("The given message would result in a smaller symbol than required. Requested minimum: " + this.minSize.width + " x " + this.minSize.height + ", effective: " + width + " x " + height);
        }
        if (this.maxSize != null && (width > this.maxSize.width || height > this.maxSize.height)) {
            throw new IllegalArgumentException("The given message would result in a larger symbol than required. Requested maximum: " + this.maxSize.width + " x " + this.maxSize.height + ", effective: " + width + " x " + height);
        }
    }

    @Override
    public double getVerticalQuietZone() {
        return this.getQuietZone();
    }

    @Override
    public double getBarWidth(int width) {
        return this.moduleWidth;
    }

    @Override
    public double getBarHeight() {
        return this.moduleWidth;
    }
}

