/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.File;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRClassGenerator;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRMultiClassCompiler;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.util.JRLoader;

public abstract class JRAbstractClassCompiler
extends JRAbstractJavaCompiler
implements JRMultiClassCompiler {
    protected JRAbstractClassCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        File[] sources = new File[units.length];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = units[i].getSourceFile();
        }
        File[] classFiles = new File[units.length];
        for (int i = 0; i < classFiles.length; ++i) {
            classFiles[i] = new File(tempDirFile, units[i].getCompileName() + ".class");
        }
        try {
            String errors = this.compileClasses(sources, classpath);
            if (errors == null) {
                for (int i = 0; i < units.length; ++i) {
                    byte[] classBytes = JRLoader.loadBytes(classFiles[i]);
                    units[i].setCompileData((Serializable)classBytes);
                }
            }
            String string = errors;
            return string;
        }
        finally {
            for (int i = 0; i < classFiles.length; ++i) {
                if (!classFiles[i].exists()) continue;
                classFiles[i].delete();
            }
        }
    }

    @Override
    protected void checkLanguage(String language) throws JRException {
        if (!"java".equals(language)) {
            throw new JRException("compilers.language.expected.java", language, "java");
        }
    }

    @Override
    protected JRCompilationSourceCode generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return JRClassGenerator.generateClass(sourceTask);
    }

    @Override
    protected String getSourceFileName(String unitName) {
        return unitName + ".java";
    }
}

