/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.tools;

import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.stage.PopupWindow;
import javafx.stage.Window;

public class Utils {
    public static Window getWindow(Object owner) throws IllegalArgumentException {
        if (owner == null) {
            Window window = null;
            ObservableList windows = Window.getWindows();
            for (Window w : windows) {
                window = w;
                if (!window.isFocused() || window instanceof PopupWindow) continue;
                return window;
            }
            return window;
        }
        if (owner instanceof Window) {
            return (Window)owner;
        }
        if (owner instanceof Node) {
            return ((Node)owner).getScene().getWindow();
        }
        throw new IllegalArgumentException("Unknown owner: " + owner.getClass());
    }

    public static final String getExcelLetterFromNumber(int number) {
        Object letter = "";
        while (number >= 0) {
            int remainder = number % 26;
            letter = (char)(remainder + 65) + (String)letter;
            number = number / 26 - 1;
        }
        return letter;
    }

    public static double clamp(double min, double value, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double nearest(double less, double value, double more) {
        double lessDiff = value - less;
        double moreDiff = more - value;
        if (lessDiff < moreDiff) {
            return less;
        }
        return more;
    }
}

