/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.guiserver;

import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.layout.metadata.EntityTypeMetaData;
import com.namasoft.common.utilities.LoggingConfigurator;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.GeneralSettings;
import com.namasoft.contracts.common.dtos.ModuleDescription;
import com.namasoft.contracts.common.dtos.requests.ServiceRequest;
import com.namasoft.contracts.common.dtos.results.ListResult;
import com.namasoft.contracts.common.services.CoreUtilitiesWS;
import com.namasoft.contracts.common.services.CoreWS;
import com.namasoft.contracts.common.services.UnifiedEntityWS;
import com.namasoft.contracts.util.DefaultApplicationInfo;
import com.namasoft.contracts.util.GUIApplicationInfo;
import com.namasoft.erp.guiserver.NamaClassAdapter;
import com.namasoft.erp.guiserver.ServiceAddress;
import com.namasoft.erp.guiserver.ServiceUtility;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

@XmlRootElement(name="guiAppConifg")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class NamaGUIAppConfig {
    private static NamaGUIAppConfig instance;
    private static final Object instanceLock;
    private List<ServiceAddress> services = new ArrayList<ServiceAddress>();
    private Class<? extends GUIApplicationInfo> guiInfoProviderClass;
    private List<ModuleDescription> availableModules = null;
    private ListResult<ModuleDescription> availableModulesResults;
    private static ConcurrentHashMap<Class, String> addressesByClassMap;
    private static ConcurrentHashMap<String, Class> classesByEntityTypeMap;

    public NamaGUIAppConfig() {
    }

    public NamaGUIAppConfig(List<ServiceAddress> services) {
        this.services = services;
    }

    @XmlElementWrapper(name="services")
    @XmlElement(name="service")
    public List<ServiceAddress> getServices() {
        return this.services;
    }

    public void setServices(List<ServiceAddress> services) {
        this.services = services;
    }

    @XmlJavaTypeAdapter(value=NamaClassAdapter.class)
    public Class<? extends GUIApplicationInfo> getGuiInfoProviderClass() {
        return this.guiInfoProviderClass;
    }

    public void setGuiInfoProviderClass(Class<? extends GUIApplicationInfo> guiInfoProviderClass) {
        this.guiInfoProviderClass = guiInfoProviderClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamaGUIAppConfig instance() {
        Object object = instanceLock;
        synchronized (object) {
            if (instance == null) {
                instance = new NamaGUIAppConfig();
                instance.setGuiInfoProviderClass(DefaultApplicationInfo.class);
                instance.getServices().add(new ServiceAddress(CoreWS.class, GeneralSettings.getServerAddress() + "basic-services/" + CoreWS.class.getSimpleName().toLowerCase()));
                instance.getServices().add(new ServiceAddress(UnifiedEntityWS.class, GeneralSettings.getServerAddress() + "basic-services/" + UnifiedEntityWS.class.getSimpleName().toLowerCase()));
                instance.getServices().add(new ServiceAddress(CoreUtilitiesWS.class, GeneralSettings.getServerAddress() + "basic-services/" + CoreUtilitiesWS.class.getSimpleName().toLowerCase()));
            }
            return instance;
        }
    }

    private static void initializeAddressesMap(boolean forceUpdate) {
        if (addressesByClassMap != null && classesByEntityTypeMap != null && !forceUpdate) {
            instance.loadAvailableModules(new ServiceRequest());
            return;
        }
        addressesByClassMap = new ConcurrentHashMap();
        classesByEntityTypeMap = new ConcurrentHashMap();
        for (ServiceAddress address : NamaGUIAppConfig.instance().getServices()) {
            addressesByClassMap.put(address.getKlass(), address.getAddress());
            if (!ObjectChecker.isNotEmptyOrNull((Object)address.getEntityType())) continue;
            classesByEntityTypeMap.put(address.getEntityType(), address.getKlass());
        }
    }

    public String getAddress(Class class1) {
        if (addressesByClassMap != null && addressesByClassMap.get(class1) != null) {
            return addressesByClassMap.get(class1);
        }
        NamaGUIAppConfig.initializeAddressesMap(false);
        return addressesByClassMap.get(class1);
    }

    public Class getEntityClass(String entityType) {
        NamaGUIAppConfig.initializeAddressesMap(false);
        return classesByEntityTypeMap.get(entityType);
    }

    @XmlTransient
    public GUIApplicationInfo getGuiInfoProvider() {
        try {
            return this.getGuiInfoProviderClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<ModuleDescription> getAvailableModules() {
        this.loadAvailableModules(new ServiceRequest());
        return this.availableModules;
    }

    public ModuleDescription getModuleDescription(String moduleName) {
        this.loadAvailableModules(new ServiceRequest());
        if (this.availableModules == null) {
            return null;
        }
        for (ModuleDescription moduleDescription : this.availableModules) {
            if (!moduleName.equalsIgnoreCase(moduleDescription.getModuleId())) continue;
            return moduleDescription;
        }
        return null;
    }

    public void updateAvailableModules(List<ModuleDescription> availableModules) {
        if (availableModules == null) {
            availableModules = new ArrayList<ModuleDescription>();
        }
        this.availableModules = availableModules;
        this.updateServiceAddresses();
    }

    private void updateServiceAddresses() {
        for (ModuleDescription moduleDescription : this.availableModules) {
            if (moduleDescription.getModuleAddress() == null || moduleDescription.getModuleAddress().getModuleFullAddress() == null) continue;
            Object moduleFullAddress = moduleDescription.getModuleAddress().getModuleFullAddress();
            String serverAddress = GeneralSettings.getServerAddress();
            if (ObjectChecker.isNotEmptyOrNull((Object)serverAddress)) {
                moduleFullAddress = serverAddress + StringUtils.substringAfterLast((String)moduleFullAddress, (String)"/");
                moduleDescription.getModuleAddress().setModuleFullAddress((String)moduleFullAddress);
            }
            for (EntityTypeMetaData entityTypeMetaData : moduleDescription.getEntitiesMetaData().getEntityTypesMetaData()) {
                ServiceAddress serviceAddress = new ServiceAddress();
                String serviceUrl = (String)moduleFullAddress + "/" + entityTypeMetaData.getServiceName();
                serviceAddress.setAddress(serviceUrl);
                serviceAddress.setEntityType(entityTypeMetaData.getEntityType());
                if (ObjectChecker.isEmptyOrNull((Object)entityTypeMetaData.getServiceClassName())) continue;
                try {
                    serviceAddress.setKlass(Class.forName(entityTypeMetaData.getServiceClassName()));
                    serviceAddress.setTheDTOKlassName(entityTypeMetaData.getTheDTOKlassName());
                    this.services.add(serviceAddress);
                }
                catch (ClassNotFoundException e) {
                    if (!LoggingConfigurator.isInDebugMode() || LoggingConfigurator.isInPOS()) continue;
                    NaMaLogger.serviceError((Throwable)new NaMaServiceExcepption("Unknown Class:" + entityTypeMetaData.getServiceClassName()));
                }
            }
        }
        NamaGUIAppConfig.initializeAddressesMap(true);
    }

    public ListResult<ModuleDescription> loadAvailableModules(ServiceRequest serviceRequest) {
        if (this.availableModulesResults == null || this.availableModulesResults.getList() == null || this.availableModulesResults.getList().isEmpty()) {
            CoreWS webService = ServiceUtility.getServiceClient(CoreWS.class);
            this.availableModulesResults = webService.getAvailableModules(serviceRequest);
            NamaGUIAppConfig.instance().updateAvailableModules(this.availableModulesResults.getList());
        }
        return this.availableModulesResults;
    }

    public String getEntityModuleId(String entityType) {
        for (ModuleDescription moduleDescription : this.getAvailableModules()) {
            if (moduleDescription.getEntitiesMetaData().getEntity(entityType) != null) {
                return moduleDescription.getEntitiesMetaData().getModuleId();
            }
            if (moduleDescription.getEntitiesMetaData().getSimpleEntity(entityType) == null) continue;
            return moduleDescription.getEntitiesMetaData().getModuleId();
        }
        return null;
    }

    public static void reset() {
        instance = null;
        addressesByClassMap = null;
        classesByEntityTypeMap = null;
    }

    static {
        instanceLock = new Object();
    }
}

