/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.guiserver;

import com.namasoft.common.constants.Language;
import com.namasoft.common.utils.GeneralSettings;
import com.namasoft.common.utils.PropertyGetterInterceptor;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.DTOUser;
import com.namasoft.contracts.common.dtos.LoginInfoInitializer;
import com.namasoft.contracts.common.dtos.LoginResult;
import com.namasoft.contracts.common.dtos.requests.LoginRequest;
import com.namasoft.contracts.common.dtos.requests.ServiceRequest;
import com.namasoft.contracts.common.services.CoreWS;
import com.namasoft.erp.guiserver.ServiceUtility;

public class ServiceLoginProvider {
    private static String passwordHash;
    private static String apiKey;
    private static LoginResult currentLogInInfo;
    private static String serverURL;
    private static boolean trackLogs;
    private static String applicationName;
    private static Language language;

    public static void setLanguage(Language language) {
        ServiceLoginProvider.language = language;
    }

    public static void setServerURL(String serverURL) {
        ServiceLoginProvider.serverURL = serverURL;
    }

    public static void loginIfNotLoggedIn(String url, String password, String userName) {
        ServiceLoginProvider.loginIfNotLoggedIn(url, password, userName, null);
    }

    public static void loginIfNotLoggedIn(String url, String password, String userName, String apiKey) {
        if (currentLogInInfo != null && currentLogInInfo.getUserInfo() != null) {
            return;
        }
        ServiceLoginProvider.login(url, password, userName, apiKey);
    }

    public static void login(String url, String password, String userName) {
        ServiceLoginProvider.login(url, password, userName, null);
    }

    public static void login(String url, String password, String userName, String apiKey) {
        serverURL = url;
        passwordHash = ServerStringUtils.hash((String)password);
        ServiceLoginProvider.apiKey = apiKey;
        LoginRequest request = new LoginRequest(userName, passwordHash);
        request.setApiKey(apiKey);
        currentLogInInfo = ServiceUtility.getServiceClient(CoreWS.class).login(request);
    }

    public static void setTrackLogs(boolean trackLogs) {
        ServiceLoginProvider.trackLogs = trackLogs;
    }

    public static boolean getTrackLogs() {
        return trackLogs;
    }

    public static DTOUser getDTOUser() {
        return currentLogInInfo == null ? null : currentLogInInfo.getUserInfo();
    }

    static {
        trackLogs = false;
        language = Language.English;
        GeneralSettings.addInterceptor((PropertyGetterInterceptor)new PropertyGetterInterceptor(){

            public boolean wouldIntercept(String id) {
                return "server".equalsIgnoreCase(id.trim());
            }

            public String getProperty(String id, String defaultValue) {
                return serverURL;
            }
        });
        ServiceRequest.setLoginInfoInitializer((LoginInfoInitializer)new LoginInfoInitializer(){

            public void initializeLoginInfo(ServiceRequest request) {
                request.setClientId(applicationName);
                request.setExpectedServerVersion("7");
                request.setLang(language);
                request.setTrackLogs(Boolean.valueOf(trackLogs));
                if (currentLogInInfo != null) {
                    request.setDimensionsIds(currentLogInInfo.getDimensions());
                    request.setLoginId(currentLogInInfo.getUserInfo().getLoginId());
                    request.setPasswordHash(passwordHash);
                    request.setApiKey(apiKey);
                    request.setUserId(currentLogInInfo.getUserInfo().getId());
                    request.setOtpId(currentLogInInfo.getOtpId());
                }
            }
        });
    }
}

