/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.guiserver;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.TaskTracker;
import com.namasoft.common.criteria.DTOCriteria;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.flatobjects.DTOGUITask;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.flatobjects.IDTOTask;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.GeneralSettings;
import com.namasoft.contracts.common.dtos.ModuleDescription;
import com.namasoft.contracts.common.dtos.PagedDTOTabularResult;
import com.namasoft.contracts.common.dtos.requests.ByCodeRequest;
import com.namasoft.contracts.common.dtos.requests.SearchRequest;
import com.namasoft.contracts.common.dtos.requests.ServiceRequest;
import com.namasoft.contracts.common.dtos.requests.TabularRequest;
import com.namasoft.contracts.common.dtos.results.DTOTabularResult;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.contracts.common.services.BaseEntityServiceProxy;
import com.namasoft.contracts.common.services.CoreUtilitiesWS;
import com.namasoft.contracts.common.services.ModuleWS;
import com.namasoft.contracts.common.services.UnifiedEntityWS;
import com.namasoft.contracts.common.services.base.EntityService;
import com.namasoft.contracts.common.services.base.NaMaUtilityWS;
import com.namasoft.erp.guiserver.DTOClassesProvider;
import com.namasoft.erp.guiserver.NamaGUIAppConfig;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import com.namasoft.specialserialization.ReflectionScanningUtil;
import com.namasoft.specialserialization.ReflectionUtils;
import com.namasoft.specialserialization.ScanningUtils;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.soap.SOAPBinding;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPException;

public class ServiceUtility
implements ReflectionScanningUtil {
    private static HashMap proxies = new HashMap();
    private static HashMap<String, BaseEntityServiceProxy> unifiedWrappers;
    private static String analysisSetId;
    private static String sectorId;
    private static String branchId;
    private static String departmentId;
    private static long receiveTimeout;
    private static long connectionTimeout;
    private static Object lock;

    public static long getReceiveTimeout() {
        return receiveTimeout;
    }

    public static void setReceiveTimeout(long receiveTimeout) {
        ServiceUtility.receiveTimeout = receiveTimeout;
    }

    public static long getConnectionTimeout() {
        return connectionTimeout;
    }

    public static void setConnectionTimeout(long connectionTimeout) {
        ServiceUtility.connectionTimeout = connectionTimeout;
    }

    public static <ServiceClass> Class<ServiceClass> getEntityServiceClass(String entityType) {
        return NamaGUIAppConfig.instance().getEntityClass(entityType);
    }

    public static <ServiceClass> ServiceClass getServiceClient(String entityType) {
        return ServiceUtility.getServiceClient(entityType, null);
    }

    public static <ServiceClass> ServiceClass getServiceClient(String entityType, String address) {
        Object key = entityType;
        if (ObjectChecker.isNotEmptyOrNull((Object)address)) {
            key = entityType + "-" + address;
        }
        ServiceUtility.setupUnifiedWrpperProxies();
        BaseEntityServiceProxy proxy = unifiedWrappers.get(key);
        if (proxy == null && ObjectChecker.isNotEmptyOrNull((Object)address) && (proxy = unifiedWrappers.get(entityType)) != null) {
            proxy = (BaseEntityServiceProxy)ObjectCreatorUtil.creator(proxy.getClass()).create();
            unifiedWrappers.put((String)key, proxy);
        }
        UnifiedEntityWS handler = ServiceUtility.getServiceClient(UnifiedEntityWS.class, address);
        if (proxy == null) {
            String msg = "The entity type " + entityType + " is not supported, please confirm the module contracts dependency is loaded correctly";
            NaMaServiceExcepption exception = new NaMaServiceExcepption(msg);
            exception.setFaultInfo(ResultDTO.fail((String)msg));
            throw exception;
        }
        proxy.setHandler(handler);
        return (ServiceClass)proxy;
    }

    public static ModuleWS getModuleServiceClient(String moduleName) {
        return ServiceUtility.getUtilityServiceClient(ModuleWS.class, moduleName);
    }

    public static List<DTOTabularResult> searchFor(String moduleName, String ownerTpe, List<String> columnsToget, DTOCriteria criteria, int recordsCount, String orderBy) {
        ModuleWS moduleWS;
        if (ObjectChecker.isEmptyOrNull(columnsToget)) {
            return null;
        }
        if (criteria == null) {
            criteria = new DTOCriteria();
        }
        if ((moduleWS = ServiceUtility.getModuleServiceClient(moduleName)) == null) {
            return null;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)ownerTpe)) {
            criteria.setOwnerType(ownerTpe);
        }
        SearchRequest searchRequest = SearchRequest.createValueObjectSearchRequest((String)ownerTpe, (DTOCriteria)criteria, columnsToget, (int)recordsCount);
        searchRequest.getSearchResultSettings().setSortByColumn(columnsToget.get(0));
        searchRequest.getSearchResultSettings().setSortByColumn(orderBy);
        PagedDTOTabularResult pagedTabularResult = moduleWS.searchFor(searchRequest);
        List retList = pagedTabularResult.getList();
        if (!pagedTabularResult.getResult().isSucceded()) {
            return null;
        }
        return retList;
    }

    public static List<DTOTabularResult> searchFor(String moduleName, String ownerTpe, List<String> columnsToget, DTOCriteria criteria, int recordsCount) {
        return ServiceUtility.searchFor(moduleName, ownerTpe, columnsToget, criteria, recordsCount, "");
    }

    public static List<DTOTabularResult> getColumns(String entityType, DTOCriteria criteria, String ... columns) {
        EntityService service = (EntityService)ServiceUtility.getServiceClient(entityType);
        return service.tabularListPage(new TabularRequest(entityType, null, Arrays.asList(columns), null, null, 0, -1, criteria)).getList();
    }

    public static <ServiceClass> ServiceClass getUtilityServiceClient(Class<ServiceClass> serviceClass) {
        return ServiceUtility.getUtilityServiceClient(serviceClass, "basic");
    }

    public static <ServiceClass> ServiceClass getUtilityServiceClient(Class<ServiceClass> serviceClass, String moduleName) {
        moduleName = "basic";
        if (ServiceUtility.getProxies().containsKey(moduleName + String.valueOf(serviceClass))) {
            return (ServiceClass)ServiceUtility.getProxies().get(moduleName + String.valueOf(serviceClass));
        }
        ServiceClass proxy = ServiceUtility.createUtilityServiceClient(serviceClass, moduleName);
        ServiceUtility.getProxies().put(moduleName + String.valueOf(serviceClass), proxy);
        return proxy;
    }

    public static <ServiceClass> ServiceClass getServiceClient(Class<ServiceClass> serviceClass) {
        return ServiceUtility.getServiceClient(serviceClass, null);
    }

    public static <ServiceClass> ServiceClass getServiceClient(Class<ServiceClass> serviceClass, String address) {
        if (BaseEntityServiceProxy.class.isAssignableFrom(serviceClass)) {
            BaseEntityServiceProxy proxy = (BaseEntityServiceProxy)ObjectCreatorUtil.creator(serviceClass).create();
            return ServiceUtility.getServiceClient(proxy.getServiceEntityType(), address);
        }
        Object key = serviceClass;
        if (ObjectChecker.isNotEmptyOrNull((Object)address)) {
            key = serviceClass.getName() + "-" + address;
        }
        if (ServiceUtility.getProxies().containsKey(key)) {
            return (ServiceClass)ServiceUtility.getProxies().get(key);
        }
        ServiceClass proxy = ObjectChecker.isEmptyOrNull((Object)address) ? ServiceUtility.createServiceClient(serviceClass) : ServiceUtility.createRemoteServiceClient(serviceClass, address);
        ServiceUtility.getProxies().put(key, proxy);
        return proxy;
    }

    private static <ServiceClass> ServiceClass createServiceClient(Class<ServiceClass> serviceClass) {
        String address = NamaGUIAppConfig.instance().getAddress(serviceClass);
        if (address == null) {
            throw new NullPointerException("Service class not included in service addresses list: " + String.valueOf(serviceClass));
        }
        return ServiceUtility.createServiceClient(serviceClass, address);
    }

    public static <ServiceClass> ServiceClass createRemoteServiceClient(Class<ServiceClass> serviceClass, String remoteServer) {
        return ServiceUtility.createRemoteServiceClient(serviceClass, remoteServer, false);
    }

    public static <ServiceClass> ServiceClass createRemoteServiceClient(Class<ServiceClass> serviceClass, String remoteServer, boolean noTimeOut) {
        Object address;
        if (!((String)remoteServer).endsWith("/")) {
            remoteServer = (String)remoteServer + "/";
        }
        if ((address = NamaGUIAppConfig.instance().getAddress(serviceClass)) == null && NaMaUtilityWS.class.isAssignableFrom(serviceClass)) {
            ModuleDescription moduleDescription = NamaGUIAppConfig.instance().getModuleDescription("basic");
            address = moduleDescription.getModuleAddress().getModuleFullAddress() + "/" + serviceClass.getSimpleName().toLowerCase();
        }
        address = ((String)address).replace(GeneralSettings.getServerAddress(), (CharSequence)remoteServer);
        return ServiceUtility.createServiceClient(serviceClass, (String)address, noTimeOut);
    }

    private static <ServiceClass> ServiceClass createUtilityServiceClient(Class<ServiceClass> serviceClass, String moduleName) {
        ModuleDescription moduleDescription = NamaGUIAppConfig.instance().getModuleDescription(moduleName);
        if (moduleDescription == null) {
            throw new NullPointerException("Service class " + String.valueOf(serviceClass) + " for service module " + moduleName);
        }
        return ServiceUtility.createServiceClient(serviceClass, moduleDescription.getModuleAddress().getModuleFullAddress() + "/" + serviceClass.getSimpleName().toLowerCase());
    }

    public static <ServiceClass> ServiceClass createServiceClient(Class<ServiceClass> serviceClass, String address) {
        return ServiceUtility.createServiceClient(serviceClass, address, true);
    }

    public static <ServiceClass> ServiceClass createServiceClient(Class<ServiceClass> serviceClass, String address, boolean noTimeOut) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        boolean logginOn = ObjectChecker.isTrue((String)GeneralSettings.getProperty((String)"logws", (String)"false"));
        if (logginOn) {
            factory.getInInterceptors().add(new LoggingInInterceptor(new PrintWriter(System.err)));
            factory.getOutInterceptors().add(new LoggingOutInterceptor(new PrintWriter(System.out)));
        }
        if (serviceClass == UnifiedEntityWS.class) {
            if (factory.getProperties() == null) {
                factory.setProperties(new HashMap());
            }
            factory.getProperties().put("jaxb.additionalContextClasses", new DTOClassesProvider().getKlasses());
        }
        factory.setServiceClass(serviceClass);
        factory.setAddress(address);
        Object proxy = factory.create();
        Client cl = ClientProxy.getClient((Object)proxy);
        Conduit conduit = cl.getConduit();
        if (noTimeOut && conduit instanceof HTTPConduit) {
            ((HTTPConduit)conduit).getClient().setReceiveTimeout(0L);
        }
        if (conduit instanceof HTTPConduit) {
            HTTPConduit httpConduit = (HTTPConduit)conduit;
            if (connectionTimeout > 0L) {
                httpConduit.getClient().setConnectionTimeout(connectionTimeout);
            }
            if (receiveTimeout > 0L) {
                httpConduit.getClient().setReceiveTimeout(receiveTimeout);
            }
        }
        BindingProvider bp = (BindingProvider)proxy;
        SOAPBinding binding = (SOAPBinding)bp.getBinding();
        binding.setMTOMEnabled(true);
        return (ServiceClass)proxy;
    }

    public static void setRecieveTimeOut(Object proxy, int timeOut) {
        try {
            Client cl = ClientProxy.getClient((Object)proxy);
            Conduit conduit = cl.getConduit();
            if (conduit instanceof HTTPConduit) {
                ((HTTPConduit)conduit).getClient().setReceiveTimeout((long)timeOut);
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Object)"Could not set timeout", (Throwable)e);
        }
    }

    public static boolean isHttpError(Throwable e) {
        return e.getCause().getCause().getCause() instanceof HTTPException;
    }

    public static String getPublicAnalysisSetId() {
        if (ObjectChecker.isEmptyOrNull((Object)analysisSetId)) {
            analysisSetId = ServiceUtility.findPublicId("AnalysisSet");
        }
        return analysisSetId;
    }

    private static String findPublicId(String entityType) {
        EntityService service = (EntityService)ServiceUtility.getServiceClient(entityType);
        GetResult findRefByBusinessCode = service.findRefByBusinessCode(new ByCodeRequest(entityType, "PUBLIC"));
        if (findRefByBusinessCode != null && findRefByBusinessCode.getData() != null) {
            return ((EntityReferenceData)findRefByBusinessCode.getData()).getId();
        }
        return "";
    }

    public static String getPublicSectorId() {
        if (ObjectChecker.isEmptyOrNull((Object)sectorId)) {
            sectorId = ServiceUtility.findPublicId("Sector");
        }
        return sectorId;
    }

    public static String getPublicBranchId() {
        if (ObjectChecker.isEmptyOrNull((Object)branchId)) {
            branchId = ServiceUtility.findPublicId("Branch");
        }
        return branchId;
    }

    public static String getPublicDeptId() {
        if (ObjectChecker.isEmptyOrNull((Object)departmentId)) {
            departmentId = ServiceUtility.findPublicId("Department");
        }
        return departmentId;
    }

    public static HashMap getStaticProxies() {
        return proxies;
    }

    public static HashMap getProxies() {
        return ServiceUtility.getStaticProxies();
    }

    public static <ServiceClass> ServiceClass getServiceClientWrapper(String entityType) {
        return ServiceUtility.getServiceClient(entityType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupUnifiedWrpperProxies() {
        if (ObjectChecker.isNotEmptyOrNull(unifiedWrappers)) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            new ServiceUtility().doSetup();
        }
    }

    public static DTOGUITask createTask(String description) {
        ServiceRequest currentRequest = new ServiceRequest();
        CoreUtilitiesWS ws = ServiceUtility.getUtilityServiceClient(CoreUtilitiesWS.class);
        EntityReferenceData user = new EntityReferenceData("User", currentRequest.getLoginId());
        try {
            user = (EntityReferenceData)ws.fetchCurrentUserAsRef(new ServiceRequest()).getData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DTOGUITask(new Date(), user, description, currentRequest.getIp());
    }

    public static DTOGUITask addTask(String description) {
        return (DTOGUITask)TaskTracker.addTask((IDTOTask)ServiceUtility.createTask(description));
    }

    public void doSetup() {
        Set proxies = ScanningUtils.getSubTypesOf(BaseEntityServiceProxy.class);
        ReflectionUtils.removeAbstractClasses((Collection)proxies);
        unifiedWrappers = new HashMap();
        for (Class klass : proxies) {
            BaseEntityServiceProxy proxy = (BaseEntityServiceProxy)ObjectCreatorUtil.creator((Class)klass).create();
            unifiedWrappers.put(proxy.getServiceEntityType(), proxy);
        }
    }

    public int order() {
        return 1;
    }

    static {
        analysisSetId = "";
        sectorId = "";
        branchId = "";
        departmentId = "";
        receiveTimeout = 0L;
        connectionTimeout = 5000L;
        lock = new Object();
    }
}

