package com.namasoft.common;

import java.util.HashMap;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class ActionResult extends ServiceResponse
{
	private static final long serialVersionUID = 6252304989575559660L;
	private HashMap<String, Object> actionResult = new HashMap<String, Object>();

	public ActionResult()
	{
		super();
	}

	public ActionResult(ResultDTO result)
	{
		super(result);
	}

	public HashMap<String, Object> getActionResult()
	{
		return actionResult;
	}

	public void setActionResult(HashMap<String, Object> parameters)
	{
		this.actionResult = parameters;
	}

	public static ActionResult createFailureResult(String englishMessage, String arabicMessage, Object... arguments)
	{
		ActionResult actionResult = new ActionResult();
		ResultDTO failureResult = new ResultDTO();
		failureResult.setEnglishMessage(englishMessage);
		failureResult.setArabicMessage(arabicMessage);
		failureResult.setSucceded(false);
		actionResult.setResult(failureResult);
		return actionResult;
	}
}
