package com.namasoft.common;

import java.util.ArrayList;
import java.util.List;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.Converter;
import com.namasoft.common.utilities.Matcher;
import com.namasoft.common.utilities.ObjectChecker;

public class HasIDUtil
{
	@SuppressWarnings("rawtypes")
	private static Matcher idMatcher = new Matcher()
	{

		@Override
		public boolean match(Object hasId, Object id)
		{
			if (hasId == null)
				return false;

			if (hasId instanceof HasId)
				return ObjectChecker.areEqual(((HasId) hasId).getId(), id);
			return false;
		}
	};

	public static <T extends HasId> T find(String id, List<T> list)
	{
		if (ObjectChecker.isNotEmptyOrNull(list))
		{
			for (T obj : list)
				if (ObjectChecker.areEqual(id, obj.getId()))
					return obj;
		}
		return null;
	}

	public static int indexOf(String id, List<? extends HasId> list)
	{
		if (ObjectChecker.isNotEmptyOrNull(list))
		{
			for (int i = 0; i < list.size(); i++)
				if (ObjectChecker.areEqual(id, list.get(i).getId()))
					return i;
		}
		return -1;
	}

	public static <T extends HasId> List<T> getSubList(List<T> source, List<String> ids)
	{
		List<T> subList = new ArrayList<T>();
		if (ObjectChecker.isEmptyOrNull(ids))
			return subList;
		for (String id : ids)
		{
			T find = find(id, source);
			if (find != null)
				subList.add(find);
		}
		return subList;
	}

	public static <T extends HasId> List<String> getIds(List<T> list)
	{
		return CollectionsUtility.convert(list, new Converter<T, String>()
		{
			@Override
			public String convert(T object)
			{
				return object == null ? "" : object.getId();
			}
		});
	}

	@SuppressWarnings("rawtypes")
	public static int smartFind(List details, String id, int start)
	{
		return CollectionsUtility.smartFind(details, id, start, idMatcher);
	}

	public static <T extends HasId> void addIfNotFound(List<T> l1, List<T> l2)
	{
		if (ObjectChecker.isEmptyOrNull(l2))
			return;
		for (T t : l2)
		{
			if (find(t.getId(), l1) == null)
				l1.add(t);
		}
	}

	public static void removeAll(String id, List<? extends HasId> list)
	{
		if (ObjectChecker.isEmptyOrNull(list))
			return;
		for (int i = list.size() - 1; i >= 0; i--)
			if (ObjectChecker.areEqual(id, list.get(i).getId()))
				list.remove(i);
	}
}
