package com.namasoft.common;

import com.namasoft.common.utilities.ObjectChecker;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface HasId
{
	String getId();

	Function<Object, HasId> TO_STRING_AS_HAS_ID = s -> (HasId) () -> ObjectChecker.toStringOrEmpty(s);

	static List<HasId> objectListToStringAsHasIdList(List<?> l)
	{
		if (l == null)
			return new ArrayList<>();
		return l.stream().map(TO_STRING_AS_HAS_ID).collect(Collectors.toList());
	}
}
