package com.namasoft.common;

import com.namasoft.common.utilities.ObjectChecker;

import java.util.Arrays;

public class Pair<X, Y> implements Comparable<Pair<X, Y>>
{
	private X x;
	private Y y;

	public Pair(X x, Y y)
	{
		super();
		this.x = x;
		this.y = y;
	}

	public X getX()
	{
		return x;
	}

	public void setX(X x)
	{
		this.x = x;
	}

	public Y getY()
	{
		return y;
	}

	public void setY(Y y)
	{
		this.y = y;
	}

	@Override
	public int hashCode()
	{
		return Arrays.asList(getX(), getY()).hashCode();
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj instanceof Pair)
			return ObjectChecker.arePairsEqual(getX(), ((Pair) obj).getX(), getY(), ((Pair) obj).getY());
		return super.equals(obj);
	}

	public static <X, Y> Pair<X, Y> of(X x, Y y)
	{
		return new Pair<>(x, y);
	}

	@Override
	public String toString()
	{
		return "Pair{" + "x=" + x + ", y=" + y + '}';
	}

	@Override
	public int compareTo(Pair<X, Y> o)
	{
		int xCompare = ((Comparable) getX()).compareTo(o.getX());
		if (xCompare != 0)
			return xCompare;
		int yCompare = ((Comparable) getY()).compareTo(o.getY());
		return yCompare;
	}
}
