package com.namasoft.common;

import com.namasoft.common.utilities.*;

import jakarta.xml.bind.annotation.*;
import java.util.*;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class ResultDTO extends NaMaDTO
{
	/**
	 *
	 */
	private static final long serialVersionUID = 9024047414335131240L;
	private String englishMessage;
	private String arabicMessage;
	private String source;
	private String sourceType;
	private String errorType;
	boolean succeded;
	boolean warning;
	private List<ResultDTO> innerResults;
	private Integer sourceLineNumber;
	private List<DTOConfirmation> confirmations;
	private String log;
	private String relatedToOption;
	private String relatedToOptionType;
	private String relatedToOptionTypeId;
	private String relatedToOptionCode;
	private String originalMessage;
	private String rawMessage;
	private Map<String, String> extraInfo;
	private Boolean alwaysShowRelatedTo;
	public ResultDTO()
	{
		this("", "", "", "", "", true, false);

	}

	public ResultDTO(String englishMessage, String arabicMessage, String source, String sourceType, String errorType, boolean succeded,
			boolean warning)
	{
		setEnglishMessage(englishMessage);
		setArabicMessage(arabicMessage);
		setSource(source);
		setSucceded(succeded);
		setWarning(warning);
		setSourceType(sourceType);
		setErrorType(errorType);
	}

	public String getEnglishMessage()
	{
		return englishMessage;
	}

	public void setEnglishMessage(String englishMessage)
	{
		this.englishMessage = englishMessage;
	}

	public String getArabicMessage()
	{
		return arabicMessage;
	}

	public void setArabicMessage(String arabicMessage)
	{
		this.arabicMessage = arabicMessage;
	}

	public String getSource()
	{
		return source;
	}

	public void setSource(String source)
	{
		this.source = source;
	}

	public String getSourceType()
	{
		return sourceType;
	}

	public void setSourceType(String sourceType)
	{
		this.sourceType = sourceType;
	}

	public String getErrorType()
	{
		return errorType;
	}

	public void setErrorType(String errorType)
	{
		this.errorType = errorType;
	}

	public boolean isSucceded()
	{
		return succeded;
	}

	public boolean isFailed()
	{
		return !succeded;
	}

	public void setSucceded(boolean succeded)
	{
		this.succeded = succeded;
	}

	public List<ResultDTO> getInnerResults()
	{
		return innerResults;
	}

	public void setInnerResults(List<ResultDTO> innerResults)
	{
		this.innerResults = innerResults;
	}

	public boolean isWarning()
	{
		return warning;
	}

	public void setWarning(boolean warning)
	{
		this.warning = warning;
	}

	public void addInnerResult(ResultDTO innerResult)
	{
		if (innerResult == null)
			return;
		if (getInnerResults() == null)
			setInnerResults(new ArrayList<>());
		if (!innerResult.isSucceded())
		{
			setSucceded(false);
		}
		if (innerResult.isWarning())
		{
			setWarning(true);
		}
		getInnerResults().add(innerResult);
	}

	public Integer getSourceLineNumber()
	{
		return sourceLineNumber;
	}

	public void setSourceLineNumber(Integer sourceLineNumber)
	{
		this.sourceLineNumber = sourceLineNumber;
	}

	public static ResultDTO success()
	{
		return new ResultDTO(null, null, null, null, null, true, false);
	}

	public static ResultDTO fail()
	{
		return new ResultDTO(null, null, null, null, null, false, false);
	}

	public static ResultDTO fail(String reason)
	{
		ResultDTO fail = fail();
		fail.setEnglishMessage(reason);
		fail.setArabicMessage(reason);
		return fail;
	}

	public static ResultDTO fail(String arabic, String english)
	{
		ResultDTO fail = fail();
		fail.setEnglishMessage(english);
		fail.setArabicMessage(arabic);
		return fail;
	}

	public void setLog(String log)
	{
		this.log = log;
	}

	public String getLog()
	{
		return log;
	}

	public List<DTOConfirmation> getConfirmations()
	{
		return confirmations;
	}

	public void setConfirmations(List<DTOConfirmation> confirmations)
	{
		this.confirmations = confirmations;
	}

	@XmlTransient
	public Boolean getFailed()
	{
		return !isSucceded();
	}

	public String getOriginalMessage()
	{
		return originalMessage;
	}

	public void setOriginalMessage(String originalMessage)
	{
		this.originalMessage = originalMessage;
	}

	public String getRawMessage()
	{
		return rawMessage;
	}

	public void setRawMessage(String rawMessage)
	{
		this.rawMessage = rawMessage;
	}

	public Map<String, String> getExtraInfo()
	{
		return extraInfo;
	}

	public void setExtraInfo(Map<String, String> extraInfo)
	{
		this.extraInfo = extraInfo;
	}

	public static List<ResultDTO> findLeafFailureResults(ResultDTO result)
	{
		List<ResultDTO> list = new ArrayList<>();
		findLeafFailureResults(result, list);
		return list;
	}

	private static void findLeafFailureResults(ResultDTO result, List<ResultDTO> failures)
	{
		if (result == null)
			return;
		if (ObjectChecker.isEmptyOrNull(result.getInnerResults()))
		{
			if (result.isFailed())
				failures.add(result);
			return;
		}
		for (ResultDTO innerResult : result.getInnerResults())
		{
			findLeafFailureResults(innerResult, failures);
		}
	}

	public String getRelatedToOption()
	{
		return relatedToOption;
	}

	public void setRelatedToOption(String relatedToOption)
	{
		this.relatedToOption = relatedToOption;
	}

	public String getRelatedToOptionType()
	{
		return relatedToOptionType;
	}

	public void setRelatedToOptionType(String relatedToOptionType)
	{
		this.relatedToOptionType = relatedToOptionType;
	}

	public String getRelatedToOptionCode()
	{
		return relatedToOptionCode;
	}

	public void setRelatedToOptionCode(String relatedToOptionCode)
	{
		this.relatedToOptionCode = relatedToOptionCode;
	}

	public String getRelatedToOptionTypeId()
	{
		return relatedToOptionTypeId;
	}

	public void setRelatedToOptionTypeId(String relatedToOptionTypeId)
	{
		this.relatedToOptionTypeId = relatedToOptionTypeId;
	}

	public Boolean getAlwaysShowRelatedTo()
	{
		return alwaysShowRelatedTo;
	}

	public void setAlwaysShowRelatedTo(Boolean alwaysShowRelatedTo)
	{
		this.alwaysShowRelatedTo = alwaysShowRelatedTo;
	}

	public void listAllNonEmptyErrorType(List<String> list)
	{
		if (ObjectChecker.isNotEmptyOrNull(getErrorType()))
			list.add(getErrorType());
		if (ObjectChecker.isEmptyOrNull(getInnerResults()))
			return;
		for (ResultDTO innerResult : getInnerResults())
		{
			innerResult.listAllNonEmptyErrorType(list);
		}
	}

	public List<String> listAllNonEmptyErrorType()
	{
		List<String> list = new ArrayList<>();
		listAllNonEmptyErrorType(list);
		return list;
	}

	public String fetchExtraInfo(String key)
	{
		if (getExtraInfo() == null)
			return null;
		return getExtraInfo().get(key);
	}
}
