package com.namasoft.common;
import com.namasoft.common.fieldids.newids.basic.*;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import com.namasoft.common.constants.DomainBaseEntities;
import com.namasoft.common.utilities.ObjectChecker;

public class SateLiteCodeUtil
{

	public static List<String> getCodeSateLiteFielIds(String entityType)
	{
		if (ObjectChecker.areEqual(entityType, DomainBaseEntities.DocumentBook))
			return l(IdsOfDocumentBook.documentType);
		else if (ObjectChecker.areEqual(entityType, DomainBaseEntities.DocumentTerm))
			return l(IdsOfDocumentTerm.documentType);
		else if (ObjectChecker.areEqual(entityType, DomainBaseEntities.MasterGroup))
			return l(IdsOfMasterGroup.forType);
		return Collections.emptyList();
	}

	private static List<String> l(String... strs)
	{
		return Arrays.asList(strs);
	}
}
